/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.utils;

import io.katharsis.resource.information.ResourceField;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class FieldOrderedComparator
implements Comparator<ResourceField> {
    private final Map<String, Integer> fieldNames = new HashMap<String, Integer>();
    private final boolean alphabetic;

    public FieldOrderedComparator(String[] orderedValues, boolean alphabetic) {
        this.alphabetic = alphabetic;
        this.init(orderedValues);
    }

    private void init(String[] orderedValues) {
        for (int i = 0; i < orderedValues.length; ++i) {
            this.fieldNames.put(orderedValues[i], i);
        }
    }

    @Override
    public int compare(ResourceField o1, ResourceField o2) {
        if (this.fieldNames.containsKey(o1.getJsonName())) {
            if (this.fieldNames.containsKey(o2.getJsonName())) {
                return this.fieldNames.get(o1.getJsonName()) - this.fieldNames.get(o2.getJsonName());
            }
            return -1;
        }
        if (this.alphabetic) {
            return o1.getJsonName().compareToIgnoreCase(o2.getJsonName());
        }
        return 1;
    }
}

