/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.boot.PropertiesProvider;
import io.katharsis.core.internal.resource.DocumentMapperUtil;
import io.katharsis.core.internal.resource.IncludeLookupSetter;
import io.katharsis.core.internal.resource.ResourceMapper;
import io.katharsis.errorhandling.ErrorData;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.resource.Document;
import io.katharsis.resource.Resource;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class DocumentMapper {
    private DocumentMapperUtil util;
    private ResourceMapper resourceMapper;
    private IncludeLookupSetter includeLookupSetter;
    private boolean client;

    public DocumentMapper(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider) {
        this(resourceRegistry, objectMapper, propertiesProvider, false);
    }

    public DocumentMapper(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, boolean client) {
        this.util = new DocumentMapperUtil(resourceRegistry, objectMapper);
        this.resourceMapper = this.newResourceMapper(this.util, client, objectMapper);
        this.includeLookupSetter = new IncludeLookupSetter(resourceRegistry, this.resourceMapper, propertiesProvider);
        this.client = client;
    }

    protected ResourceMapper newResourceMapper(DocumentMapperUtil util, boolean client, ObjectMapper objectMapper) {
        return new ResourceMapper(util, client, objectMapper);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter) {
        return this.toDocument(response, queryAdapter, null);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Set<String> eagerLoadedRelations = Collections.emptySet();
        return this.toDocument(response, queryAdapter, parameterProvider, eagerLoadedRelations);
    }

    public Document toDocument(JsonApiResponse response, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> additionalEagerLoadedRelations) {
        if (response == null) {
            return null;
        }
        Document doc = new Document();
        this.addErrors(doc, response.getErrors());
        this.util.setMeta(doc, response.getMetaInformation());
        this.util.setLinks(doc, response.getLinksInformation());
        this.addData(doc, response.getEntity(), queryAdapter);
        this.addRelationDataAndInclusions(doc, response.getEntity(), queryAdapter, parameterProvider, additionalEagerLoadedRelations);
        return doc;
    }

    private void addRelationDataAndInclusions(Document doc, Object entity, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Set<String> additionalEagerLoadedRelations) {
        if (doc.getData().isPresent() && !this.client) {
            this.includeLookupSetter.setIncludedElements(doc, entity, queryAdapter, parameterProvider, additionalEagerLoadedRelations);
        }
    }

    private void addData(Document doc, Object entity, QueryAdapter queryAdapter) {
        if (entity != null) {
            if (entity instanceof Iterable) {
                ArrayList<Resource> dataList = new ArrayList<Resource>();
                for (Object obj : (Iterable)entity) {
                    dataList.add(this.resourceMapper.toData(obj, queryAdapter));
                }
                doc.setData(Nullable.of(dataList));
            } else {
                doc.setData(Nullable.of(this.resourceMapper.toData(entity, queryAdapter)));
            }
        }
    }

    private void addErrors(Document doc, Iterable<ErrorData> errors) {
        if (errors != null) {
            ArrayList<ErrorData> errorList = new ArrayList<ErrorData>();
            for (ErrorData error : errors) {
                errorList.add(error);
            }
            doc.setErrors(errorList);
        }
    }
}

