/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.katharsis.errorhandling.ErrorData;
import java.io.IOException;

public class ErrorDataSerializer
extends JsonSerializer<ErrorData> {
    public static final String LINKS = "links";
    public static final String ID = "id";
    public static final String ABOUT_LINK = "about";
    public static final String STATUS = "status";
    public static final String CODE = "code";
    public static final String TITLE = "title";
    public static final String DETAIL = "detail";
    public static final String SOURCE = "source";
    public static final String POINTER = "pointer";
    public static final String PARAMETER = "parameter";
    public static final String META = "meta";

    public void serialize(ErrorData errorData, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        ErrorDataSerializer.writeStringIfExists(ID, errorData.getId(), gen);
        ErrorDataSerializer.writeAboutLink(errorData, gen);
        ErrorDataSerializer.writeStringIfExists(STATUS, errorData.getStatus(), gen);
        ErrorDataSerializer.writeStringIfExists(CODE, errorData.getCode(), gen);
        ErrorDataSerializer.writeStringIfExists(TITLE, errorData.getTitle(), gen);
        ErrorDataSerializer.writeStringIfExists(DETAIL, errorData.getDetail(), gen);
        ErrorDataSerializer.writeSource(errorData, gen);
        ErrorDataSerializer.writeMeta(errorData, gen);
        gen.writeEndObject();
    }

    private static void writeMeta(ErrorData errorData, JsonGenerator gen) throws IOException {
        if (errorData.getMeta() != null) {
            gen.writeObjectField(META, errorData.getMeta());
        }
    }

    private static void writeSource(ErrorData errorData, JsonGenerator gen) throws IOException {
        if (errorData.getSourceParameter() != null || errorData.getSourcePointer() != null) {
            gen.writeObjectFieldStart(SOURCE);
            ErrorDataSerializer.writeStringIfExists(POINTER, errorData.getSourcePointer(), gen);
            ErrorDataSerializer.writeStringIfExists(PARAMETER, errorData.getSourceParameter(), gen);
            gen.writeEndObject();
        }
    }

    private static void writeAboutLink(ErrorData errorData, JsonGenerator gen) throws IOException {
        if (errorData.getAboutLink() != null) {
            gen.writeObjectFieldStart(LINKS);
            gen.writeStringField(ABOUT_LINK, errorData.getAboutLink());
            gen.writeEndObject();
        }
    }

    private static void writeStringIfExists(String fieldName, String value, JsonGenerator gen) throws IOException {
        if (value != null) {
            gen.writeStringField(fieldName, value);
        }
    }

    public Class<ErrorData> handledType() {
        return ErrorData.class;
    }
}

