/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.exception;

import io.katharsis.core.internal.exception.DefaultExceptionMapperLookup;
import io.katharsis.core.internal.exception.ExceptionMapperLookup;
import io.katharsis.core.internal.exception.ExceptionMapperRegistry;
import io.katharsis.core.internal.exception.ExceptionMapperType;
import io.katharsis.core.internal.exception.KatharsisExceptionMapper;
import io.katharsis.errorhandling.mapper.ExceptionMapper;
import io.katharsis.errorhandling.mapper.JsonApiExceptionMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;

public final class ExceptionMapperRegistryBuilder {
    private final Set<ExceptionMapperType> exceptionMappers = new HashSet<ExceptionMapperType>();

    public ExceptionMapperRegistry build(String resourceSearchPackage) {
        return this.build(new DefaultExceptionMapperLookup(resourceSearchPackage));
    }

    public ExceptionMapperRegistry build(ExceptionMapperLookup exceptionMapperLookup) {
        this.addKatharsisDefaultMappers();
        for (JsonApiExceptionMapper exceptionMapper : exceptionMapperLookup.getExceptionMappers()) {
            this.registerExceptionMapper(exceptionMapper);
        }
        return new ExceptionMapperRegistry(this.exceptionMappers);
    }

    private void addKatharsisDefaultMappers() {
        this.registerExceptionMapper(new KatharsisExceptionMapper());
    }

    private void registerExceptionMapper(JsonApiExceptionMapper<? extends Throwable> exceptionMapper) {
        Class<? extends Throwable> exceptionClass = this.getGenericType(exceptionMapper.getClass());
        this.exceptionMappers.add(new ExceptionMapperType(exceptionClass, exceptionMapper));
    }

    private Class<? extends Throwable> getGenericType(Class<? extends JsonApiExceptionMapper> mapper) {
        Type[] types = mapper.getGenericInterfaces();
        if (null == types || 0 == types.length) {
            types = new Type[]{mapper.getGenericSuperclass()};
        }
        for (Type type : types) {
            if (!(type instanceof ParameterizedType) || !TypeUtils.isAssignable((Type)((ParameterizedType)type).getRawType(), JsonApiExceptionMapper.class) && !TypeUtils.isAssignable((Type)((ParameterizedType)type).getRawType(), ExceptionMapper.class)) continue;
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }
}

