/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.exception;

import io.katharsis.core.internal.exception.ExceptionMapperLookup;
import io.katharsis.errorhandling.exception.InvalidResourceException;
import io.katharsis.errorhandling.mapper.JsonApiExceptionMapper;
import io.katharsis.legacy.queryParams.errorhandling.ExceptionMapperProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;

public class DefaultExceptionMapperLookup
implements ExceptionMapperLookup {
    private List<String> resourceSearchPackages;

    public DefaultExceptionMapperLookup(String resourceSearchPackage) {
        this(resourceSearchPackage != null ? Arrays.asList(resourceSearchPackage.split(",")) : null);
    }

    public DefaultExceptionMapperLookup(List<String> resourceSearchPackages) {
        this.resourceSearchPackages = resourceSearchPackages;
    }

    @Override
    public Set<JsonApiExceptionMapper> getExceptionMappers() {
        Reflections reflections = this.resourceSearchPackages != null ? new Reflections(new Object[]{this.resourceSearchPackages}) : new Reflections(new Object[0]);
        Set exceptionMapperClasses = reflections.getTypesAnnotatedWith(ExceptionMapperProvider.class);
        HashSet<JsonApiExceptionMapper> exceptionMappers = new HashSet<JsonApiExceptionMapper>();
        for (Class exceptionMapperClazz : exceptionMapperClasses) {
            if (!JsonApiExceptionMapper.class.isAssignableFrom(exceptionMapperClazz)) {
                throw new InvalidResourceException(exceptionMapperClazz.getCanonicalName() + " is not an implementation of JsonApiExceptionMapper");
            }
            try {
                exceptionMappers.add((JsonApiExceptionMapper)exceptionMapperClazz.newInstance());
            }
            catch (Exception e) {
                throw new InvalidResourceException(exceptionMapperClazz.getCanonicalName() + " can not be initialized", e);
            }
        }
        return exceptionMappers;
    }
}

