/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher.controller;

import io.katharsis.core.internal.dispatcher.controller.BaseController;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.dispatcher.path.PathIds;
import io.katharsis.core.internal.dispatcher.path.RelationshipsPath;
import io.katharsis.core.internal.repository.adapter.RelationshipRepositoryAdapter;
import io.katharsis.core.internal.repository.adapter.ResourceRepositoryAdapter;
import io.katharsis.core.internal.utils.Generics;
import io.katharsis.errorhandling.exception.RequestBodyException;
import io.katharsis.errorhandling.exception.RequestBodyNotFoundException;
import io.katharsis.errorhandling.exception.ResourceFieldNotFoundException;
import io.katharsis.errorhandling.exception.ResourceNotFoundException;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.ResourceIdentifier;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.parser.TypeParser;
import java.io.Serializable;
import java.util.Collections;

public abstract class RelationshipsResourceUpsert
extends BaseController {
    private final ResourceRegistry resourceRegistry;
    final TypeParser typeParser;

    RelationshipsResourceUpsert(ResourceRegistry resourceRegistry, TypeParser typeParser) {
        this.resourceRegistry = resourceRegistry;
        this.typeParser = typeParser;
    }

    protected abstract HttpMethod method();

    protected abstract void processToManyRelationship(Object var1, Class<? extends Serializable> var2, ResourceField var3, Iterable<ResourceIdentifier> var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    protected abstract void processToOneRelationship(Object var1, Class<? extends Serializable> var2, ResourceField var3, ResourceIdentifier var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    @Override
    public final boolean isAcceptable(JsonPath jsonPath, String requestType) {
        return !jsonPath.isCollection() && RelationshipsPath.class.equals(jsonPath.getClass()) && this.method().name().equals(requestType);
    }

    @Override
    public final Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        String resourceName = jsonPath.getResourceName();
        PathIds resourceIds = jsonPath.getIds();
        RegistryEntry registryEntry = this.resourceRegistry.getEntry(resourceName);
        if (registryEntry == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        if (requestBody == null) {
            throw new RequestBodyNotFoundException(HttpMethod.POST, resourceName);
        }
        Serializable castedResourceId = this.getResourceId(resourceIds, registryEntry);
        ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(jsonPath.getElementName());
        if (relationshipField == null) {
            throw new ResourceFieldNotFoundException(jsonPath.getElementName());
        }
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
        Object resource = this.extractResource(resourceRepository.findOne(castedResourceId, queryAdapter));
        Class<?> baseRelationshipFieldClass = relationshipField.getType();
        Class<?> relationshipFieldClass = Generics.getResourceClass(relationshipField.getGenericType(), baseRelationshipFieldClass);
        Class<?> relationshipIdType = this.resourceRegistry.findEntry(relationshipFieldClass).getResourceInformation().getIdField().getType();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepositoryForClass(relationshipFieldClass, parameterProvider);
        if (Iterable.class.isAssignableFrom(baseRelationshipFieldClass)) {
            Iterable dataBodies = requestBody.isMultiple() ? requestBody.getData().get() : Collections.singletonList(requestBody.getData().get());
            this.processToManyRelationship(resource, relationshipIdType, relationshipField, dataBodies, queryAdapter, relationshipRepositoryForClass);
        } else {
            if (requestBody.isMultiple()) {
                throw new RequestBodyException(HttpMethod.POST, resourceName, "Multiple data in body");
            }
            ResourceIdentifier dataBody = (ResourceIdentifier)requestBody.getData().get();
            this.processToOneRelationship(resource, relationshipIdType, relationshipField, dataBody, queryAdapter, relationshipRepositoryForClass);
        }
        return new Response(new Document(), 204);
    }

    private Serializable getResourceId(PathIds resourceIds, RegistryEntry registryEntry) {
        String resourceId = resourceIds.getIds().get(0);
        Class<?> idClass = registryEntry.getResourceInformation().getIdField().getType();
        return this.typeParser.parse(resourceId, idClass);
    }
}

