/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.dispatcher.controller.ResourceIncludeField;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.dispatcher.path.PathIds;
import io.katharsis.core.internal.dispatcher.path.RelationshipsPath;
import io.katharsis.core.internal.repository.adapter.RelationshipRepositoryAdapter;
import io.katharsis.core.internal.resource.DocumentMapper;
import io.katharsis.core.internal.utils.Generics;
import io.katharsis.errorhandling.exception.ResourceFieldNotFoundException;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.Nullable;
import io.katharsis.utils.parser.TypeParser;
import java.io.Serializable;

public class RelationshipsResourceGet
extends ResourceIncludeField {
    public RelationshipsResourceGet(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, TypeParser typeParser, DocumentMapper documentMapper) {
        super(resourceRegistry, objectMapper, typeParser, documentMapper);
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String requestType) {
        return !jsonPath.isCollection() && jsonPath instanceof RelationshipsPath && HttpMethod.GET.name().equals(requestType);
    }

    @Override
    public Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        String resourceName = jsonPath.getResourceName();
        PathIds resourceIds = jsonPath.getIds();
        RegistryEntry registryEntry = this.resourceRegistry.getEntry(resourceName);
        Serializable castedResourceId = this.getResourceId(resourceIds, registryEntry);
        String elementName = jsonPath.getElementName();
        ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(elementName);
        if (relationshipField == null) {
            throw new ResourceFieldNotFoundException(elementName);
        }
        Class<?> baseRelationshipFieldClass = relationshipField.getType();
        Class<?> relationshipFieldClass = Generics.getResourceClass(relationshipField.getGenericType(), baseRelationshipFieldClass);
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepositoryForClass(relationshipFieldClass, parameterProvider);
        JsonApiResponse entities = Iterable.class.isAssignableFrom(baseRelationshipFieldClass) ? relationshipRepositoryForClass.findManyTargets(castedResourceId, relationshipField, queryAdapter) : relationshipRepositoryForClass.findOneTarget(castedResourceId, relationshipField, queryAdapter);
        Document responseDocument = this.documentMapper.toDocument(entities, queryAdapter, parameterProvider);
        if (!responseDocument.getData().isPresent()) {
            responseDocument.setData(Nullable.nullValue());
        }
        return new Response(responseDocument, 200);
    }

    private Serializable getResourceId(PathIds resourceIds, RegistryEntry registryEntry) {
        String resourceId = resourceIds.getIds().get(0);
        Class<?> idClass = registryEntry.getResourceInformation().getIdField().getType();
        return this.typeParser.parse(resourceId, idClass);
    }
}

