/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.mixin;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import kanela.agent.api.instrumentation.mixin.Initializer;
import kanela.agent.api.instrumentation.mixin.MixinClassVisitorWrapper;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;

public final class MixinDescription {
    private final Class<?> mixinClass;

    public static MixinDescription of(Class<?> clazz) {
        return new MixinDescription(clazz);
    }

    public AgentBuilder.Transformer makeTransformer() {
        return (builder, typeDescription, classLoader, module) -> {
            List interfaces = kanela.agent.libs.io.vavr.collection.List.ofAll(Arrays.asList(this.mixinClass.getInterfaces())).toSet().map(TypeDescription.ForLoadedType::new).toJavaList();
            return builder.implement(interfaces).visit(MixinClassVisitorWrapper.of(this, typeDescription, classLoader));
        };
    }

    public Option<String> getInitializerMethod() {
        return Option.ofOptional(Arrays.stream(this.mixinClass.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Initializer.class)).findFirst().map(Method::getName));
    }

    public MixinDescription(Class<?> mixinClass) {
        this.mixinClass = mixinClass;
    }

    public Class<?> getMixinClass() {
        return this.mixinClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MixinDescription)) {
            return false;
        }
        MixinDescription other = (MixinDescription)o;
        Class<?> this$mixinClass = this.getMixinClass();
        Class<?> other$mixinClass = other.getMixinClass();
        return !(this$mixinClass == null ? other$mixinClass != null : !this$mixinClass.equals(other$mixinClass));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $mixinClass = this.getMixinClass();
        result = result * 59 + ($mixinClass == null ? 43 : $mixinClass.hashCode());
        return result;
    }

    public String toString() {
        return "MixinDescription(mixinClass=" + this.getMixinClass() + ")";
    }
}

