/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog;

import kanela.agent.libs.org.pmw.tinylog.MessageFormatter;

public final class InternalLogger {
    private static final String PREFIX_WARNING = "LOGGER WARNING: ";
    private static final String PREFIX_ERROR = "LOGGER ERROR: ";
    private static volatile String lastLogEntry = null;

    private InternalLogger() {
    }

    public static void warn(String string) {
        String string2 = PREFIX_WARNING + string;
        if (!string2.equals(lastLogEntry)) {
            System.err.println(string2);
            lastLogEntry = string2;
        }
    }

    public static void warn(String string, Object ... objectArray) {
        InternalLogger.warn(MessageFormatter.format(string, objectArray));
    }

    public static void warn(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null || string.length() == 0) {
            InternalLogger.warn(throwable.getClass().getName());
        } else {
            InternalLogger.warn(string + " (" + throwable.getClass().getName() + ")");
        }
    }

    public static void warn(Throwable throwable, String string) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.length() == 0) {
            InternalLogger.warn(string + " (" + throwable.getClass().getName() + ")");
        } else {
            InternalLogger.warn(string + " (" + throwable.getClass().getName() + ": " + string2 + ")");
        }
    }

    public static void warn(Throwable throwable, String string, Object ... objectArray) {
        InternalLogger.warn(throwable, MessageFormatter.format(string, objectArray));
    }

    public static void error(String string) {
        String string2 = PREFIX_ERROR + string;
        if (!string2.equals(lastLogEntry)) {
            System.err.println(string2);
            lastLogEntry = string2;
        }
    }

    public static void error(String string, Object ... objectArray) {
        InternalLogger.error(MessageFormatter.format(string, objectArray));
    }

    public static void error(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null || string.length() == 0) {
            InternalLogger.error(throwable.getClass().getName());
        } else {
            InternalLogger.error(string + " (" + throwable.getClass().getName() + ")");
        }
    }

    public static void error(Throwable throwable, String string) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.length() == 0) {
            InternalLogger.error(string + " (" + throwable.getClass().getName() + ")");
        } else {
            InternalLogger.error(string + " (" + throwable.getClass().getName() + ": " + string2 + ")");
        }
    }

    public static void error(Throwable throwable, String string, Object ... objectArray) {
        InternalLogger.error(throwable, MessageFormatter.format(string, objectArray));
    }
}

