/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.builder;

import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import kanela.agent.api.instrumentation.TypeTransformation;
import kanela.agent.api.instrumentation.listener.DebugInstrumentationListener;
import kanela.agent.api.instrumentation.listener.DefaultInstrumentationListener;
import kanela.agent.api.instrumentation.listener.InstrumentationRegistryListener;
import kanela.agent.api.instrumentation.listener.dumper.ClassDumperListener;
import kanela.agent.cache.PoolStrategyCache;
import kanela.agent.libs.net.bytebuddy.ByteBuddy;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.NamedElement;
import kanela.agent.libs.net.bytebuddy.dynamic.loading.ClassInjector;
import kanela.agent.libs.net.bytebuddy.dynamic.scaffold.MethodGraph;
import kanela.agent.libs.net.bytebuddy.dynamic.scaffold.TypeValidation;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatchers;
import kanela.agent.resubmitter.PeriodicResubmitter;
import kanela.agent.util.ListBuilder;
import kanela.agent.util.classloader.ClassLoaderNameMatcher;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.log.Logger;

final class KanelaAgentBuilder {
    private final KanelaConfiguration config;
    private final KanelaConfiguration.ModuleConfiguration moduleDescription;
    private final Instrumentation instrumentation;
    private static final PoolStrategyCache poolStrategyCache = PoolStrategyCache.instance();
    private final ListBuilder<TypeTransformation> typeTransformations = ListBuilder.builder();

    public void addTypeTransformation(TypeTransformation typeTransformation) {
        InstrumentationRegistryListener.instance().register(this.moduleDescription, typeTransformation);
        this.typeTransformations.add(typeTransformation);
    }

    AgentBuilder build() {
        return this.typeTransformations.build().foldLeft(this.newAgentBuilder(), (agent, typeTransformation) -> {
            ArrayList<AgentBuilder.Transformer> transformers = new ArrayList<AgentBuilder.Transformer>();
            transformers.addAll(typeTransformation.getBridges());
            transformers.addAll(typeTransformation.getMixins());
            transformers.addAll(typeTransformation.getTransformations());
            for (AgentBuilder.Transformer transformer : transformers) {
                agent = agent.type(typeTransformation.getElementMatcher().get(), ClassLoaderNameMatcher.RefinedClassLoaderMatcher.from(typeTransformation.getClassLoaderRefiner())).transform(transformer);
            }
            return agent;
        });
    }

    private AgentBuilder newAgentBuilder() {
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(this.config.isDebugMode())).with(MethodGraph.Compiler.ForDeclaredMethods.INSTANCE);
        AgentBuilder agentBuilder = new AgentBuilder.Default(byteBuddy).with(poolStrategyCache);
        agentBuilder = this.withRetransformationForRuntime(agentBuilder);
        agentBuilder = this.withBootstrapAttaching(agentBuilder);
        agentBuilder = this.withIgnore(agentBuilder);
        return agentBuilder.with(DefaultInstrumentationListener.instance()).with(this.additionalListeners());
    }

    private AgentBuilder withRetransformationForRuntime(AgentBuilder agentBuilder) {
        if (this.config.isAttachedInRuntime() || this.moduleDescription.isStoppable() || this.moduleDescription.shouldInjectInBootstrap()) {
            Logger.info(() -> "Retransformation Strategy activated for: " + this.moduleDescription.getName());
            if (this.moduleDescription.isDisableClassFormatChanges()) {
                agentBuilder = agentBuilder.disableClassFormatChanges();
            }
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).withResubmission(PeriodicResubmitter.instance());
        }
        return agentBuilder;
    }

    private AgentBuilder withBootstrapAttaching(AgentBuilder agentBuilder) {
        if (this.moduleDescription.shouldInjectInBootstrap()) {
            Logger.info(() -> "Bootstrap Injection activated.");
            agentBuilder = agentBuilder.with(new AgentBuilder.InjectionStrategy.UsingUnsafe.OfFactory(ClassInjector.UsingUnsafe.Factory.resolve(this.instrumentation)));
        }
        return agentBuilder;
    }

    private AgentBuilder withIgnore(AgentBuilder agentBuilder) {
        AgentBuilder.Ignored builder = (AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)agentBuilder.ignore(this.ignoreMatches()).or(this.moduleExcludes())).or(ElementMatchers.any(), ElementMatchers.isExtensionClassLoader())).or(ElementMatchers.any(), ClassLoaderNameMatcher.isKanelaClassLoader())).or(ElementMatchers.any(), ClassLoaderNameMatcher.isGroovyClassLoader())).or(ElementMatchers.any(), ClassLoaderNameMatcher.isSBTClassLoader())).or(ElementMatchers.any(), ClassLoaderNameMatcher.isSBTPluginClassLoader())).or(ElementMatchers.any(), ClassLoaderNameMatcher.isSBTCompilerClassLoader())).or(ElementMatchers.any(), ClassLoaderNameMatcher.isSBTCachedClassLoader())).or(ElementMatchers.any(), ClassLoaderNameMatcher.isReflectionClassLoader());
        if (this.moduleDescription.shouldInjectInBootstrap()) {
            return builder;
        }
        return (AgentBuilder)builder.or(ElementMatchers.any(), ElementMatchers.isBootstrapClassLoader());
    }

    private AgentBuilder.Listener additionalListeners() {
        ArrayList<AgentBuilder.Listener.Adapter> listeners = new ArrayList<AgentBuilder.Listener.Adapter>();
        if (this.config.getDump().isDumpEnabled()) {
            listeners.add(ClassDumperListener.instance());
        }
        if (this.config.getDebugMode().booleanValue()) {
            listeners.add(DebugInstrumentationListener.instance());
        }
        if (this.config.getInstrumentationRegistryConfig().isEnabled()) {
            listeners.add(InstrumentationRegistryListener.instance());
        }
        return new AgentBuilder.Listener.Compound(listeners);
    }

    private ElementMatcher.Junction<NamedElement> ignoreMatches() {
        return ElementMatchers.not(ElementMatchers.nameMatches(this.moduleDescription.getWithinPackage()));
    }

    private ElementMatcher.Junction<NamedElement> moduleExcludes() {
        return ElementMatchers.nameMatches(this.moduleDescription.getExcludePackage());
    }

    private KanelaAgentBuilder(KanelaConfiguration config, KanelaConfiguration.ModuleConfiguration moduleDescription, Instrumentation instrumentation) {
        this.config = config;
        this.moduleDescription = moduleDescription;
        this.instrumentation = instrumentation;
    }

    public static KanelaAgentBuilder from(KanelaConfiguration config, KanelaConfiguration.ModuleConfiguration moduleDescription, Instrumentation instrumentation) {
        return new KanelaAgentBuilder(config, moduleDescription, instrumentation);
    }

    public KanelaConfiguration getConfig() {
        return this.config;
    }

    public KanelaConfiguration.ModuleConfiguration getModuleDescription() {
        return this.moduleDescription;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public ListBuilder<TypeTransformation> getTypeTransformations() {
        return this.typeTransformations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KanelaAgentBuilder)) {
            return false;
        }
        KanelaAgentBuilder other = (KanelaAgentBuilder)o;
        KanelaConfiguration this$config = this.getConfig();
        KanelaConfiguration other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        KanelaConfiguration.ModuleConfiguration this$moduleDescription = this.getModuleDescription();
        KanelaConfiguration.ModuleConfiguration other$moduleDescription = other.getModuleDescription();
        if (this$moduleDescription == null ? other$moduleDescription != null : !((Object)this$moduleDescription).equals(other$moduleDescription)) {
            return false;
        }
        Instrumentation this$instrumentation = this.getInstrumentation();
        Instrumentation other$instrumentation = other.getInstrumentation();
        if (this$instrumentation == null ? other$instrumentation != null : !this$instrumentation.equals(other$instrumentation)) {
            return false;
        }
        ListBuilder<TypeTransformation> this$typeTransformations = this.getTypeTransformations();
        ListBuilder<TypeTransformation> other$typeTransformations = other.getTypeTransformations();
        return !(this$typeTransformations == null ? other$typeTransformations != null : !this$typeTransformations.equals(other$typeTransformations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KanelaConfiguration $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        KanelaConfiguration.ModuleConfiguration $moduleDescription = this.getModuleDescription();
        result = result * 59 + ($moduleDescription == null ? 43 : ((Object)$moduleDescription).hashCode());
        Instrumentation $instrumentation = this.getInstrumentation();
        result = result * 59 + ($instrumentation == null ? 43 : $instrumentation.hashCode());
        ListBuilder<TypeTransformation> $typeTransformations = this.getTypeTransformations();
        result = result * 59 + ($typeTransformations == null ? 43 : $typeTransformations.hashCode());
        return result;
    }

    public String toString() {
        return "KanelaAgentBuilder(config=" + this.getConfig() + ", moduleDescription=" + this.getModuleDescription() + ", instrumentation=" + this.getInstrumentation() + ", typeTransformations=" + this.getTypeTransformations() + ")";
    }
}

