/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.bootstrap.stack;

import java.util.HashMap;
import java.util.Map;

public final class CallStackDepth {
    private static final ThreadLocal<Map<Object, Integer>> StackDepthThreadLocal = ThreadLocal.withInitial(HashMap::new);

    public static int incrementFor(Object key) {
        Map<Object, Integer> stackDepthMap = StackDepthThreadLocal.get();
        if (stackDepthMap.containsKey(key)) {
            return stackDepthMap.compute(key, (k, v) -> v + 1);
        }
        return stackDepthMap.computeIfAbsent(key, v -> 0);
    }

    public static void resetFor(Object obj) {
        StackDepthThreadLocal.get().remove(obj);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof CallStackDepth;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "CallStackDepth()";
    }
}

