/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import kanela.agent.broker.EventBroker;
import kanela.agent.libs.io.vavr.Value;
import kanela.agent.libs.io.vavr.collection.List;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.util.annotation.Experimental;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.jvm.GcEvent;
import kanela.agent.util.jvm.Jvm;
import kanela.agent.util.log.Logger;

@Experimental
public final class OldGarbageCollectorListener {
    private final Jvm tools;
    private final long jvmStartTime;
    private final EventBroker broker;
    private final Option<MemoryPoolMXBean> oldGenPool;
    private final KanelaConfiguration.OldGarbageCollectorConfig config;

    private OldGarbageCollectorListener(KanelaConfiguration.OldGarbageCollectorConfig configuration, Jvm jvm) {
        List<MemoryPoolMXBean> memoryBeans = List.ofAll(ManagementFactory.getMemoryPoolMXBeans());
        this.jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        this.oldGenPool = memoryBeans.find(Jvm::isOldGenPool);
        this.tools = jvm;
        this.config = configuration;
        this.broker = EventBroker.instance();
        this.startListening();
    }

    public static void attach(KanelaConfiguration.OldGarbageCollectorConfig configuration, Jvm jvm) {
        if (configuration.isCircuitBreakerRunning()) {
            Try.of(() -> new OldGarbageCollectorListener(configuration, jvm)).andThen(() -> Logger.info(() -> MessageFormat.format("Old Garbage Collector Listener activated.", new Object[0]))).onFailure(cause -> Logger.error(() -> MessageFormat.format("Error when trying to activate Old Garbage Collector Listener.", new Object[0]), cause));
        }
    }

    public static void attach(KanelaConfiguration.OldGarbageCollectorConfig config) {
        OldGarbageCollectorListener.attach(config, Jvm.instance());
    }

    private void startListening() {
        GcNotificationListener notificationListener = new GcNotificationListener();
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            emitter.addNotificationListener(notificationListener, null, null);
        }
    }

    private void processGCEvent(GarbageCollectionNotificationInfo info) {
        if (this.tools.isEndOfMayorGC(info.getGcAction())) {
            Map<String, MemoryUsage> after = info.getGcInfo().getMemoryUsageAfterGc();
            Value percentageFreeMemory = this.oldGenPool.map(pool -> {
                long totalMemoryAfterGc = ((MemoryUsage)after.get(pool.getName())).getMax();
                long usedMemoryAfterGc = ((MemoryUsage)after.get(pool.getName())).getUsed();
                double freeMemoryGc = ((double)totalMemoryAfterGc - (double)usedMemoryAfterGc) / (double)totalMemoryAfterGc;
                return 100.0 * freeMemoryGc;
            });
            percentageFreeMemory.forEach(freeMemory -> {
                GcEvent event = GcEvent.from(info, freeMemory, this.jvmStartTime + info.getGcInfo().getStartTime());
                if (this.config.isShouldLogAfterGc()) {
                    Logger.warn(() -> MessageFormat.format("{0}", event));
                }
                this.broker.publish(event);
            });
        }
    }

    public Jvm getTools() {
        return this.tools;
    }

    public long getJvmStartTime() {
        return this.jvmStartTime;
    }

    public EventBroker getBroker() {
        return this.broker;
    }

    public Option<MemoryPoolMXBean> getOldGenPool() {
        return this.oldGenPool;
    }

    public KanelaConfiguration.OldGarbageCollectorConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OldGarbageCollectorListener)) {
            return false;
        }
        OldGarbageCollectorListener other = (OldGarbageCollectorListener)o;
        if (this.getJvmStartTime() != other.getJvmStartTime()) {
            return false;
        }
        Jvm this$tools = this.getTools();
        Jvm other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        EventBroker this$broker = this.getBroker();
        EventBroker other$broker = other.getBroker();
        if (this$broker == null ? other$broker != null : !((Object)this$broker).equals(other$broker)) {
            return false;
        }
        Option<MemoryPoolMXBean> this$oldGenPool = this.getOldGenPool();
        Option<MemoryPoolMXBean> other$oldGenPool = other.getOldGenPool();
        if (this$oldGenPool == null ? other$oldGenPool != null : !((Object)this$oldGenPool).equals(other$oldGenPool)) {
            return false;
        }
        KanelaConfiguration.OldGarbageCollectorConfig this$config = this.getConfig();
        KanelaConfiguration.OldGarbageCollectorConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $jvmStartTime = this.getJvmStartTime();
        result = result * 59 + (int)($jvmStartTime >>> 32 ^ $jvmStartTime);
        Jvm $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        EventBroker $broker = this.getBroker();
        result = result * 59 + ($broker == null ? 43 : ((Object)$broker).hashCode());
        Option<MemoryPoolMXBean> $oldGenPool = this.getOldGenPool();
        result = result * 59 + ($oldGenPool == null ? 43 : ((Object)$oldGenPool).hashCode());
        KanelaConfiguration.OldGarbageCollectorConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    public String toString() {
        return "OldGarbageCollectorListener(tools=" + this.getTools() + ", jvmStartTime=" + this.getJvmStartTime() + ", broker=" + this.getBroker() + ", oldGenPool=" + this.getOldGenPool() + ", config=" + this.getConfig() + ")";
    }

    private class GcNotificationListener
    implements NotificationListener {
        private GcNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            String type = notification.getType();
            if (type.equals("com.sun.management.gc.notification")) {
                CompositeData userData = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(userData);
                OldGarbageCollectorListener.this.processGCEvent(info);
            }
        }
    }
}

