/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util;

import java.net.URL;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kanela.agent.util.Jar;
import kanela.agent.util.Lang;
import kanela.agent.util.log.Logger;

public final class BuiltInModuleLoader {
    private static final Pattern instrumentationPattern = Pattern.compile("kanela/agent/instrumentations/(.*).jar");
    private static final Pattern filterScalaPattern = Pattern.compile(".*_[0-9]\\.[0-9]+\\.jar");

    public static URL[] findModules() {
        return Jar.searchWith(instrumentationPattern).map(BuiltInModuleLoader::collectAll).map(BuiltInModuleLoader::urlsToJars).onFailure(cause -> Logger.error(() -> "Error when trying to Load build-in instrumentation modules.", cause)).getOrElse(new URL[0]);
    }

    private static URL[] urlsToJars(List<String> urls) {
        return (URL[])kanela.agent.libs.io.vavr.collection.List.ofAll(urls).map(url -> Jar.getEmbeddedFile("/" + url)).flatMap(Function.identity()).toJavaArray(URL[]::new);
    }

    private static List<String> collectAll(List<String> modules) {
        return Lang.getRunningScalaVersion().map(scalaVersion -> BuiltInModuleLoader.filterScalaModules(scalaVersion, modules)).getOrElse(modules.stream().filter(moduleName -> filterScalaPattern.matcher((CharSequence)moduleName).matches()).collect(Collectors.toList()));
    }

    private static List<String> filterScalaModules(String scalaVersion, List<String> scalaModules) {
        return scalaModules.stream().filter(moduleName -> moduleName.matches(BuiltInModuleLoader.scalaRegexVersion(scalaVersion))).collect(Collectors.toList());
    }

    private static String scalaRegexVersion(String scalaVersion) {
        return ".*/[^/]*_" + scalaVersion.replace(".", "\\.") + "[^/]*.*";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof BuiltInModuleLoader;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BuiltInModuleLoader()";
    }
}

