/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kanela.agent.libs.org.pmw.tinylog.Configuration;
import kanela.agent.libs.org.pmw.tinylog.Configurator;
import kanela.agent.libs.org.pmw.tinylog.EnvironmentHelper;
import kanela.agent.libs.org.pmw.tinylog.InternalLogger;
import kanela.agent.libs.org.pmw.tinylog.LegacyLogEntry;
import kanela.agent.libs.org.pmw.tinylog.Level;
import kanela.agent.libs.org.pmw.tinylog.LogEntry;
import kanela.agent.libs.org.pmw.tinylog.LoggingContext;
import kanela.agent.libs.org.pmw.tinylog.MessageFormatter;
import kanela.agent.libs.org.pmw.tinylog.PreciseLogEntry;
import kanela.agent.libs.org.pmw.tinylog.StackTraceInformation;
import kanela.agent.libs.org.pmw.tinylog.Supplier;
import kanela.agent.libs.org.pmw.tinylog.Token;
import kanela.agent.libs.org.pmw.tinylog.UndatedLogEntry;
import kanela.agent.libs.org.pmw.tinylog.runtime.RuntimeDialect;
import kanela.agent.libs.org.pmw.tinylog.writers.LogEntryValue;
import kanela.agent.libs.org.pmw.tinylog.writers.Writer;

public final class Logger {
    static final int DEPTH_OF_STACK_TRACE = 3;
    private static final boolean JAVA_OR_NEWER = EnvironmentHelper.isAtLeastJava9();
    private static final String NEW_LINE = EnvironmentHelper.getNewLine();
    private static final RuntimeDialect dialect = EnvironmentHelper.getRuntimeDialect();
    private static volatile Configuration configuration = Configurator.defaultConfig().create();

    private Logger() {
    }

    public static Level getLevel() {
        return configuration.getLevel();
    }

    public static Level getLevel(Package package_) {
        return configuration.getLevel(package_.getName());
    }

    public static Level getLevel(Class<?> clazz) {
        return configuration.getLevel(clazz.getName());
    }

    public static Level getLevel(String string) {
        return configuration.getLevel(string);
    }

    public static void trace(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, object, null);
        }
    }

    public static void trace(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, (Object)string, null);
        }
    }

    public static void trace(Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, supplier, null);
        }
    }

    public static void trace(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, (Object)string, objectArray);
        }
    }

    public static void trace(String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, (Object)string, (Object[])supplierArray);
        }
    }

    public static void trace(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, throwable, null, null);
        }
    }

    public static void trace(Throwable throwable, String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, throwable, (Object)string, null);
        }
    }

    public static void trace(Throwable throwable, Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, throwable, supplier, null);
        }
    }

    public static void trace(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, throwable, (Object)string, objectArray);
        }
    }

    public static void trace(Throwable throwable, String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, throwable, (Object)string, (Object[])supplierArray);
        }
    }

    public static void debug(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, object, null);
        }
    }

    public static void debug(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, (Object)string, null);
        }
    }

    public static void debug(Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, supplier, null);
        }
    }

    public static void debug(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, (Object)string, objectArray);
        }
    }

    public static void debug(String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, (Object)string, (Object[])supplierArray);
        }
    }

    public static void debug(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, throwable, null, null);
        }
    }

    public static void debug(Throwable throwable, String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, throwable, (Object)string, null);
        }
    }

    public static void debug(Throwable throwable, Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, throwable, supplier, null);
        }
    }

    public static void debug(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, throwable, (Object)string, objectArray);
        }
    }

    public static void debug(Throwable throwable, String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, throwable, (Object)string, (Object[])supplierArray);
        }
    }

    public static void info(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, object, null);
        }
    }

    public static void info(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, (Object)string, null);
        }
    }

    public static void info(Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, supplier, null);
        }
    }

    public static void info(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, (Object)string, objectArray);
        }
    }

    public static void info(String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, (Object)string, (Object[])supplierArray);
        }
    }

    public static void info(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, throwable, null, null);
        }
    }

    public static void info(Throwable throwable, String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, throwable, (Object)string, null);
        }
    }

    public static void info(Throwable throwable, Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, throwable, supplier, null);
        }
    }

    public static void info(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, throwable, (Object)string, objectArray);
        }
    }

    public static void info(Throwable throwable, String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, throwable, (Object)string, (Object[])supplierArray);
        }
    }

    public static void warn(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, object, null);
        }
    }

    public static void warn(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, (Object)string, null);
        }
    }

    public static void warn(Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, supplier, null);
        }
    }

    public static void warn(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, (Object)string, objectArray);
        }
    }

    public static void warn(String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, (Object)string, (Object[])supplierArray);
        }
    }

    public static void warn(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, throwable, null, null);
        }
    }

    public static void warn(Throwable throwable, String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, throwable, (Object)string, null);
        }
    }

    public static void warn(Throwable throwable, Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, throwable, supplier, null);
        }
    }

    public static void warn(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, throwable, (Object)string, objectArray);
        }
    }

    public static void warn(Throwable throwable, String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, throwable, (Object)string, (Object[])supplierArray);
        }
    }

    public static void error(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, object, null);
        }
    }

    public static void error(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, (Object)string, null);
        }
    }

    public static void error(Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, supplier, null);
        }
    }

    public static void error(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, (Object)string, objectArray);
        }
    }

    public static void error(String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, (Object)string, (Object[])supplierArray);
        }
    }

    public static void error(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, throwable, null, null);
        }
    }

    public static void error(Throwable throwable, String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, throwable, (Object)string, null);
        }
    }

    public static void error(Throwable throwable, Supplier<?> supplier) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, throwable, supplier, null);
        }
    }

    public static void error(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, throwable, (Object)string, objectArray);
        }
    }

    public static void error(Throwable throwable, String string, Supplier<?> ... supplierArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, throwable, (Object)string, (Object[])supplierArray);
        }
    }

    public static Configurator getConfiguration() {
        return configuration.getConfigurator();
    }

    static void setConfiguration(Configuration configuration) throws Exception {
        Configuration configuration2 = Logger.configuration;
        if (configuration2 == null) {
            for (Writer writer : configuration.getWriters()) {
                writer.init(configuration);
            }
        } else {
            List<Writer> list = configuration.getWriters();
            List<Writer> list2 = configuration2.getWriters();
            for (Writer writer : list) {
                if (list2.contains(writer)) continue;
                writer.init(configuration);
            }
        }
        Logger.configuration = configuration;
    }

    static void output(int n, Level level, Throwable throwable, Object object, Object[] objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(level)) {
            Logger.output(configuration, n, level, throwable, object, objectArray);
        }
    }

    static void output(StackTraceElement stackTraceElement, Level level, Throwable throwable, Object object, Object[] objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(level)) {
            Logger.output(configuration, stackTraceElement, level, throwable, object, objectArray);
        }
    }

    private static void output(Configuration configuration, int n, Level level, Throwable throwable, Object object, Object[] objectArray) {
        StackTraceElement stackTraceElement = null;
        Level level2 = configuration.getLevel();
        if (configuration.hasCustomLevels()) {
            boolean bl = configuration.getRequiredStackTraceInformation(level) == StackTraceInformation.CLASS_NAME;
            stackTraceElement = bl ? Logger.asStackTraceElement(dialect.getClassName(n)) : dialect.getStackTraceElement(n);
            level2 = configuration.getLevel(stackTraceElement.getClassName());
        }
        if (level2.ordinal() <= level.ordinal()) {
            try {
                Writer[] writerArray = configuration.getEffectiveWriters(level);
                LogEntry[] logEntryArray = Logger.createLogEntries(configuration, n + 1, level, stackTraceElement, throwable, object, objectArray);
                if (configuration.getWritingThread() == null) {
                    for (int i = 0; i < writerArray.length; ++i) {
                        try {
                            writerArray[i].write(logEntryArray[i]);
                            continue;
                        }
                        catch (Exception exception) {
                            InternalLogger.error(exception, "Failed to write log entry");
                        }
                    }
                } else {
                    for (int i = 0; i < writerArray.length; ++i) {
                        configuration.getWritingThread().putLogEntry(writerArray[i], logEntryArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                InternalLogger.error(exception, "Failed to create log entry");
            }
        }
    }

    private static void output(Configuration configuration, StackTraceElement stackTraceElement, Level level, Throwable throwable, Object object, Object[] objectArray) {
        Level level2 = configuration.getLevel();
        if (configuration.hasCustomLevels()) {
            level2 = configuration.getLevel(stackTraceElement.getClassName());
        }
        if (level2.ordinal() <= level.ordinal()) {
            try {
                Writer[] writerArray = configuration.getEffectiveWriters(level);
                LogEntry[] logEntryArray = Logger.createLogEntries(configuration, -1, level, stackTraceElement, throwable, object, objectArray);
                if (configuration.getWritingThread() == null) {
                    for (int i = 0; i < writerArray.length; ++i) {
                        try {
                            writerArray[i].write(logEntryArray[i]);
                            continue;
                        }
                        catch (Exception exception) {
                            InternalLogger.error(exception, "Failed to write log entry");
                        }
                    }
                } else {
                    for (int i = 0; i < writerArray.length; ++i) {
                        configuration.getWritingThread().putLogEntry(writerArray[i], logEntryArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                InternalLogger.error(exception, "Failed to create log entry");
            }
        }
    }

    private static StackTraceElement asStackTraceElement(String string) {
        return new StackTraceElement(string, "<unknown>", "<unknown>", -1);
    }

    /*
     * WARNING - void declaration
     */
    private static LogEntry[] createLogEntries(Configuration configuration, int n, Level level, StackTraceElement stackTraceElement, Throwable throwable, Object object, Object[] objectArray) {
        Set<LogEntryValue> set = configuration.getRequiredLogEntryValues(level);
        List<Token>[] listArray = configuration.getEffectiveFormatTokens(level);
        LogEntry[] logEntryArray = new LogEntry[listArray.length];
        boolean bl = false;
        Comparable<Instant> comparable = null;
        String string = null;
        Thread thread = null;
        Map<String, String> map = null;
        StackTraceElement stackTraceElement2 = stackTraceElement;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = -1;
        String string5 = null;
        block12: for (LogEntryValue object2 : set) {
            block0 : switch (object2) {
                case DATE: {
                    if (set.contains((Object)LogEntryValue.PRECISE_DATE)) break;
                    comparable = new Date();
                    break;
                }
                case PRECISE_DATE: {
                    if (JAVA_OR_NEWER) {
                        bl = true;
                        comparable = Instant.now();
                        break;
                    }
                    comparable = new Date();
                    break;
                }
                case PROCESS_ID: {
                    string = dialect.getProcessId();
                    break;
                }
                case THREAD: {
                    thread = Thread.currentThread();
                    break;
                }
                case CONTEXT: {
                    map = LoggingContext.getMapping();
                    break;
                }
                case CLASS: {
                    int n3;
                    if (stackTraceElement2 == null) {
                        n3 = configuration.getRequiredStackTraceInformation(level) == StackTraceInformation.CLASS_NAME ? 1 : 0;
                        stackTraceElement2 = n3 != 0 ? Logger.asStackTraceElement(dialect.getClassName(n)) : dialect.getStackTraceElement(n);
                    }
                    string2 = stackTraceElement2.getClassName();
                    n3 = string2.indexOf("$", 0);
                    while (n3 != -1) {
                        if (n3 >= string2.length() - 1) {
                            string2 = string2.substring(0, n3);
                            break block0;
                        }
                        char c = string2.charAt(n3 + 1);
                        if (c < 'A' || c > 'Z') {
                            string2 = string2.substring(0, n3);
                            break block0;
                        }
                        n3 = string2.indexOf(36, n3 + 2);
                    }
                    continue block12;
                }
                case METHOD: {
                    if (stackTraceElement2 == null) {
                        stackTraceElement2 = dialect.getStackTraceElement(n);
                    }
                    string3 = stackTraceElement2.getMethodName();
                    break;
                }
                case FILE: {
                    if (stackTraceElement2 == null) {
                        stackTraceElement2 = dialect.getStackTraceElement(n);
                    }
                    string4 = stackTraceElement2.getFileName();
                    break;
                }
                case LINE: {
                    if (stackTraceElement2 == null) {
                        stackTraceElement2 = dialect.getStackTraceElement(n);
                    }
                    n2 = stackTraceElement2.getLineNumber();
                    break;
                }
                case MESSAGE: {
                    if (object == null) break;
                    if (object instanceof String) {
                        string5 = MessageFormatter.format((String)object, objectArray);
                        break;
                    }
                    if (object instanceof Supplier) {
                        Object t = ((Supplier)object).get();
                        if (t == null) continue block12;
                        string5 = t.toString();
                        break;
                    }
                    string5 = object.toString();
                    break;
                }
            }
        }
        for (int i = 0; i < logEntryArray.length; ++i) {
            void var22_28;
            if (comparable == null) {
                UndatedLogEntry undatedLogEntry = new UndatedLogEntry(string, thread, map, string2, string3, string4, n2, level, string5, throwable);
            } else if (bl) {
                PreciseLogEntry preciseLogEntry = new PreciseLogEntry((Instant)comparable, string, thread, map, string2, string3, string4, n2, level, string5, throwable);
            } else {
                LegacyLogEntry legacyLogEntry = new LegacyLogEntry((Date)comparable, string, thread, map, string2, string3, string4, n2, level, string5, throwable);
            }
            List<Token> list = listArray[i];
            if (list != null) {
                StringBuilder stringBuilder = new StringBuilder(throwable == null ? 256 : 1024);
                for (Token token : list) {
                    token.render((LogEntry)var22_28, stringBuilder);
                }
                stringBuilder.append(NEW_LINE);
                var22_28.setRenderedLogEntry(stringBuilder.toString());
            }
            logEntryArray[i] = var22_28;
        }
        return logEntryArray;
    }

    static {
        Configurator.init().activate();
    }
}

