/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.resubmitter;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kanela.agent.libs.io.vavr.Function0;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.util.NamedThreadFactory;
import kanela.agent.util.ShutdownHook;
import kanela.agent.util.log.Logger;

public final class PeriodicResubmitter {
    private static final Function0<AgentBuilder.RedefinitionStrategy.ResubmissionScheduler> resubmitting = PeriodicResubmitter.newResubmitting().memoized();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(NamedThreadFactory.instance("periodic-resubmitter-scheduler"));
    private static final long TIMEOUT = 10L;

    private PeriodicResubmitter() {
    }

    public static AgentBuilder.RedefinitionStrategy.ResubmissionScheduler instance() {
        return resubmitting.apply();
    }

    private static Function0<AgentBuilder.RedefinitionStrategy.ResubmissionScheduler> newResubmitting() {
        return () -> {
            Logger.info(() -> "Periodic Resubmitter activated.");
            ShutdownHook.register(executor);
            return new AgentBuilder.RedefinitionStrategy.ResubmissionScheduler.WithFixedDelay(executor, 10L, TimeUnit.SECONDS);
        };
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof PeriodicResubmitter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PeriodicResubmitter()";
    }
}

