/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog.writers;

import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Set;
import kanela.agent.libs.org.pmw.tinylog.Configuration;
import kanela.agent.libs.org.pmw.tinylog.Level;
import kanela.agent.libs.org.pmw.tinylog.LogEntry;
import kanela.agent.libs.org.pmw.tinylog.writers.LogEntryValue;
import kanela.agent.libs.org.pmw.tinylog.writers.PropertiesSupport;
import kanela.agent.libs.org.pmw.tinylog.writers.Property;
import kanela.agent.libs.org.pmw.tinylog.writers.Writer;

@PropertiesSupport(name="console", properties={@Property(name="stream", type=String.class, optional=true)})
public final class ConsoleWriter
implements Writer {
    private final PrintStream err;
    private final PrintStream out;

    public ConsoleWriter() {
        this.err = System.err;
        this.out = System.out;
    }

    public ConsoleWriter(PrintStream printStream) {
        this.err = printStream;
        this.out = printStream;
    }

    ConsoleWriter(String string) {
        if (string == null) {
            this.err = System.err;
            this.out = System.out;
        } else if ("err".equalsIgnoreCase(string)) {
            this.err = System.err;
            this.out = System.err;
        } else if ("out".equalsIgnoreCase(string)) {
            this.err = System.out;
            this.out = System.out;
        } else {
            throw new IllegalArgumentException("Stream must be \"out\" or \"err\", \"" + string + "\" is not a valid stream name");
        }
    }

    @Override
    public Set<LogEntryValue> getRequiredLogEntryValues() {
        return EnumSet.of(LogEntryValue.LEVEL, LogEntryValue.RENDERED_LOG_ENTRY);
    }

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public void write(LogEntry logEntry) {
        this.getPrintStream(logEntry.getLevel()).print(logEntry.getRenderedLogEntry());
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private PrintStream getPrintStream(Level level) {
        if (level == Level.ERROR || level == Level.WARNING) {
            return this.err;
        }
        return this.out;
    }
}

