/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.listener.dumper;

import java.io.File;
import kanela.agent.libs.io.vavr.CheckedFunction0;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;
import kanela.agent.libs.net.bytebuddy.dynamic.DynamicType;
import kanela.agent.libs.net.bytebuddy.utility.JavaModule;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.log.Logger;

public final class ClassDumperListener
extends AgentBuilder.Listener.Adapter {
    private static final ClassDumperListener Instance = new ClassDumperListener();
    private final File dumpDir;
    private final File jarFile;
    private final KanelaConfiguration.DumpConfig config = KanelaConfiguration.instance().getDump();

    private ClassDumperListener() {
        this.dumpDir = new File(this.config.getDumpDir());
        this.jarFile = new File(this.config.getDumpDir() + File.separator + this.config.getJarName() + ".jar");
    }

    public static ClassDumperListener instance() {
        return Instance;
    }

    @Override
    public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
        this.addClassToDump(dynamicType);
    }

    private void addClassToDump(DynamicType dynamicType) {
        if (!this.dumpDir.exists()) {
            this.runSafe(this.dumpDir::mkdirs, "Error creating directory...");
        }
        if (this.config.getCreateJar().booleanValue()) {
            if (!this.jarFile.exists()) {
                this.runSafe(this.jarFile::createNewFile, "Error creating a new file...");
                this.runSafe(() -> dynamicType.toJar(this.jarFile), "Error trying to add transformed class to a new jar...");
            } else {
                this.runSafe(() -> dynamicType.inject(this.jarFile), "Error trying to add transformed class to existing jar...");
            }
        } else {
            this.runSafe(() -> dynamicType.saveIn(this.dumpDir), "Error trying to save transformed class into directory...");
        }
    }

    private <R> void runSafe(CheckedFunction0<R> thunk, String msg) {
        Try.of(thunk).onFailure(cause -> Logger.error(() -> msg, cause));
    }

    public File getDumpDir() {
        return this.dumpDir;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public KanelaConfiguration.DumpConfig getConfig() {
        return this.config;
    }

    public String toString() {
        return "ClassDumperListener(dumpDir=" + this.getDumpDir() + ", jarFile=" + this.getJarFile() + ", config=" + this.getConfig() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDumperListener)) {
            return false;
        }
        ClassDumperListener other = (ClassDumperListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$dumpDir = this.getDumpDir();
        File other$dumpDir = other.getDumpDir();
        if (this$dumpDir == null ? other$dumpDir != null : !((Object)this$dumpDir).equals(other$dumpDir)) {
            return false;
        }
        File this$jarFile = this.getJarFile();
        File other$jarFile = other.getJarFile();
        if (this$jarFile == null ? other$jarFile != null : !((Object)this$jarFile).equals(other$jarFile)) {
            return false;
        }
        KanelaConfiguration.DumpConfig this$config = this.getConfig();
        KanelaConfiguration.DumpConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassDumperListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $dumpDir = this.getDumpDir();
        result = result * 59 + ($dumpDir == null ? 43 : ((Object)$dumpDir).hashCode());
        File $jarFile = this.getJarFile();
        result = result * 59 + ($jarFile == null ? 43 : ((Object)$jarFile).hashCode());
        KanelaConfiguration.DumpConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }
}

