/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.conf;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import kanela.agent.libs.com.typesafe.config.Config;
import kanela.agent.libs.com.typesafe.config.ConfigFactory;
import kanela.agent.libs.com.typesafe.config.ConfigParseOptions;
import kanela.agent.libs.com.typesafe.config.ConfigResolveOptions;
import kanela.agent.libs.io.vavr.API;
import kanela.agent.libs.io.vavr.collection.List;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.org.pmw.tinylog.Level;
import kanela.agent.util.log.Logger;

public final class KanelaConfiguration {
    private final Boolean debugMode;
    private final DumpConfig dump;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final InstrumentationRegistryConfig instrumentationRegistryConfig;
    private final OldGarbageCollectorConfig oldGarbageCollectorConfig;
    private final Boolean showBanner;
    private final HashMap extraParams;
    private final Level logLevel;
    private final Config config;
    private static KanelaConfiguration latestInstance = null;

    public static synchronized KanelaConfiguration from(ClassLoader classLoader) {
        KanelaConfiguration config;
        latestInstance = config = new KanelaConfiguration(KanelaConfiguration.loadConfig(classLoader));
        return config;
    }

    public static synchronized KanelaConfiguration instance() {
        if (latestInstance == null) {
            latestInstance = new KanelaConfiguration(KanelaConfiguration.loadConfig(Thread.currentThread().getContextClassLoader()));
        }
        return latestInstance;
    }

    private KanelaConfiguration(Config config) {
        this.config = config;
        this.debugMode = this.getDebugMode(config);
        this.showBanner = this.getShowBanner(config);
        this.extraParams = new HashMap();
        this.dump = new DumpConfig(config);
        this.circuitBreakerConfig = new CircuitBreakerConfig(config);
        this.instrumentationRegistryConfig = new InstrumentationRegistryConfig(config);
        this.oldGarbageCollectorConfig = new OldGarbageCollectorConfig(config);
        this.logLevel = this.getLoggerLevel(config);
    }

    public List<ModuleConfiguration> getAgentModules() {
        Config config = this.getConfig().getConfig("modules");
        Logger.debug(() -> "Loaded configuration => " + config.root().render());
        return List.ofAll(config.entrySet()).foldLeft(List.empty(), (moduleList, moduleName) -> moduleList.append(((String)moduleName.getKey()).split("\\.")[0])).toSet().map(configPath -> {
            Try<ModuleConfiguration> moduleSettings = Try.of(() -> {
                Config moduleConfig = config.getConfig((String)configPath);
                String name = moduleConfig.getString("name");
                String description = Try.of(() -> moduleConfig.getString("description")).getOrElse("");
                List<String> instrumentations = this.getInstrumentations(moduleConfig);
                String within = this.getWithinConfiguration(moduleConfig);
                String exclude = this.getExcludeConfiguration(moduleConfig);
                String exceptionHandlerStrategy = Try.of(() -> moduleConfig.getString("exception-handler-strategy")).getOrElse("LOG");
                Boolean enabled = Try.of(() -> moduleConfig.getBoolean("enabled")).getOrElse(true);
                Integer order = Try.of(() -> moduleConfig.getInt("order")).getOrElse(Integer.MAX_VALUE);
                Boolean stoppable = Try.of(() -> moduleConfig.getBoolean("stoppable")).getOrElse(false);
                BootstrapInjectionConfig bootstrapInjection = this.getBootstrapInjectionConfiguration(moduleConfig);
                Boolean enableClassFileVersionValidator = Try.of(() -> moduleConfig.getBoolean("enable-class-file-version-validator")).getOrElse(true);
                String tempDirPrefix = Try.of(() -> moduleConfig.getString("temp-dir-prefix")).getOrElse("tmp");
                Boolean disableClassFormatChanges = Try.of(() -> moduleConfig.getBoolean("disable-class-format-changes")).getOrElse(false);
                return ModuleConfiguration.from(configPath, name, description, instrumentations, within, enabled, order, stoppable, bootstrapInjection, enableClassFileVersionValidator, KanelaConfiguration.createTempDirectory(tempDirPrefix), disableClassFormatChanges, exclude, exceptionHandlerStrategy);
            });
            moduleSettings.failed().forEach(t -> Logger.warn(() -> "Malformed configuration for module on path: " + configPath + ". The module will be ignored."));
            return moduleSettings;
        }).filter(Try::isSuccess).map(Try::get).filter(module -> module.getInstrumentations().nonEmpty() && this.isEnabled((ModuleConfiguration)module)).toList().sortBy(ModuleConfiguration::getOrder);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private <T> void addExtraParameter(String key, T value) {
        this.extraParams.put(key, value);
    }

    public <T> Option<T> getExtraParameter(String key) {
        return Option.of(this.extraParams.get(key));
    }

    public boolean isAttachedInRuntime() {
        return this.getExtraParameter("attached-in-runtime").getOrElse(false);
    }

    public void runtimeAttach() {
        this.addExtraParameter("attached-in-runtime", true);
    }

    private static Config loadConfig(ClassLoader classLoader) {
        return Try.of(() -> KanelaConfiguration.loadDefaultConfig(classLoader).getConfig("kanela")).onFailure(missing -> Logger.error(() -> "It has not been found any configuration for Kanela Agent.", missing)).get();
    }

    private List<String> getInstrumentations(Config config) {
        return Try.of(() -> List.ofAll(config.getStringList("instrumentations"))).onFailure(exc -> Logger.warn(() -> "The instrumentations have not been found. Perhaps you have forgotten to add them to the config?", exc)).getOrElse(List.Nil.instance());
    }

    private String getWithinConfiguration(Config config) {
        if (config.hasPath("within")) {
            return this.getTypeListPattern(config, "within").getOrElse("");
        }
        return "";
    }

    private String getExcludeConfiguration(Config config) {
        if (config.hasPath("exclude")) {
            return this.getTypeListPattern(config, "exclude").getOrElse("");
        }
        return "";
    }

    private BootstrapInjectionConfig getBootstrapInjectionConfiguration(Config moduleConfig) {
        return Try.of(() -> new BootstrapInjectionConfig(moduleConfig.getConfig("bootstrap-injection"))).getOrElse(() -> new BootstrapInjectionConfig(false, List.empty()));
    }

    private Try<String> getTypeListPattern(Config config, String path) {
        return Try.of(() -> List.ofAll(config.getStringList(path)).mkString("|"));
    }

    private Boolean getDebugMode(Config config) {
        return Try.of(() -> config.getBoolean("debug-mode")).getOrElse(false);
    }

    private Boolean getShowBanner(Config config) {
        return Try.of(() -> config.getBoolean("show-banner")).getOrElse(false);
    }

    private static Config loadDefaultConfig(ClassLoader classLoader) {
        return ConfigFactory.load(classLoader, ConfigParseOptions.defaults(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
    }

    private static File createTempDirectory(String tempDirPrefix) {
        return (File)Try.of(() -> Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]).toFile()).getOrElseThrow(() -> new RuntimeException(MessageFormat.format("Cannot build the temporary directory: {0}", tempDirPrefix)));
    }

    private Level getLoggerLevel(Config config) {
        String level = Try.of(() -> config.getString("log-level")).getOrElse("INFO");
        return (Level)((Object)API.Match(level).of(API.Case(API.$("INFO"), Level.INFO), API.Case(API.$("DEBUG"), Level.DEBUG), API.Case(API.$("ERROR"), Level.ERROR), API.Case(API.$("WARNING"), Level.WARNING), API.Case(API.$("TRACE"), Level.TRACE), API.Case(API.$("OFF"), Level.OFF)));
    }

    private boolean isEnabled(ModuleConfiguration module) {
        if (module.enabled) {
            return true;
        }
        Logger.info(() -> "The Module: " + module.getName() + " is disabled");
        return false;
    }

    public Boolean getDebugMode() {
        return this.debugMode;
    }

    public DumpConfig getDump() {
        return this.dump;
    }

    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    public InstrumentationRegistryConfig getInstrumentationRegistryConfig() {
        return this.instrumentationRegistryConfig;
    }

    public OldGarbageCollectorConfig getOldGarbageCollectorConfig() {
        return this.oldGarbageCollectorConfig;
    }

    public Boolean getShowBanner() {
        return this.showBanner;
    }

    public HashMap getExtraParams() {
        return this.extraParams;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KanelaConfiguration)) {
            return false;
        }
        KanelaConfiguration other = (KanelaConfiguration)o;
        Boolean this$debugMode = this.getDebugMode();
        Boolean other$debugMode = other.getDebugMode();
        if (this$debugMode == null ? other$debugMode != null : !((Object)this$debugMode).equals(other$debugMode)) {
            return false;
        }
        Boolean this$showBanner = this.getShowBanner();
        Boolean other$showBanner = other.getShowBanner();
        if (this$showBanner == null ? other$showBanner != null : !((Object)this$showBanner).equals(other$showBanner)) {
            return false;
        }
        DumpConfig this$dump = this.getDump();
        DumpConfig other$dump = other.getDump();
        if (this$dump == null ? other$dump != null : !((Object)this$dump).equals(other$dump)) {
            return false;
        }
        CircuitBreakerConfig this$circuitBreakerConfig = this.getCircuitBreakerConfig();
        CircuitBreakerConfig other$circuitBreakerConfig = other.getCircuitBreakerConfig();
        if (this$circuitBreakerConfig == null ? other$circuitBreakerConfig != null : !((Object)this$circuitBreakerConfig).equals(other$circuitBreakerConfig)) {
            return false;
        }
        InstrumentationRegistryConfig this$instrumentationRegistryConfig = this.getInstrumentationRegistryConfig();
        InstrumentationRegistryConfig other$instrumentationRegistryConfig = other.getInstrumentationRegistryConfig();
        if (this$instrumentationRegistryConfig == null ? other$instrumentationRegistryConfig != null : !((Object)this$instrumentationRegistryConfig).equals(other$instrumentationRegistryConfig)) {
            return false;
        }
        OldGarbageCollectorConfig this$oldGarbageCollectorConfig = this.getOldGarbageCollectorConfig();
        OldGarbageCollectorConfig other$oldGarbageCollectorConfig = other.getOldGarbageCollectorConfig();
        if (this$oldGarbageCollectorConfig == null ? other$oldGarbageCollectorConfig != null : !((Object)this$oldGarbageCollectorConfig).equals(other$oldGarbageCollectorConfig)) {
            return false;
        }
        HashMap this$extraParams = this.getExtraParams();
        HashMap other$extraParams = other.getExtraParams();
        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
            return false;
        }
        Level this$logLevel = this.getLogLevel();
        Level other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !((Object)((Object)this$logLevel)).equals((Object)other$logLevel)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $debugMode = this.getDebugMode();
        result = result * 59 + ($debugMode == null ? 43 : ((Object)$debugMode).hashCode());
        Boolean $showBanner = this.getShowBanner();
        result = result * 59 + ($showBanner == null ? 43 : ((Object)$showBanner).hashCode());
        DumpConfig $dump = this.getDump();
        result = result * 59 + ($dump == null ? 43 : ((Object)$dump).hashCode());
        CircuitBreakerConfig $circuitBreakerConfig = this.getCircuitBreakerConfig();
        result = result * 59 + ($circuitBreakerConfig == null ? 43 : ((Object)$circuitBreakerConfig).hashCode());
        InstrumentationRegistryConfig $instrumentationRegistryConfig = this.getInstrumentationRegistryConfig();
        result = result * 59 + ($instrumentationRegistryConfig == null ? 43 : ((Object)$instrumentationRegistryConfig).hashCode());
        OldGarbageCollectorConfig $oldGarbageCollectorConfig = this.getOldGarbageCollectorConfig();
        result = result * 59 + ($oldGarbageCollectorConfig == null ? 43 : ((Object)$oldGarbageCollectorConfig).hashCode());
        HashMap $extraParams = this.getExtraParams();
        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
        Level $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : ((Object)((Object)$logLevel)).hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "KanelaConfiguration(debugMode=" + this.getDebugMode() + ", dump=" + this.getDump() + ", circuitBreakerConfig=" + this.getCircuitBreakerConfig() + ", instrumentationRegistryConfig=" + this.getInstrumentationRegistryConfig() + ", oldGarbageCollectorConfig=" + this.getOldGarbageCollectorConfig() + ", showBanner=" + this.getShowBanner() + ", extraParams=" + this.getExtraParams() + ", logLevel=" + (Object)((Object)this.getLogLevel()) + ", config=" + this.getConfig() + ")";
    }

    private Config getConfig() {
        return this.config;
    }

    public static final class BootstrapInjectionConfig {
        private final boolean enabled;
        private final List<String> helperClassNames;

        BootstrapInjectionConfig(boolean enabled, List<String> helperClassNames) {
            this.enabled = enabled;
            this.helperClassNames = helperClassNames;
        }

        BootstrapInjectionConfig(Config config) {
            this.enabled = Try.of(() -> config.getBoolean("enabled")).getOrElse(false);
            this.helperClassNames = List.ofAll(Try.of(() -> config.getStringList("helper-class-names")).getOrElse(Collections.emptyList()));
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public List<String> getHelperClassNames() {
            return this.helperClassNames;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BootstrapInjectionConfig)) {
                return false;
            }
            BootstrapInjectionConfig other = (BootstrapInjectionConfig)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            List<String> this$helperClassNames = this.getHelperClassNames();
            List<String> other$helperClassNames = other.getHelperClassNames();
            return !(this$helperClassNames == null ? other$helperClassNames != null : !this$helperClassNames.equals(other$helperClassNames));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            List<String> $helperClassNames = this.getHelperClassNames();
            result = result * 59 + ($helperClassNames == null ? 43 : $helperClassNames.hashCode());
            return result;
        }

        public String toString() {
            return "KanelaConfiguration.BootstrapInjectionConfig(enabled=" + this.isEnabled() + ", helperClassNames=" + this.getHelperClassNames() + ")";
        }
    }

    public final class OldGarbageCollectorConfig {
        private final boolean shouldLogAfterGc = Try.of(() -> config.getBoolean("gc-listener.log-after-gc-run")).getOrElse(false);

        OldGarbageCollectorConfig(Config config) {
        }

        public boolean isCircuitBreakerRunning() {
            return KanelaConfiguration.this.getExtraParameter("circuit-breaker-running").getOrElse(false);
        }

        public boolean isShouldLogAfterGc() {
            return this.shouldLogAfterGc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OldGarbageCollectorConfig)) {
                return false;
            }
            OldGarbageCollectorConfig other = (OldGarbageCollectorConfig)o;
            return this.isShouldLogAfterGc() == other.isShouldLogAfterGc();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isShouldLogAfterGc() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "KanelaConfiguration.OldGarbageCollectorConfig(shouldLogAfterGc=" + this.isShouldLogAfterGc() + ")";
        }
    }

    public static final class InstrumentationRegistryConfig {
        private final boolean enabled = Try.of(() -> config.getBoolean("instrumentation-registry.enabled")).getOrElse(false);

        InstrumentationRegistryConfig(Config config) {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstrumentationRegistryConfig)) {
                return false;
            }
            InstrumentationRegistryConfig other = (InstrumentationRegistryConfig)o;
            return this.isEnabled() == other.isEnabled();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "KanelaConfiguration.InstrumentationRegistryConfig(enabled=" + this.isEnabled() + ")";
        }
    }

    public final class CircuitBreakerConfig {
        private final boolean enabled = Try.of(() -> config.getBoolean("circuit-breaker.enabled")).getOrElse(false);
        private final double freeMemoryThreshold = Try.of(() -> config.getDouble("circuit-breaker.free-memory-threshold")).getOrElse(50.0);
        private final double gcProcessCPUThreshold = Try.of(() -> config.getDouble("circuit-breaker.gc-process-cpu-threshold")).getOrElse(10.0);

        CircuitBreakerConfig(Config config) {
        }

        public void circuitBreakerRunning() {
            KanelaConfiguration.this.addExtraParameter("circuit-breaker-running", true);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public double getFreeMemoryThreshold() {
            return this.freeMemoryThreshold;
        }

        public double getGcProcessCPUThreshold() {
            return this.gcProcessCPUThreshold;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CircuitBreakerConfig)) {
                return false;
            }
            CircuitBreakerConfig other = (CircuitBreakerConfig)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (Double.compare(this.getFreeMemoryThreshold(), other.getFreeMemoryThreshold()) != 0) {
                return false;
            }
            return Double.compare(this.getGcProcessCPUThreshold(), other.getGcProcessCPUThreshold()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            long $freeMemoryThreshold = Double.doubleToLongBits(this.getFreeMemoryThreshold());
            result = result * 59 + (int)($freeMemoryThreshold >>> 32 ^ $freeMemoryThreshold);
            long $gcProcessCPUThreshold = Double.doubleToLongBits(this.getGcProcessCPUThreshold());
            result = result * 59 + (int)($gcProcessCPUThreshold >>> 32 ^ $gcProcessCPUThreshold);
            return result;
        }

        public String toString() {
            return "KanelaConfiguration.CircuitBreakerConfig(enabled=" + this.isEnabled() + ", freeMemoryThreshold=" + this.getFreeMemoryThreshold() + ", gcProcessCPUThreshold=" + this.getGcProcessCPUThreshold() + ")";
        }
    }

    public static final class DumpConfig {
        private final Boolean dumpEnabled = Try.of(() -> config.getBoolean("class-dumper.enabled")).getOrElse(false);
        private final String dumpDir = Try.of(() -> config.getString("class-dumper.dir")).getOrElse(System.getProperty("user.home") + "/kanela-agent/dump");
        private final Boolean createJar = Try.of(() -> config.getBoolean("class-dumper.create-jar")).getOrElse(true);
        private final String jarName = Try.of(() -> config.getString("class-dumper.jar-name")).getOrElse("instrumentedClasses");

        DumpConfig(Config config) {
        }

        public boolean isDumpEnabled() {
            return this.dumpEnabled;
        }

        public Boolean getDumpEnabled() {
            return this.dumpEnabled;
        }

        public String getDumpDir() {
            return this.dumpDir;
        }

        public Boolean getCreateJar() {
            return this.createJar;
        }

        public String getJarName() {
            return this.jarName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DumpConfig)) {
                return false;
            }
            DumpConfig other = (DumpConfig)o;
            Boolean this$dumpEnabled = this.getDumpEnabled();
            Boolean other$dumpEnabled = other.getDumpEnabled();
            if (this$dumpEnabled == null ? other$dumpEnabled != null : !((Object)this$dumpEnabled).equals(other$dumpEnabled)) {
                return false;
            }
            Boolean this$createJar = this.getCreateJar();
            Boolean other$createJar = other.getCreateJar();
            if (this$createJar == null ? other$createJar != null : !((Object)this$createJar).equals(other$createJar)) {
                return false;
            }
            String this$dumpDir = this.getDumpDir();
            String other$dumpDir = other.getDumpDir();
            if (this$dumpDir == null ? other$dumpDir != null : !this$dumpDir.equals(other$dumpDir)) {
                return false;
            }
            String this$jarName = this.getJarName();
            String other$jarName = other.getJarName();
            return !(this$jarName == null ? other$jarName != null : !this$jarName.equals(other$jarName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $dumpEnabled = this.getDumpEnabled();
            result = result * 59 + ($dumpEnabled == null ? 43 : ((Object)$dumpEnabled).hashCode());
            Boolean $createJar = this.getCreateJar();
            result = result * 59 + ($createJar == null ? 43 : ((Object)$createJar).hashCode());
            String $dumpDir = this.getDumpDir();
            result = result * 59 + ($dumpDir == null ? 43 : $dumpDir.hashCode());
            String $jarName = this.getJarName();
            result = result * 59 + ($jarName == null ? 43 : $jarName.hashCode());
            return result;
        }

        public String toString() {
            return "KanelaConfiguration.DumpConfig(dumpEnabled=" + this.getDumpEnabled() + ", dumpDir=" + this.getDumpDir() + ", createJar=" + this.getCreateJar() + ", jarName=" + this.getJarName() + ")";
        }
    }

    public static final class ModuleConfiguration {
        private final String configPath;
        private final String name;
        private final String description;
        private final List<String> instrumentations;
        private final String withinPackage;
        private final boolean enabled;
        private final int order;
        private final boolean stoppable;
        private final BootstrapInjectionConfig bootstrapInjectionConfig;
        private final boolean enableClassFileVersionValidator;
        private final File tempDir;
        private final boolean disableClassFormatChanges;
        private final String excludePackage;
        private final String exceptionHandlerStrategy;

        public boolean shouldInjectInBootstrap() {
            return this.bootstrapInjectionConfig.enabled;
        }

        public boolean shouldValidateMinimumClassFileVersion() {
            return this.enableClassFileVersionValidator;
        }

        private ModuleConfiguration(String configPath, String name, String description, List<String> instrumentations, String withinPackage, boolean enabled, int order, boolean stoppable, BootstrapInjectionConfig bootstrapInjectionConfig, boolean enableClassFileVersionValidator, File tempDir, boolean disableClassFormatChanges, String excludePackage, String exceptionHandlerStrategy) {
            this.configPath = configPath;
            this.name = name;
            this.description = description;
            this.instrumentations = instrumentations;
            this.withinPackage = withinPackage;
            this.enabled = enabled;
            this.order = order;
            this.stoppable = stoppable;
            this.bootstrapInjectionConfig = bootstrapInjectionConfig;
            this.enableClassFileVersionValidator = enableClassFileVersionValidator;
            this.tempDir = tempDir;
            this.disableClassFormatChanges = disableClassFormatChanges;
            this.excludePackage = excludePackage;
            this.exceptionHandlerStrategy = exceptionHandlerStrategy;
        }

        public static ModuleConfiguration from(String configPath, String name, String description, List<String> instrumentations, String withinPackage, boolean enabled, int order, boolean stoppable, BootstrapInjectionConfig bootstrapInjectionConfig, boolean enableClassFileVersionValidator, File tempDir, boolean disableClassFormatChanges, String excludePackage, String exceptionHandlerStrategy) {
            return new ModuleConfiguration(configPath, name, description, instrumentations, withinPackage, enabled, order, stoppable, bootstrapInjectionConfig, enableClassFileVersionValidator, tempDir, disableClassFormatChanges, excludePackage, exceptionHandlerStrategy);
        }

        public String getConfigPath() {
            return this.configPath;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getInstrumentations() {
            return this.instrumentations;
        }

        public String getWithinPackage() {
            return this.withinPackage;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isStoppable() {
            return this.stoppable;
        }

        public BootstrapInjectionConfig getBootstrapInjectionConfig() {
            return this.bootstrapInjectionConfig;
        }

        public File getTempDir() {
            return this.tempDir;
        }

        public boolean isDisableClassFormatChanges() {
            return this.disableClassFormatChanges;
        }

        public String getExcludePackage() {
            return this.excludePackage;
        }

        public String getExceptionHandlerStrategy() {
            return this.exceptionHandlerStrategy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleConfiguration)) {
                return false;
            }
            ModuleConfiguration other = (ModuleConfiguration)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            if (this.isStoppable() != other.isStoppable()) {
                return false;
            }
            if (this.enableClassFileVersionValidator != other.enableClassFileVersionValidator) {
                return false;
            }
            if (this.isDisableClassFormatChanges() != other.isDisableClassFormatChanges()) {
                return false;
            }
            String this$configPath = this.getConfigPath();
            String other$configPath = other.getConfigPath();
            if (this$configPath == null ? other$configPath != null : !this$configPath.equals(other$configPath)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<String> this$instrumentations = this.getInstrumentations();
            List<String> other$instrumentations = other.getInstrumentations();
            if (this$instrumentations == null ? other$instrumentations != null : !this$instrumentations.equals(other$instrumentations)) {
                return false;
            }
            String this$withinPackage = this.getWithinPackage();
            String other$withinPackage = other.getWithinPackage();
            if (this$withinPackage == null ? other$withinPackage != null : !this$withinPackage.equals(other$withinPackage)) {
                return false;
            }
            BootstrapInjectionConfig this$bootstrapInjectionConfig = this.getBootstrapInjectionConfig();
            BootstrapInjectionConfig other$bootstrapInjectionConfig = other.getBootstrapInjectionConfig();
            if (this$bootstrapInjectionConfig == null ? other$bootstrapInjectionConfig != null : !((Object)this$bootstrapInjectionConfig).equals(other$bootstrapInjectionConfig)) {
                return false;
            }
            File this$tempDir = this.getTempDir();
            File other$tempDir = other.getTempDir();
            if (this$tempDir == null ? other$tempDir != null : !((Object)this$tempDir).equals(other$tempDir)) {
                return false;
            }
            String this$excludePackage = this.getExcludePackage();
            String other$excludePackage = other.getExcludePackage();
            if (this$excludePackage == null ? other$excludePackage != null : !this$excludePackage.equals(other$excludePackage)) {
                return false;
            }
            String this$exceptionHandlerStrategy = this.getExceptionHandlerStrategy();
            String other$exceptionHandlerStrategy = other.getExceptionHandlerStrategy();
            return !(this$exceptionHandlerStrategy == null ? other$exceptionHandlerStrategy != null : !this$exceptionHandlerStrategy.equals(other$exceptionHandlerStrategy));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getOrder();
            result = result * 59 + (this.isStoppable() ? 79 : 97);
            result = result * 59 + (this.enableClassFileVersionValidator ? 79 : 97);
            result = result * 59 + (this.isDisableClassFormatChanges() ? 79 : 97);
            String $configPath = this.getConfigPath();
            result = result * 59 + ($configPath == null ? 43 : $configPath.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<String> $instrumentations = this.getInstrumentations();
            result = result * 59 + ($instrumentations == null ? 43 : $instrumentations.hashCode());
            String $withinPackage = this.getWithinPackage();
            result = result * 59 + ($withinPackage == null ? 43 : $withinPackage.hashCode());
            BootstrapInjectionConfig $bootstrapInjectionConfig = this.getBootstrapInjectionConfig();
            result = result * 59 + ($bootstrapInjectionConfig == null ? 43 : ((Object)$bootstrapInjectionConfig).hashCode());
            File $tempDir = this.getTempDir();
            result = result * 59 + ($tempDir == null ? 43 : ((Object)$tempDir).hashCode());
            String $excludePackage = this.getExcludePackage();
            result = result * 59 + ($excludePackage == null ? 43 : $excludePackage.hashCode());
            String $exceptionHandlerStrategy = this.getExceptionHandlerStrategy();
            result = result * 59 + ($exceptionHandlerStrategy == null ? 43 : $exceptionHandlerStrategy.hashCode());
            return result;
        }

        public String toString() {
            return "KanelaConfiguration.ModuleConfiguration(configPath=" + this.getConfigPath() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", instrumentations=" + this.getInstrumentations() + ", withinPackage=" + this.getWithinPackage() + ", enabled=" + this.isEnabled() + ", order=" + this.getOrder() + ", stoppable=" + this.isStoppable() + ", bootstrapInjectionConfig=" + this.getBootstrapInjectionConfig() + ", enableClassFileVersionValidator=" + this.enableClassFileVersionValidator + ", tempDir=" + this.getTempDir() + ", disableClassFormatChanges=" + this.isDisableClassFormatChanges() + ", excludePackage=" + this.getExcludePackage() + ", exceptionHandlerStrategy=" + this.getExceptionHandlerStrategy() + ")";
        }
    }
}

