/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.io.vavr.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kanela.agent.libs.io.vavr.collection.AbstractIterator;
import kanela.agent.libs.io.vavr.collection.ArrayType;
import kanela.agent.libs.io.vavr.collection.GwtIncompatible;
import kanela.agent.libs.io.vavr.collection.HashSet;
import kanela.agent.libs.io.vavr.collection.IndexedSeq;
import kanela.agent.libs.io.vavr.collection.Iterator;
import kanela.agent.libs.io.vavr.collection.JavaConverters;
import kanela.agent.libs.io.vavr.collection.LinkedHashMap;
import kanela.agent.libs.io.vavr.collection.List;
import kanela.agent.libs.io.vavr.collection.Map;
import kanela.agent.libs.io.vavr.collection.Multimap;
import kanela.agent.libs.io.vavr.collection.Seq;
import kanela.agent.libs.io.vavr.collection.Set;
import kanela.agent.libs.io.vavr.collection.Traversable;
import kanela.agent.libs.io.vavr.control.Option;

final class Collections {
    Collections() {
    }

    static boolean areEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        java.util.Iterator<?> iter1 = iterable1.iterator();
        java.util.Iterator<?> iter2 = iterable2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (Objects.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    @GwtIncompatible
    static <T, C extends Seq<T>> C asJava(C source, Consumer<? super java.util.List<T>> action, JavaConverters.ChangePolicy changePolicy) {
        Objects.requireNonNull(action, "action is null");
        JavaConverters.ListView view = JavaConverters.asJava(source, changePolicy);
        action.accept(view);
        return (C)((Seq)view.getDelegate());
    }

    static <T, S extends Seq<T>> Iterator<S> crossProduct(S empty, S seq, int power) {
        if (power < 0) {
            return Iterator.empty();
        }
        return Iterator.range(0, power).foldLeft(Iterator.of(empty), (product, ignored) -> product.flatMap(el -> seq.map(t -> el.append(t))));
    }

    static <T, S extends IndexedSeq<T>> S dropRightUntil(S seq, Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = seq.length() - 1; i >= 0; --i) {
            if (!predicate.test(seq.get(i))) continue;
            return (S)seq.take(i + 1);
        }
        return (S)seq.take(0);
    }

    static <T, S extends IndexedSeq<T>> S dropUntil(S seq, Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = 0; i < seq.length(); ++i) {
            if (!predicate.test(seq.get(i))) continue;
            return (S)seq.drop(i);
        }
        return (S)seq.take(0);
    }

    static <K, V> boolean equals(Map<K, V> source, Object object) {
        if (source == object) {
            return true;
        }
        if (source != null && object instanceof Map) {
            Map map = (Map)object;
            if (source.size() != map.size()) {
                return false;
            }
            try {
                return source.forAll(map::contains);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    static <K, V> boolean equals(Multimap<K, V> source, Object object) {
        if (source == object) {
            return true;
        }
        if (source != null && object instanceof Multimap) {
            Multimap multimap = (Multimap)object;
            if (source.size() != multimap.size()) {
                return false;
            }
            try {
                return source.forAll(multimap::contains);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    static <V> boolean equals(Seq<V> source, Object object) {
        if (object == source) {
            return true;
        }
        if (source != null && object instanceof Seq) {
            Seq seq = (Seq)object;
            return seq.size() == source.size() && Collections.areEqual(source, seq);
        }
        return false;
    }

    static <V> boolean equals(Set<V> source, Object object) {
        if (source == object) {
            return true;
        }
        if (source != null && object instanceof Set) {
            Set set = (Set)object;
            if (source.size() != set.size()) {
                return false;
            }
            try {
                return source.forAll(set::contains);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    static <T> Iterator<T> fill(int n, Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return Collections.tabulate(n, ignored -> supplier.get());
    }

    static <T> Iterator<T> fillObject(int n, T element) {
        if (n <= 0) {
            return Iterator.empty();
        }
        return Iterator.continually(element).take(n);
    }

    static <C extends Traversable<T>, T> C fill(int n, Supplier<? extends T> s, C empty, Function<T[], C> of) {
        Objects.requireNonNull(s, "s is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of, "of is null");
        return Collections.tabulate(n, anything -> s.get(), empty, of);
    }

    static <C extends Traversable<T>, T> C fillObject(int n, T element, C empty, Function<T[], C> of) {
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of, "of is null");
        if (n <= 0) {
            return empty;
        }
        Object[] elements = new Object[n];
        Arrays.fill(elements, element);
        return (C)((Traversable)of.apply((Object[][])elements));
    }

    static <T, C, R extends Iterable<T>> Map<C, R> groupBy(Traversable<T> source, Function<? super T, ? extends C> classifier, Function<? super Iterable<T>, R> mapper) {
        Objects.requireNonNull(classifier, "classifier is null");
        Objects.requireNonNull(mapper, "mapper is null");
        Map<C, R> results = LinkedHashMap.empty();
        for (Map.Entry<C, Collection<T>> entry : Collections.groupBy(source, classifier)) {
            results = results.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return results;
    }

    private static <T, C> java.util.Set<Map.Entry<C, Collection<T>>> groupBy(Traversable<T> source, Function<? super T, ? extends C> classifier) {
        java.util.LinkedHashMap<Object, Collection> results = new java.util.LinkedHashMap<Object, Collection>(source.isTraversableAgain() ? source.size() : 16);
        for (Object value : source) {
            C key = classifier.apply(value);
            results.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        return results.entrySet();
    }

    static int hashOrdered(Iterable<?> iterable) {
        return Collections.hash(iterable, (acc, hash) -> acc * 31 + hash);
    }

    static int hashUnordered(Iterable<?> iterable) {
        return Collections.hash(iterable, (acc, hash) -> acc + hash);
    }

    private static int hash(Iterable<?> iterable, IntBinaryOperator accumulator) {
        if (iterable == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object o : iterable) {
            hashCode = accumulator.applyAsInt(hashCode, Objects.hashCode(o));
        }
        return hashCode;
    }

    static Option<Integer> indexOption(int index) {
        return Option.when(index >= 0, index);
    }

    static boolean isEmpty(Iterable<?> iterable) {
        return iterable instanceof Traversable && ((Traversable)iterable).isEmpty() || iterable instanceof Collection && ((Collection)iterable).isEmpty() || !iterable.iterator().hasNext();
    }

    static <T> boolean isTraversableAgain(Iterable<? extends T> iterable) {
        return iterable instanceof Collection || iterable instanceof Traversable && ((Traversable)iterable).isTraversableAgain();
    }

    static <T> T last(Traversable<T> source) {
        if (source.isEmpty()) {
            throw new NoSuchElementException("last of empty " + source.stringPrefix());
        }
        java.util.Iterator it = source.iterator();
        T result = null;
        while (it.hasNext()) {
            result = (T)it.next();
        }
        return result;
    }

    static <K, V, K2, U extends Map<K2, V>> U mapKeys(Map<K, V> source, U zero, Function<? super K, ? extends K2> keyMapper, BiFunction<? super V, ? super V, ? extends V> valueMerge) {
        Objects.requireNonNull(zero, "zero is null");
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMerge, "valueMerge is null");
        return (U)source.foldLeft(zero, (acc, entry) -> {
            Object k2 = keyMapper.apply((Object)entry._1);
            Object v2 = entry._2;
            Option v1 = acc.get(k2);
            Object v = v1.isDefined() ? valueMerge.apply((Object)v1.get(), (Object)v2) : v2;
            return acc.put(k2, v);
        });
    }

    static <C extends Traversable<T>, T> C removeAll(C source, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (source.isEmpty()) {
            return source;
        }
        HashSet removed = HashSet.ofAll(elements);
        return (C)(removed.isEmpty() ? source : source.filter(e -> !removed.contains(e)));
    }

    static <C extends Traversable<T>, T> C reject(C source, Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (source.isEmpty()) {
            return source;
        }
        return (C)source.filter(predicate.negate());
    }

    static <C extends Traversable<T>, T> C removeAll(C source, T element) {
        if (source.isEmpty()) {
            return source;
        }
        return (C)source.filter(e -> !Objects.equals(e, element));
    }

    static <C extends Traversable<T>, T> C retainAll(C source, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (source.isEmpty()) {
            return source;
        }
        HashSet<? extends T> retained = HashSet.ofAll(elements);
        return (C)source.filter(retained::contains);
    }

    static <T> Iterator<T> reverseIterator(Iterable<T> iterable) {
        if (iterable instanceof java.util.List) {
            return Collections.reverseListIterator((java.util.List)iterable);
        }
        if (iterable instanceof Seq) {
            return ((Seq)iterable).reverseIterator();
        }
        return List.empty().pushAll(iterable).iterator();
    }

    private static <T> Iterator<T> reverseListIterator(final java.util.List<T> list) {
        return new Iterator<T>(){
            private final ListIterator<T> delegate;
            {
                this.delegate = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasPrevious();
            }

            @Override
            public T next() {
                return this.delegate.previous();
            }
        };
    }

    static <T, C extends Seq<T>> C rotateLeft(C source, int n) {
        if (source.isEmpty() || n == 0) {
            return source;
        }
        if (n < 0) {
            return Collections.rotateRight(source, -n);
        }
        int len = source.length();
        int m = n % len;
        if (m == 0) {
            return source;
        }
        return (C)source.drop(m).appendAll(source.take(m));
    }

    static <T, C extends Seq<T>> C rotateRight(C source, int n) {
        if (source.isEmpty() || n == 0) {
            return source;
        }
        if (n < 0) {
            return Collections.rotateLeft(source, -n);
        }
        int len = source.length();
        int m = n % len;
        if (m == 0) {
            return source;
        }
        return (C)source.takeRight(m).appendAll(source.dropRight(m));
    }

    static <T, U, R extends Traversable<U>> R scanLeft(Traversable<? extends T> source, U zero, BiFunction<? super U, ? super T, ? extends U> operation, Function<Iterator<U>, R> finisher) {
        Objects.requireNonNull(operation, "operation is null");
        Traversable iterator = source.iterator().scanLeft(zero, operation);
        return (R)((Traversable)finisher.apply((Iterator<U>)iterator));
    }

    static <T, U, R extends Traversable<U>> R scanRight(Traversable<? extends T> source, U zero, BiFunction<? super T, ? super U, ? extends U> operation, Function<Iterator<U>, R> finisher) {
        Objects.requireNonNull(operation, "operation is null");
        Iterator<? extends T> reversedElements = Collections.reverseIterator(source);
        return (R)Collections.scanLeft(reversedElements, zero, (u, t) -> operation.apply(t, u), us -> (Traversable)finisher.apply(Collections.reverseIterator(us)));
    }

    static <T, U, R extends Seq<T>> R sortBy(Seq<? extends T> source, Comparator<? super U> comparator, Function<? super T, ? extends U> mapper, Collector<T, ?, R> collector) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return (R)((Seq)source.toJavaStream().sorted((e1, e2) -> comparator.compare((Object)mapper.apply(e1), (Object)mapper.apply(e2))).collect(collector));
    }

    static <T, S extends Seq<T>> S shuffle(S source, Function<? super Iterable<T>, S> ofAll) {
        if (source.length() <= 1) {
            return source;
        }
        java.util.List list = source.toJavaList();
        java.util.Collections.shuffle(list);
        return (S)((Seq)ofAll.apply(list));
    }

    static void subSequenceRangeCheck(int beginIndex, int endIndex, int length) {
        if (beginIndex < 0 || endIndex > length) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ", " + endIndex + "), length = " + length);
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("subSequence(" + beginIndex + ", " + endIndex + ")");
        }
    }

    static <T> Iterator<T> tabulate(final int n, final Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        if (n <= 0) {
            return Iterator.empty();
        }
        return new AbstractIterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            protected T getNext() {
                return f.apply(this.i++);
            }
        };
    }

    static <C extends Traversable<T>, T> C tabulate(int n, Function<? super Integer, ? extends T> f, C empty, Function<T[], C> of) {
        Objects.requireNonNull(f, "f is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of, "of is null");
        if (n <= 0) {
            return empty;
        }
        Object[] elements = new Object[n];
        for (int i = 0; i < n; ++i) {
            elements[i] = f.apply(i);
        }
        return (C)((Traversable)of.apply((Object[][])elements));
    }

    static <T, S extends IndexedSeq<T>> S takeRightUntil(S seq, Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = seq.length() - 1; i >= 0; --i) {
            if (!predicate.test(seq.get(i))) continue;
            return (S)seq.drop(i + 1);
        }
        return seq;
    }

    static <T, S extends IndexedSeq<T>> S takeUntil(S seq, Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = 0; i < seq.length(); ++i) {
            if (!predicate.test(seq.get(i))) continue;
            return (S)seq.take(i);
        }
        return seq;
    }

    static <T, U extends Seq<T>, V extends Seq<U>> V transpose(V matrix, Function<Iterable<U>, V> rowFactory, Function<T[], U> columnFactory) {
        Objects.requireNonNull(matrix, "matrix is null");
        if (matrix.isEmpty() || matrix.length() == 1 && ((Seq)matrix.head()).length() <= 1) {
            return matrix;
        }
        return Collections.transposeNonEmptyMatrix(matrix, rowFactory, columnFactory);
    }

    private static <T, U extends Seq<T>, V extends Seq<U>> V transposeNonEmptyMatrix(V matrix, Function<Iterable<U>, V> rowFactory, Function<T[], U> columnFactory) {
        int newHeight = ((Seq)matrix.head()).size();
        int newWidth = matrix.size();
        Object[][] results = new Object[newHeight][newWidth];
        if (matrix.exists(r -> r.size() != newHeight)) {
            throw new IllegalArgumentException("the parameter `matrix` is invalid!");
        }
        int rowIndex = 0;
        for (Seq row : matrix) {
            int columnIndex = 0;
            for (Object element : row) {
                results[columnIndex][rowIndex] = element;
                ++columnIndex;
            }
            ++rowIndex;
        }
        return (V)((Seq)rowFactory.apply(Iterator.of(results).map(columnFactory)));
    }

    static <T> IterableWithSize<T> withSize(Iterable<? extends T> iterable) {
        return Collections.isTraversableAgain(iterable) ? Collections.withSizeTraversable(iterable) : Collections.withSizeTraversable(List.ofAll(iterable));
    }

    private static <T> IterableWithSize<T> withSizeTraversable(Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return new IterableWithSize<T>(iterable, ((Collection)iterable).size());
        }
        return new IterableWithSize<T>(iterable, ((Traversable)iterable).size());
    }

    static class IterableWithSize<T> {
        private final Iterable<? extends T> iterable;
        private final int size;

        IterableWithSize(Iterable<? extends T> iterable, int size) {
            this.iterable = iterable;
            this.size = size;
        }

        java.util.Iterator<? extends T> iterator() {
            return this.iterable.iterator();
        }

        java.util.Iterator<? extends T> reverseIterator() {
            return Collections.reverseIterator(this.iterable);
        }

        int size() {
            return this.size;
        }

        Object[] toArray() {
            if (this.iterable instanceof Collection) {
                return ((Collection)this.iterable).toArray();
            }
            return ArrayType.asArray(this.iterator(), this.size());
        }
    }
}

