/*
 * Decompiled with CFR 0.152.
 */
package kamon.okhttp3.instrumentation;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kamon.Kamon$;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.http.HttpClientInstrumentation$;
import kamon.instrumentation.http.HttpMessage;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.LambdaDeserialize;

public final class KamonOkHttpTracing$ {
    public static final KamonOkHttpTracing$ MODULE$ = new KamonOkHttpTracing$();
    private static final Config httpClientConfig = Kamon$.MODULE$.config().getConfig("kamon.instrumentation.okhttp.http-client");
    private static final HttpClientInstrumentation instrumentation = HttpClientInstrumentation$.MODULE$.from(MODULE$.httpClientConfig(), "okhttp-client");

    private Config httpClientConfig() {
        return httpClientConfig;
    }

    private HttpClientInstrumentation instrumentation() {
        return instrumentation;
    }

    public HttpClientInstrumentation.RequestHandler<Request> withNewSpan(Request request) {
        return this.instrumentation().createHandler(this.getRequestBuilder(request), Kamon$.MODULE$.currentContext());
    }

    public Response successContinuation(HttpClientInstrumentation.RequestHandler<Request> requestHandler, Response response) {
        requestHandler.processResponse(this.toKamonResponse(response));
        return response;
    }

    public void failureContinuation(HttpClientInstrumentation.RequestHandler<Request> requestHandler, Throwable error) {
        requestHandler.span().fail(error);
        requestHandler.span().finish();
    }

    public HttpMessage.RequestBuilder<Request> getRequestBuilder(Request request) {
        return new HttpMessage.RequestBuilder<Request>(request){
            private final Map<String, String> _headers;
            private final Request request$1;

            private Map<String, String> _headers() {
                return this._headers;
            }

            public Option<String> read(String header) {
                return Option$.MODULE$.apply((Object)this.request$1.header(header));
            }

            public scala.collection.immutable.Map<String, String> readAll() {
                return ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.request$1.headers().toMultimap()).asScala()).mapValues((Function1 & Serializable)values -> (String)values.get(0)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            public String url() {
                return this.request$1.url().toString();
            }

            public String path() {
                return this.request$1.url().uri().getPath();
            }

            public String method() {
                return this.request$1.method();
            }

            public String host() {
                return this.request$1.url().host();
            }

            public int port() {
                return this.request$1.url().port();
            }

            public void write(String header, String value) {
                this._headers().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)header), (Object)value));
            }

            public Request build() {
                Headers.Builder newHeadersMap = this.request$1.headers().newBuilder();
                this._headers().foreach((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        return newHeadersMap.add(key, value);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return this.request$1.newBuilder().headers(newHeadersMap.build()).build();
            }
            {
                this.request$1 = request$1;
                this._headers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$build$1(okhttp3.Headers$Builder scala.Tuple2 ), $anonfun$readAll$1(java.util.List )}, serializedLambda);
            }
        };
    }

    public HttpMessage.Response toKamonResponse(Response response) {
        return new HttpMessage.Response(response){
            private final Response response$1;

            public int statusCode() {
                return this.response$1.code();
            }
            {
                this.response$1 = response$1;
            }
        };
    }

    private KamonOkHttpTracing$() {
    }
}

