/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;
import scala.Array$;
import scala.Function1;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\reg\u0001\u00023f\u00019D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\n\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003C\u0005\u00026\u0001\u0001\r\u0011\"\u0003\u00028!A\u00111\t\u0001!B\u0013\tI\u0003C\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H!I!Q\u000e\u0001A\u0002\u0013%!q\u000e\u0005\t\u0005g\u0002\u0001\u0015)\u0003\u0002J!I!Q\u0010\u0001C\u0002\u0013%!q\u0010\u0005\t\u0007c\u0001\u0001\u0015!\u0003\u0003\u0002\"I11\u0007\u0001C\u0002\u0013%1Q\u0007\u0005\t\u0007g\u0003\u0001\u0015!\u0003\u00048!9!q\u0012\u0001\u0005B\tE\u0005bBB[\u0001\u0011\u0005#\u0011\u0013\u0005\b\u0007o\u0003A\u0011IB]\u0011\u001d\u0019\u0019\u000e\u0001C\u0005\u0007+4\u0011Ba#\u0001!\u0003\r\nA!$\t\u000f\t=5C\"\u0001\u0003\u0012\"9!1S\n\u0007\u0002\tEeA\u0002BC\u0001\u0011\u00119\tC\u0004\u0002\u0006Y!\tA!&\t\u0013\t]eC1A\u0005\n\te\u0005\u0002\u0003BT-\u0001\u0006IAa'\t\u0013\t%fC1A\u0005\n\t-\u0006\u0002\u0003B]-\u0001\u0006IA!,\t\u0013\tmfC1A\u0005\n\tu\u0006\u0002\u0003Bf-\u0001\u0006IAa0\t\u0013\t5gC1A\u0005\n\t=\u0007\u0002\u0003Bx-\u0001\u0006IA!5\t\u0013\tEh\u00031A\u0005\n\tM\b\"CB\u0001-\u0001\u0007I\u0011BB\u0002\u0011!\u00199A\u0006Q!\n\tU\bb\u0002BH-\u0011\u0005!\u0011\u0013\u0005\b\u0005'3B\u0011\u0001BI\u0011\u001d\u0019IA\u0006C\u0005\u0005#Cqaa\u0003\u0017\t\u0013\u0019iA\u0002\u0004\u0004:\u0001!11\b\u0005\b\u0003\u000b9C\u0011AB\u001f\u0011%\u00119j\nb\u0001\n\u0013\u0011I\n\u0003\u0005\u0003(\u001e\u0002\u000b\u0011\u0002BN\u0011%\u0011Ik\nb\u0001\n\u0013\u0011Y\u000b\u0003\u0005\u0003:\u001e\u0002\u000b\u0011\u0002BW\u0011%\u0011Yl\nb\u0001\n\u0013\u0011i\f\u0003\u0005\u0003L\u001e\u0002\u000b\u0011\u0002B`\u0011%\u0019yd\nb\u0001\n\u0013\u0019\t\u0005\u0003\u0005\u0004T\u001d\u0002\u000b\u0011BB\"\u0011%\u0019)f\nb\u0001\n\u0013\u00199\u0006\u0003\u0005\u0004`\u001d\u0002\u000b\u0011BB-\u0011%\u0019\tg\nb\u0001\n\u0013\u0019\u0019\u0007\u0003\u0005\u0004l\u001d\u0002\u000b\u0011BB3\u0011%\u0019ig\nb\u0001\n\u0013\u0019y\u0007\u0003\u0005\u0004x\u001d\u0002\u000b\u0011BB9\u0011%\u0019Ih\nb\u0001\n\u0013\u0019Y\b\u0003\u0005\u0004\u0004\u001e\u0002\u000b\u0011BB?\u0011%\u0019)i\nb\u0001\n\u0013\u00199\t\u0003\u0005\u0004\u0010\u001e\u0002\u000b\u0011BBE\u0011%\u0019\tj\nb\u0001\n\u0013\u0019\u0019\n\u0003\u0005\u0004\u001c\u001e\u0002\u000b\u0011BBK\u0011\u001d\u0011yi\nC\u0001\u0005#CqAa%(\t\u0003\u0011\t\nC\u0004\u0004\u001e\u001e\"IA!%\t\u000f\r}u\u0005\"\u0003\u0003\u0012\"91\u0011U\u0014\u0005\n\tE\u0005bBBRO\u0011%1Q\u0015\u0005\b\u0007_;C\u0011\u0002BI\u0011\u001d\u0019\tl\nC\u0005\u0005#;q!!\u0014f\u0011\u0003\tyE\u0002\u0004eK\"\u0005\u0011\u0011\u000b\u0005\b\u0003\u000b1E\u0011AA*\r\u0019\t)F\u0012\u0001\u0002X!9\u0011Q\u0001%\u0005\u0002\u0005}\u0003bBA3\u0011\u0012\u0005\u0013q\r\u0004\u0007\u0003{2\u0005)!!\t\u0015\u0005\u00056J!f\u0001\n\u0003\t\u0019\u000b\u0003\u0006\u00022.\u0013\t\u0012)A\u0005\u0003KC!\"a-L\u0005+\u0007I\u0011AAR\u0011)\t)l\u0013B\tB\u0003%\u0011Q\u0015\u0005\b\u0003\u000bYE\u0011AA\\\u0011%\tylSA\u0001\n\u0003\t\t\rC\u0005\u0002H.\u000b\n\u0011\"\u0001\u0002J\"I\u0011q\\&\u0012\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003C\\\u0015\u0011!C!\u0003#A\u0011\"a9L\u0003\u0003%\t!!:\t\u0013\u000558*!A\u0005\u0002\u0005=\b\"CA}\u0017\u0006\u0005I\u0011IA~\u0011%\u0011IaSA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u0016-\u000b\t\u0011\"\u0011\u0003\u0018!I!1D&\u0002\u0002\u0013\u0005#Q\u0004\u0005\n\u0005?Y\u0015\u0011!C!\u0005CA\u0011Ba\tL\u0003\u0003%\tE!\n\b\u0013\t%b)!A\t\u0002\t-b!CA?\r\u0006\u0005\t\u0012\u0001B\u0017\u0011\u001d\t)A\u0018C\u0001\u0005\u000bB\u0011Ba\b_\u0003\u0003%)E!\t\t\u0013\t\u001dc,!A\u0005\u0002\n%\u0003\"\u0003B(=\u0006\u0005I\u0011\u0011B)\u0011%\u0011\u0019GXA\u0001\n\u0013\u0011)G\u0001\u000bI_N$X*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN\u001d\u0006\u0003M\u001e\fA\u0001[8ti*\u0011\u0001.[\u0001\u0007gf\u001cH/Z7\u000b\u0005)\\\u0017aD5ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u000b\u00031\fQa[1n_:\u001c\u0001aE\u0002\u0001_V\u0004\"\u0001]:\u000e\u0003ET\u0011A]\u0001\u0006g\u000e\fG.Y\u0005\u0003iF\u0014a!\u00118z%\u00164\u0007C\u0001<z\u001b\u00059(B\u0001=l\u0003\u0019iw\u000eZ;mK&\u0011!p\u001e\u0002\u0010'\u000eDW\rZ;mK\u0012\f5\r^5p]\u0006\u0011Qm\u0019\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}\f\u0018AC2p]\u000e,(O]3oi&\u0019\u00111\u0001@\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0003\u0002\n\u00055\u0001cAA\u0006\u00015\tQ\rC\u0003|\u0005\u0001\u0007A0A\u0006`G>tg-[4QCRDWCAA\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\tA\u0001\\1oO*\u0011\u0011QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\"\u0005]!AB*ue&tw-\u0001\u0007`G>tg-[4QCRD\u0007%A\n`Y\u0006\u001cH/\u00138ge\u0016\fX/\u001a8u)&\u001c7.\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiC\u0003\u0003\u00020\u0005m\u0011\u0001\u0002;j[\u0016LA!a\r\u0002.\t9\u0011J\\:uC:$\u0018aF0mCN$\u0018J\u001c4sKF,XM\u001c;US\u000e\\w\fJ3r)\u0011\tI$a\u0010\u0011\u0007A\fY$C\u0002\u0002>E\u0014A!\u00168ji\"I\u0011\u0011\t\u0004\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0014\u0001F0mCN$\u0018J\u001c4sKF,XM\u001c;US\u000e\\\u0007%A\u0005`g\u0016$H/\u001b8hgV\u0011\u0011\u0011\n\t\u0004\u0003\u0017ZebAA\u0006\u000b\u0006!\u0002j\\:u\u001b\u0016$(/[2t\u0007>dG.Z2u_J\u00042!a\u0003G'\t1u\u000e\u0006\u0002\u0002P\t9a)Y2u_JL8\u0003\u0002%p\u00033\u00022A^A.\u0013\r\tif\u001e\u0002\u000e\u001b>$W\u000f\\3GC\u000e$xN]=\u0015\u0005\u0005\u0005\u0004cAA2\u00116\ta)\u0001\u0004de\u0016\fG/\u001a\u000b\u0005\u0003S\ny\u0007E\u0002w\u0003WJ1!!\u001cx\u0005\u0019iu\u000eZ;mK\"9\u0011\u0011\u000f&A\u0002\u0005M\u0014\u0001C:fiRLgnZ:\u0011\t\u0005U\u00141\u0010\b\u0004m\u0006]\u0014bAA=o\u0006iQj\u001c3vY\u00164\u0015m\u0019;pefLA!! \u0002\u0000\tA1+\u001a;uS:<7OC\u0002\u0002z]\u001cbaS8\u0002\u0004\u0006%\u0005c\u00019\u0002\u0006&\u0019\u0011qQ9\u0003\u000fA\u0013x\u000eZ;diB!\u00111RAN\u001d\u0011\ti)a&\u000f\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%n\u0003\u0019a$o\\8u}%\t!/C\u0002\u0002\u001aF\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0006}%\u0001D*fe&\fG.\u001b>bE2,'bAAMc\u0006\tBO]1dW\u0016$\u0017J\u001c;fe\u001a\f7-Z:\u0016\u0005\u0005\u0015\u0006\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-6.\u0001\u0003vi&d\u0017\u0002BAX\u0003S\u0013aAR5mi\u0016\u0014\u0018A\u0005;sC\u000e\\W\rZ%oi\u0016\u0014h-Y2fg\u0002\nQ\u0002\u001e:bG.,G-T8v]R\u001c\u0018A\u0004;sC\u000e\\W\rZ'pk:$8\u000f\t\u000b\u0007\u0003s\u000bY,!0\u0011\u0007\u0005\r4\nC\u0004\u0002\"B\u0003\r!!*\t\u000f\u0005M\u0006\u000b1\u0001\u0002&\u0006!1m\u001c9z)\u0019\tI,a1\u0002F\"I\u0011\u0011U)\u0011\u0002\u0003\u0007\u0011Q\u0015\u0005\n\u0003g\u000b\u0006\u0013!a\u0001\u0003K\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002L*\"\u0011QUAgW\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\u0013Ut7\r[3dW\u0016$'bAAmc\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\bc\u00019\u0002j&\u0019\u00111^9\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E\u0018q\u001f\t\u0004a\u0006M\u0018bAA{c\n\u0019\u0011I\\=\t\u0013\u0005\u0005c+!AA\u0002\u0005\u001d\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\bCBA\u0000\u0005\u000b\t\t0\u0004\u0002\u0003\u0002)\u0019!1A9\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\b\t\u0005!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0004\u0003\u0014A\u0019\u0001Oa\u0004\n\u0007\tE\u0011OA\u0004C_>dW-\u00198\t\u0013\u0005\u0005\u0003,!AA\u0002\u0005E\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0005\u0003\u001a!I\u0011\u0011I-\u0002\u0002\u0003\u0007\u0011q]\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q]\u0001\ti>\u001cFO]5oOR\u0011\u00111C\u0001\u0007KF,\u0018\r\\:\u0015\t\t5!q\u0005\u0005\n\u0003\u0003b\u0016\u0011!a\u0001\u0003c\f\u0001bU3ui&twm\u001d\t\u0004\u0003Gr6#\u00020\u00030\tm\u0002C\u0003B\u0019\u0005o\t)+!*\u0002:6\u0011!1\u0007\u0006\u0004\u0005k\t\u0018a\u0002:v]RLW.Z\u0005\u0005\u0005s\u0011\u0019DA\tBEN$(/Y2u\rVt7\r^5p]J\u0002BA!\u0010\u0003D5\u0011!q\b\u0006\u0005\u0005\u0003\nY\"\u0001\u0002j_&!\u0011Q\u0014B )\t\u0011Y#A\u0003baBd\u0017\u0010\u0006\u0004\u0002:\n-#Q\n\u0005\b\u0003C\u000b\u0007\u0019AAS\u0011\u001d\t\u0019,\u0019a\u0001\u0003K\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003T\t}\u0003#\u00029\u0003V\te\u0013b\u0001B,c\n1q\n\u001d;j_:\u0004r\u0001\u001dB.\u0003K\u000b)+C\u0002\u0003^E\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003B1E\u0006\u0005\t\u0019AA]\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005O\u0002B!!\u0006\u0003j%!!1NA\f\u0005\u0019y%M[3di\u0006iql]3ui&twm]0%KF$B!!\u000f\u0003r!I\u0011\u0011I\u0005\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u000b?N,G\u000f^5oON\u0004\u0003f\u0001\u0006\u0003xA\u0019\u0001O!\u001f\n\u0007\tm\u0014O\u0001\u0005w_2\fG/\u001b7f\u0003IyfM]3rk\u0016tGoQ8mY\u0016\u001cGo\u001c:\u0016\u0005\t\u0005\u0005c\u0001BB-5\t\u0001A\u0001\fGe\u0016\fX/\u001a8u\u0007>dG.Z2uS>tG+Y:l'\u00111rN!#\u0011\u0007\t\r5C\u0001\bD_2dWm\u0019;j_:$\u0016m]6\u0014\u0005My\u0017a\u0001:v]R\u0011\u0011\u0011H\u0001\bG2,\u0017M\\;q)\t\u0011\t)\u0001\u0007`I\u00164\u0017-\u001e7u)\u0006<7/\u0006\u0002\u0003\u001cB!!Q\u0014BR\u001b\t\u0011yJC\u0002\u0003\".\f1\u0001^1h\u0013\u0011\u0011)Ka(\u0003\rQ\u000bwmU3u\u00035yF-\u001a4bk2$H+Y4tA\u0005Yql]=ti\u0016l\u0017J\u001c4p+\t\u0011i\u000b\u0005\u0003\u00030\nUVB\u0001BY\u0015\t\u0011\u0019,\u0001\u0003pg\"L\u0017\u0002\u0002B\\\u0005c\u0013!bU=ti\u0016l\u0017J\u001c4p\u00031y6/_:uK6LeNZ8!\u0003\u0011y\u0006.\u00197\u0016\u0005\t}\u0006\u0003\u0002Ba\u0005\u000fl!Aa1\u000b\t\t\u0015'\u0011W\u0001\tQ\u0006\u0014Hm^1sK&!!\u0011\u001aBb\u0005aA\u0015M\u001d3xCJ,\u0017IY:ue\u0006\u001cG/[8o\u0019\u0006LXM]\u0001\u0006?\"\fG\u000eI\u0001\u0010?\u000e\u0004X/\u00138tiJ,X.\u001a8ugV\u0011!\u0011\u001b\t\u0005\u0005'\u0014IO\u0004\u0003\u0003V\n\u0015h\u0002\u0002Bl\u0005GtAA!7\u0003b:!!1\u001cBp\u001d\u0011\tyI!8\n\u00031L!A[6\n\u0005!L\u0017B\u00014h\u0013\r\u00119/Z\u0001\f\u0011>\u001cH/T3ue&\u001c7/\u0003\u0003\u0003l\n5(AD\"qk&s7\u000f\u001e:v[\u0016tGo\u001d\u0006\u0004\u0005O,\u0017\u0001E0daVLen\u001d;sk6,g\u000e^:!\u0003Ey\u0006O]3w\u0007B,Hj\\1e)&\u001c7n]\u000b\u0003\u0005k\u0004R\u0001\u001dB|\u0005wL1A!?r\u0005\u0015\t%O]1z!\r\u0001(Q`\u0005\u0004\u0005\u007f\f(\u0001\u0002'p]\u001e\fQc\u00189sKZ\u001c\u0005/\u001e'pC\u0012$\u0016nY6t?\u0012*\u0017\u000f\u0006\u0003\u0002:\r\u0015\u0001\"CA!C\u0005\u0005\t\u0019\u0001B{\u0003Iy\u0006O]3w\u0007B,Hj\\1e)&\u001c7n\u001d\u0011\u0002\u001dI,7m\u001c:e\u0007B,Xk]1hK\u0006IA/[2lg\u0012KgM\u001a\u000b\t\u0005w\u001cyaa\u0005\u0004\u0018!91\u0011\u0003\u0014A\u0002\tU\u0018\u0001\u00039sKZLw.^:\t\u000f\rUa\u00051\u0001\u0003v\u000691-\u001e:sK:$\bbBB\rM\u0001\u000711D\u0001\ti&\u001c7\u000eV=qKB!1QDB\u0016\u001d\u0011\u0019yba\n\u000f\t\r\u00052Q\u0005\b\u0005\u0003\u001f\u001b\u0019#\u0003\u0002\u00034&!!Q\u0019BY\u0013\u0011\u0019ICa1\u0002!\r+g\u000e\u001e:bYB\u0013xnY3tg>\u0014\u0018\u0002BB\u0017\u0007_\u0011\u0001\u0002V5dWRK\b/\u001a\u0006\u0005\u0007S\u0011\u0019-A\n`MJ,\u0017/^3oi\u000e{G\u000e\\3di>\u0014\b%\u0001\u000b`S:4'/Z9vK:$8i\u001c7mK\u000e$xN]\u000b\u0003\u0007o\u00012Aa!(\u0005aIeN\u001a:fcV,g\u000e^\"pY2,7\r^5p]R\u000b7o[\n\u0005O=\u0014I\t\u0006\u0002\u00048\u0005\u0019ql\\:\u0016\u0005\r\r\u0003\u0003BB#\u0007\u001fj!aa\u0012\u000b\t\r%31J\u0001\u0003_NTAa!\u0014\u00032\u0006A1o\u001c4uo\u0006\u0014X-\u0003\u0003\u0004R\r\u001d#aD(qKJ\fG/\u001b8h'f\u001cH/Z7\u0002\t}{7\u000fI\u0001\u0013?6,Wn\u001c:z\u0013:\u001cHO];nK:$8/\u0006\u0002\u0004ZA!!1[B.\u0013\u0011\u0019iF!<\u0003#5+Wn\u001c:z\u0013:\u001cHO];nK:$8/A\n`[\u0016lwN]=J]N$(/^7f]R\u001c\b%\u0001\t`g^\f\u0007/\u00138tiJ,X.\u001a8ugV\u00111Q\r\t\u0005\u0005'\u001c9'\u0003\u0003\u0004j\t5(aD*xCBLen\u001d;sk6,g\u000e^:\u0002#}\u001bx/\u00199J]N$(/^7f]R\u001c\b%A\f`Y>\fG-\u0011<fe\u0006<W-\u00138tiJ,X.\u001a8ugV\u00111\u0011\u000f\t\u0005\u0005'\u001c\u0019(\u0003\u0003\u0004v\t5(A\u0006'pC\u0012\fe/\u001a:bO\u0016Len\u001d;sk6,g\u000e^:\u00021}cw.\u00193Bm\u0016\u0014\u0018mZ3J]N$(/^7f]R\u001c\b%A\u000e`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0007{\u0002BAa5\u0004\u0000%!1\u0011\u0011Bw\u0005]\u0019Fo\u001c:bO\u0016lu.\u001e8u\u0013:\u001cHO];nK:$8/\u0001\u000f`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0002=}3\u0017\u000e\\3TsN$X-\\!di&4\u0018\u000e^=J]N$(/^7f]R\u001cXCABE!\u0011\u0011\u0019na#\n\t\r5%Q\u001e\u0002\u0019'R|'/Y4f\t\u00164\u0018nY3J]N$(/^7f]R\u001c\u0018aH0gS2,7+_:uK6\f5\r^5wSRL\u0018J\\:ueVlWM\u001c;tA\u0005YrL\\3uo>\u00148.Q2uSZLG/_%ogR\u0014X/\\3oiN,\"a!&\u0011\t\tM7qS\u0005\u0005\u00073\u0013iO\u0001\u000eOKR<xN]6BGRLg/\u001b;z\u0013:\u001cHO];nK:$8/\u0001\u000f`]\u0016$xo\u001c:l\u0003\u000e$\u0018N^5us&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0002#I,7m\u001c:e\u001b\u0016lwN]=Vg\u0006<W-A\tsK\u000e|'\u000f\u001a'pC\u0012\fe/\u001a:bO\u0016\f!C]3d_J$7\u000b^8sC\u001e,Wk]1hK\u0006IAo\u001c)fe\u000e,g\u000e\u001e\u000b\u0007\u0005w\u001c9ka+\t\u000f\r%&\t1\u0001\u0003|\u0006)a/\u00197vK\"91Q\u0016\"A\u0002\tm\u0018!\u0002;pi\u0006d\u0017!\u0006:fG>\u0014Hm\u0015;pe\u0006<W-Q2uSZLG/_\u0001\u0016e\u0016\u001cwN\u001d3OKR<xN]6BGRLg/\u001b;z\u0003Uy\u0016N\u001c4sKF,XM\u001c;D_2dWm\u0019;pe\u0002\nAa\u001d;pa\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0011\tIda/\t\u000f\ru\u0016\u00031\u0001\u0004@\u0006Ia.Z<D_:4\u0017n\u001a\t\u0005\u0007\u0003\u001cy-\u0004\u0002\u0004D*!1QYBd\u0003\u0019\u0019wN\u001c4jO*!1\u0011ZBf\u0003!!\u0018\u0010]3tC\u001a,'BABg\u0003\r\u0019w.\\\u0005\u0005\u0007#\u001c\u0019M\u0001\u0004D_:4\u0017nZ\u0001\re\u0016\fGmU3ui&twm\u001d\u000b\u0005\u0003\u0013\u001a9\u000eC\u0004\u0004FJ\u0001\raa0")
public class HostMetricsCollector
implements ScheduledAction {
    private final String _configPath;
    private Instant _lastInfrequentTick = Instant.now();
    private volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
    private final FrequentCollectionTask _frequentCollector = new FrequentCollectionTask();
    private final InfrequentCollectionTask _infrequentCollector = new InfrequentCollectionTask();

    private String _configPath() {
        return this._configPath;
    }

    private Instant _lastInfrequentTick() {
        return this._lastInfrequentTick;
    }

    private void _lastInfrequentTick_$eq(Instant x$1) {
        this._lastInfrequentTick = x$1;
    }

    public Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings() {
        return this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    }

    private void _settings_$eq(Settings x$1) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = x$1;
    }

    private FrequentCollectionTask _frequentCollector() {
        return this._frequentCollector;
    }

    private InfrequentCollectionTask _infrequentCollector() {
        return this._infrequentCollector;
    }

    public void run() {
        this._frequentCollector().run();
        if (Duration.between(this._lastInfrequentTick(), Instant.now()).getSeconds() >= 10L) {
            this._infrequentCollector().run();
            this._lastInfrequentTick_$eq(Instant.now());
            return;
        }
    }

    public void stop() {
        this._frequentCollector().cleanup();
        this._infrequentCollector().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this._settings_$eq(this.readSettings(newConfig));
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath());
        return new Settings(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    public HostMetricsCollector(ExecutionContext ec) {
        this._configPath = "kamon.instrumentation.system.host";
    }

    public interface CollectionTask {
        public void run();

        public void cleanup();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    private class FrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private HostMetrics.CpuInstruments _cpuInstruments() {
            return this._cpuInstruments;
        }

        private long[] _prevCpuLoadTicks() {
            return this._prevCpuLoadTicks;
        }

        private void _prevCpuLoadTicks_$eq(long[] x$1) {
            this._prevCpuLoadTicks = x$1;
        }

        @Override
        public void run() {
            this.recordCpuUsage();
        }

        @Override
        public void cleanup() {
            this._cpuInstruments().remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks().length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks();
                long[] currentTicks = this._hal().getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments().user().record(FrequentCollectionTask.toPercent$1(user, total));
                this._cpuInstruments().system().record(FrequentCollectionTask.toPercent$1(system, total));
                this._cpuInstruments().iowait().record(FrequentCollectionTask.toPercent$1(iowait, total));
                this._cpuInstruments().idle().record(FrequentCollectionTask.toPercent$1(idle, total));
                this._cpuInstruments().stolen().record(FrequentCollectionTask.toPercent$1(steal, total));
                this._cpuInstruments().combined().record(FrequentCollectionTask.toPercent$1(user + system + nice + iowait, total));
                this._prevCpuLoadTicks_$eq(currentTicks);
                return;
            }
            this._prevCpuLoadTicks_$eq(this._hal().getProcessor().getSystemCpuLoadTicks());
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        private static final long toPercent$1(long value, long total$1) {
            return (long)(100.0 * (double)value / (double)total$1);
        }

        public FrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(this._defaultTags());
            this._prevCpuLoadTicks = (long[])Array$.MODULE$.ofDim(0, (ClassTag)ClassTag$.MODULE$.Long());
        }
    }

    private class InfrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments _fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments _networkActivityInstruments;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private HostMetrics.MemoryInstruments _memoryInstruments() {
            return this._memoryInstruments;
        }

        private HostMetrics.SwapInstruments _swapInstruments() {
            return this._swapInstruments;
        }

        private HostMetrics.LoadAverageInstruments _loadAverageInstruments() {
            return this._loadAverageInstruments;
        }

        private HostMetrics.StorageMountInstruments _fileSystemUsageInstruments() {
            return this._fileSystemUsageInstruments;
        }

        private HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments() {
            return this._fileSystemActivityInstruments;
        }

        private HostMetrics.NetworkActivityInstruments _networkActivityInstruments() {
            return this._networkActivityInstruments;
        }

        @Override
        public void run() {
            this.recordMemoryUsage();
            this.recordLoadAverage();
            this.recordStorageUsage();
            this.recordStorageActivity();
            this.recordNetworkActivity();
        }

        @Override
        public void cleanup() {
            this._memoryInstruments().remove();
            this._swapInstruments().remove();
            this._loadAverageInstruments().remove();
            this._fileSystemUsageInstruments().remove();
            this._fileSystemActivityInstruments().remove();
            this._networkActivityInstruments().remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal().getMemory();
            long totalMemory = memory.getTotal();
            long availableMemory = memory.getAvailable();
            long usedMemory = totalMemory - availableMemory;
            this._memoryInstruments().total().update((double)totalMemory);
            this._memoryInstruments().free().update((double)availableMemory);
            this._memoryInstruments().used().update((double)usedMemory);
            this._memoryInstruments().usage().update((double)this.toPercent(usedMemory, totalMemory));
            long usedSwap = memory.getVirtualMemory().getSwapUsed();
            long totalSwap = memory.getVirtualMemory().getSwapTotal();
            this._swapInstruments().total().update((double)totalSwap);
            this._swapInstruments().used().update((double)usedSwap);
            this._swapInstruments().usage().update((double)this.toPercent(usedSwap, totalSwap));
            this._swapInstruments().free().update((double)(totalSwap - usedSwap));
        }

        private void recordLoadAverage() {
            double[] loadAverage = this._hal().getProcessor().getSystemLoadAverage(3);
            Object object = loadAverage[0] >= 0.0 ? this._loadAverageInstruments().oneMinute().update(loadAverage[0]) : BoxedUnit.UNIT;
            Object object2 = loadAverage[1] >= 0.0 ? this._loadAverageInstruments().fiveMinutes().update(loadAverage[1]) : BoxedUnit.UNIT;
            if (loadAverage[2] >= 0.0) {
                this._loadAverageInstruments().fifteenMinutes().update(loadAverage[2]);
                return;
            }
        }

        private void recordStorageUsage() {
            List fileStores = this._os().getFileSystem().getFileStores();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(fileStores).asScala()).foreach((Function1 & Serializable)fs -> {
                if (this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedMounts().accept(fs.getType())) {
                    HostMetrics.StorageMountInstruments.MountInstruments mountInstruments = this._fileSystemUsageInstruments().mountInstruments(fs.getMount());
                    long totalSpace = fs.getTotalSpace();
                    long usedSpace = totalSpace - fs.getUsableSpace();
                    mountInstruments.free().update((double)fs.getUsableSpace());
                    mountInstruments.total().update((double)totalSpace);
                    mountInstruments.used().update((double)usedSpace);
                    return mountInstruments.usage().update((double)this.toPercent(usedSpace, totalSpace));
                }
                return BoxedUnit.UNIT;
            });
        }

        private long toPercent(long value, long total) {
            return (long)(100.0 * (double)value / (double)total);
        }

        private void recordStorageActivity() {
            List devices = this._hal().getDiskStores();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(devices).asScala()).foreach((Function1 & Serializable)device -> {
                InfrequentCollectionTask.$anonfun$recordStorageActivity$1(this, device);
                return BoxedUnit.UNIT;
            });
        }

        private void recordNetworkActivity() {
            List interfaces = this._hal().getNetworkIFs();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(interfaces).asScala()).foreach((Function1 & Serializable)networkIF -> {
                InfrequentCollectionTask.$anonfun$recordNetworkActivity$1(this, networkIF);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        public static final /* synthetic */ void $anonfun$recordStorageActivity$1(InfrequentCollectionTask $this, HWDiskStore device) {
            if (!device.getPartitions().isEmpty()) {
                HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments = $this._fileSystemActivityInstruments().deviceInstruments(device.getName());
                deviceInstruments.reads().diff(device.getReads());
                deviceInstruments.writes().diff(device.getWrites());
                deviceInstruments.readBytes().diff(device.getReadBytes());
                deviceInstruments.writeBytes().diff(device.getWriteBytes());
                return;
            }
        }

        public static final /* synthetic */ void $anonfun$recordNetworkActivity$1(InfrequentCollectionTask $this, NetworkIF networkIF) {
            if ($this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedInterfaces().accept(networkIF.getName())) {
                networkIF.updateAttributes();
                HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments = $this._networkActivityInstruments().interfaceInstruments(networkIF.getName());
                interfaceInstruments.receivedBytes().diff(networkIF.getBytesRecv());
                interfaceInstruments.sentBytes().diff(networkIF.getBytesSent());
                interfaceInstruments.sentPackets().diff(networkIF.getPacketsSent());
                interfaceInstruments.receivedPackets().diff(networkIF.getPacketsRecv());
                interfaceInstruments.sendErrorPackets().diff(networkIF.getOutErrors());
                interfaceInstruments.receiveErrorPackets().diff(networkIF.getInErrors());
                return;
            }
        }

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(this._defaultTags());
            this._swapInstruments = new HostMetrics.SwapInstruments(this._defaultTags());
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(this._defaultTags());
            this._fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(this._defaultTags());
            this._fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(this._defaultTags());
            this._networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(this._defaultTags());
        }
    }

    public static class Settings
    implements Product,
    Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.trackedInterfaces();
                }
                case 1: {
                    return this.trackedMounts();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "trackedInterfaces";
                }
                case 1: {
                    return "trackedMounts";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            Filter filter2 = this.trackedInterfaces();
            Filter filter3 = settings.trackedInterfaces();
            if (filter2 == null) {
                if (filter3 != null) {
                    return false;
                }
            } else if (!filter2.equals(filter3)) return false;
            Filter filter4 = this.trackedMounts();
            Filter filter5 = settings.trackedMounts();
            if (filter4 == null) {
                if (filter5 != null) {
                    return false;
                }
            } else if (!filter4.equals(filter5)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
            Product.$init$((Product)this);
        }
    }
}

