/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.executor;

import java.util.Collection;
import java.util.concurrent.Callable;
import kamon.instrumentation.executor.CaptureContextOnSubmitAdvices;
import kamon.instrumentation.executor.ContextAware;
import kanela.agent.api.instrumentation.InstrumentationBuilder;
import kanela.agent.bootstrap.ContextApi;
import kanela.agent.bootstrap.ContextApiImplementation;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaptureContextOnSubmitInstrumentation
extends InstrumentationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CaptureContextOnSubmitInstrumentation.class);

    public CaptureContextOnSubmitInstrumentation() {
        ContextApi.setContextApiImplementation((ContextApiImplementation)new KamonContextApiImplementation());
        this.onSubTypesOf(new String[]{"java.util.concurrent.Executor"}).advise(this.method("execute").and((ElementMatcher)this.withArgument(Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class);
        this.onSubTypesOf(new String[]{"java.util.concurrent.ExecutorService"}).advise(this.method("submit").and((ElementMatcher)this.withArgument(Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class).advise(this.method("submit").and((ElementMatcher)this.withArgument(Callable.class)), CaptureContextOnSubmitAdvices.CallableWrapperAdvisor.class).advise(this.anyMethods(new String[]{"invokeAny", "invokeAll"}).and((ElementMatcher)this.withArgument(Collection.class)), CaptureContextOnSubmitAdvices.CallableCollectionWrapperAdvisor.class);
        this.onSubTypesOf(new String[]{"java.util.concurrent.ScheduledExecutorService"}).advise(this.method("schedule").and((ElementMatcher)this.withArgument(0, Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class).advise(this.method("schedule").and((ElementMatcher)this.withArgument(0, Callable.class)), CaptureContextOnSubmitAdvices.CallableWrapperAdvisor.class);
    }

    private static class KamonContextApiImplementation
    implements ContextApiImplementation {
        private KamonContextApiImplementation() {
        }

        public Runnable wrapRunnable(Runnable runnable) {
            return new ContextAware.DefaultContextAwareRunnable(runnable);
        }

        public <A> Callable wrapCallable(Callable<A> callable) {
            return new ContextAware.DefaultContextAwareCallable<A>(callable);
        }
    }
}

