/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.apache.httpclient;

import java.io.Serializable;
import java.net.URI;
import kamon.instrumentation.apache.httpclient.ApacheHttpClientHelper;
import kamon.instrumentation.http.HttpMessage;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Map;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ApacheHttpClientHelper$ {
    public static final ApacheHttpClientHelper$ MODULE$ = new ApacheHttpClientHelper$();
    private static final Logger kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger = LoggerFactory.getLogger(ApacheHttpClientHelper.class);

    public Logger kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger() {
        return kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger;
    }

    public HttpMessage.RequestBuilder<HttpRequest> toRequestBuilder(HttpHost httpHost, HttpRequest request) {
        return new ApacheHttpClientHelper.RequestReader(request, httpHost){
            private final HttpRequest delegate;
            private final URI uri;

            public String host() {
                return ApacheHttpClientHelper.RequestReader.host$(this);
            }

            public int port() {
                return ApacheHttpClientHelper.RequestReader.port$(this);
            }

            public String method() {
                return ApacheHttpClientHelper.RequestReader.method$(this);
            }

            public String path() {
                return ApacheHttpClientHelper.RequestReader.path$(this);
            }

            public Option<String> read(String header) {
                return ApacheHttpClientHelper.RequestReader.read$(this, header);
            }

            public Map<String, String> readAll() {
                return ApacheHttpClientHelper.RequestReader.readAll$(this);
            }

            public String url() {
                return ApacheHttpClientHelper.RequestReader.url$(this);
            }

            public HttpRequest delegate() {
                return this.delegate;
            }

            public URI uri() {
                return this.uri;
            }

            public void write(String header, String value) {
                this.delegate().addHeader(header, value);
            }

            public HttpRequest build() {
                ApacheHttpClientHelper$.MODULE$.kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger().trace("Prepared request for instrumentation: {}", (Object)this);
                return this.delegate();
            }

            public String toString() {
                return new StringBuilder(25).append("Host=").append(this.host()).append(",Port=").append(this.port()).append(",Method=").append(this.method()).append(",Path=").append(this.path()).toString();
            }
            {
                void var3_3;
                ApacheHttpClientHelper.RequestReader.$init$(this);
                this.delegate = request$1;
                URI parsedUri = ApacheHttpClientHelper$.MODULE$.getUri(request$1);
                if (parsedUri != null && httpHost$1 != null) {
                    parsedUri = ApacheHttpClientHelper$.MODULE$.getCompleteUri(httpHost$1, parsedUri);
                }
                this.uri = var3_3;
            }
        };
    }

    public HttpMessage.RequestBuilder<HttpUriRequest> toRequestBuilder(HttpUriRequest request) {
        return new ApacheHttpClientHelper.RequestReader(request){
            private final URI uri;
            private final HttpUriRequest delegate;

            public String host() {
                return ApacheHttpClientHelper.RequestReader.host$(this);
            }

            public int port() {
                return ApacheHttpClientHelper.RequestReader.port$(this);
            }

            public String method() {
                return ApacheHttpClientHelper.RequestReader.method$(this);
            }

            public String path() {
                return ApacheHttpClientHelper.RequestReader.path$(this);
            }

            public Option<String> read(String header) {
                return ApacheHttpClientHelper.RequestReader.read$(this, header);
            }

            public Map<String, String> readAll() {
                return ApacheHttpClientHelper.RequestReader.readAll$(this);
            }

            public String url() {
                return ApacheHttpClientHelper.RequestReader.url$(this);
            }

            public URI uri() {
                return this.uri;
            }

            public HttpUriRequest delegate() {
                return this.delegate;
            }

            public void write(String header, String value) {
                this.delegate().addHeader(header, value);
            }

            public HttpUriRequest build() {
                ApacheHttpClientHelper$.MODULE$.kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger().trace("Prepared request for instrumentation: {}", (Object)this);
                return this.delegate();
            }

            public String toString() {
                return new StringBuilder(25).append("Host=").append(this.host()).append(",Port=").append(this.port()).append(",Method=").append(this.method()).append(",Path=").append(this.path()).toString();
            }
            {
                ApacheHttpClientHelper.RequestReader.$init$(this);
                this.uri = request$2.getURI();
                this.delegate = request$2;
            }
        };
    }

    public HttpMessage.Response toResponse(HttpResponse response) {
        return new HttpMessage.Response(response){
            private final HttpResponse response$1;

            public int statusCode() {
                if (this.response$1 == null || this.response$1.getStatusLine() == null) {
                    ApacheHttpClientHelper$.MODULE$.kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger().debug("Not able to retrieve status code from response");
                    return -1;
                }
                return this.response$1.getStatusLine().getStatusCode();
            }
            {
                this.response$1 = response$1;
            }
        };
    }

    public URI getUri(HttpRequest request) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new URI(request.getRequestLine().getUri()));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger().error("Failed to construct URI from request", exception);
            return null;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            URI value = (URI)success.value();
            return value;
        }
        throw new MatchError((Object)try_);
    }

    public URI getCompleteUri(HttpHost host, URI uri) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new URI(host.getSchemeName(), null, host.getHostName(), host.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.kamon$instrumentation$apache$httpclient$ApacheHttpClientHelper$$_logger().error("Failed to construct URI from request", exception);
            return null;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            URI value = (URI)success.value();
            return value;
        }
        throw new MatchError((Object)try_);
    }

    private ApacheHttpClientHelper$() {
    }
}

