/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.apache.cxf.client;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import kamon.instrumentation.apache.cxf.client.ApacheCxfClientHelper;
import kamon.instrumentation.http.HttpMessage;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ApacheCxfClientHelper$ {
    public static final ApacheCxfClientHelper$ MODULE$ = new ApacheCxfClientHelper$();
    private static final Logger kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$_logger = LoggerFactory.getLogger(ApacheCxfClientHelper.class);

    public Logger kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$_logger() {
        return kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$_logger;
    }

    public HttpMessage.RequestBuilder<Message> toRequestBuilder(Message request) {
        return new ApacheCxfClientHelper.RequestReader(request){
            private final Message delegate;
            private final URI uri;

            public String host() {
                return ApacheCxfClientHelper.RequestReader.host$(this);
            }

            public int port() {
                return ApacheCxfClientHelper.RequestReader.port$(this);
            }

            public String method() {
                return ApacheCxfClientHelper.RequestReader.method$(this);
            }

            public String path() {
                return ApacheCxfClientHelper.RequestReader.path$(this);
            }

            public Option<String> read(String header) {
                return ApacheCxfClientHelper.RequestReader.read$(this, header);
            }

            public scala.collection.immutable.Map<String, String> readAll() {
                return ApacheCxfClientHelper.RequestReader.readAll$(this);
            }

            public String url() {
                return ApacheCxfClientHelper.RequestReader.url$(this);
            }

            public Message delegate() {
                return this.delegate;
            }

            public URI uri() {
                return this.uri;
            }

            public void write(String header, String value) {
                Builder builder = Predef$.MODULE$.Map().newBuilder();
                builder.$plus$plus$eq((IterableOnce)ApacheCxfClientHelper$.MODULE$.kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$getAllHeaders(this.delegate()).map((Function1 & Serializable)m3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(m3._1()), Collections.singletonList(m3._2()))));
                builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)header), Collections.singletonList(value)));
                this.delegate().put((Object)Message.PROTOCOL_HEADERS, JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)builder.result()).asJava());
            }

            public Message build() {
                ApacheCxfClientHelper$.MODULE$.kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$_logger().trace("Prepared request for instrumentation: {}", (Object)this);
                return this.delegate();
            }

            public String toString() {
                return new StringBuilder(40).append("RequestReader(host=").append(this.host()).append(",port=").append(this.port()).append(",method=").append(this.method()).append(",path=").append(this.path()).append(")").toString();
            }
            {
                ApacheCxfClientHelper.RequestReader.$init$(this);
                this.delegate = request$1;
                this.uri = ApacheCxfClientHelper$.MODULE$.kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$getUri(request$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$write$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public HttpMessage.Response toResponse(Message message) {
        return new HttpMessage.Response(message){
            private final Message message$1;

            public int statusCode() {
                Object object = this.message$1.get((Object)Message.RESPONSE_CODE);
                if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    return Predef$.MODULE$.Integer2int(n);
                }
                ApacheCxfClientHelper$.MODULE$.kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$_logger().debug("Not able to retrieve status code from response");
                return -1;
            }
            {
                this.message$1 = message$1;
            }
        };
    }

    public URI kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$getUri(Message message) {
        URI uRI;
        try {
            uRI = (URI)this.getUriAsString(message).map((Function1 & Serializable)s2 -> new URI((String)s2)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return uRI;
    }

    private Option<String> safeGet(Message message, String key) {
        if (message.containsKey((Object)key)) {
            Object object = message.get((Object)key);
            if (object instanceof String) {
                String string = (String)object;
                return Option$.MODULE$.apply((Object)string);
            }
            return Option$.MODULE$.empty();
        }
        return Option$.MODULE$.empty();
    }

    private Option<String> getUriAsString(Message message) {
        Option requestUrl = this.safeGet(message, "org.apache.cxf.request.url").orElse((Function0 & Serializable)() -> {
            Option address = MODULE$.safeGet(message, Message.ENDPOINT_ADDRESS);
            Option<String> requestUri = MODULE$.safeGet(message, "org.apache.cxf.request.uri");
            if (requestUri.exists((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)r.startsWith("/")))) {
                if (!address.exists((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)a.startsWith((String)requestUri.get())))) {
                    if (address.exists((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ApacheCxfClientHelper$.$anonfun$getUriAsString$4(t)))) {
                        address = address.map((Function1 & Serializable)a -> a.substring(0, a.length()));
                    }
                    return address.map((Function1 & Serializable)a -> new StringBuilder(0).append((String)a).append(requestUri.getOrElse((Function0 & Serializable)() -> "")).toString());
                }
                return requestUri;
            }
            return address;
        });
        return (Option)this.safeGet(message, Message.QUERY_STRING).map((Function1 & Serializable)q -> requestUrl.map((Function1 & Serializable)u -> new StringBuilder(1).append((String)u).append("?").append((String)q).toString())).getOrElse((Function0 & Serializable)() -> requestUrl);
    }

    public scala.collection.immutable.Map<String, String> kamon$instrumentation$apache$cxf$client$ApacheCxfClientHelper$$getAllHeaders(Message message) {
        java.util.Map map;
        Object object = message.get((Object)Message.PROTOCOL_HEADERS);
        return ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(object instanceof java.util.Map ? (map = (java.util.Map)object) : Collections.emptyMap()).asScala()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                List values = (List)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()).mkString(", "));
            }
            throw new MatchError((Object)tuple2);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$getUriAsString$4(String t) {
        return t.endsWith("/") && t.length() > 1;
    }

    private ApacheCxfClientHelper$() {
    }
}

