/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.time.Instant;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.DatabaseTags;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.HasDatabaseTags;
import kamon.instrumentation.jdbc.JdbcMetrics$;
import kamon.instrumentation.jdbc.StatementMonitor;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import kamon.instrumentation.jdbc.utils.SqlVisitor;
import kamon.metric.RangeSampler;
import kamon.tag.Lookups$;
import kamon.tag.TagSet$;
import kamon.trace.SpanBuilder;
import kanela.agent.bootstrap.stack.CallStackDepth;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class StatementMonitor$
implements LoggingSupport {
    public static final StatementMonitor$ MODULE$ = new StatementMonitor$();
    private static volatile boolean parseSqlOperationName;
    private static volatile boolean addStatementSQL;
    private static volatile boolean addPreparedStatementSQL;
    private static Logger logger;

    static {
        LoggingSupport.$init$(MODULE$);
        parseSqlOperationName = false;
        addStatementSQL = true;
        addPreparedStatementSQL = true;
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable)c -> {
            StatementMonitor$.MODULE$.updateSettings(c);
            return BoxedUnit.UNIT;
        });
        MODULE$.updateSettings(Kamon$.MODULE$.config());
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport.logInfo$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport.logWarn$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport.logError$(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport.logTrace$(this, msg);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private boolean parseSqlOperationName() {
        return parseSqlOperationName;
    }

    private void parseSqlOperationName_$eq(boolean x$1) {
        parseSqlOperationName = x$1;
    }

    private boolean addStatementSQL() {
        return addStatementSQL;
    }

    private void addStatementSQL_$eq(boolean x$1) {
        addStatementSQL = x$1;
    }

    private boolean addPreparedStatementSQL() {
        return addPreparedStatementSQL;
    }

    private void addPreparedStatementSQL_$eq(boolean x$1) {
        addPreparedStatementSQL = x$1;
    }

    private void updateSettings(Config config) {
        block5: {
            Config jdbcInstrumentationConfig = config.getConfig("kamon.instrumentation.jdbc");
            this.parseSqlOperationName_$eq(jdbcInstrumentationConfig.getBoolean("parse-sql-for-operation-name"));
            String string = jdbcInstrumentationConfig.getString("add-db-statement-as-span-tag");
            switch (string == null ? 0 : string.hashCode()) {
                case -1414557169: {
                    if (!"always".equals(string)) break;
                    this.addStatementSQL_$eq(true);
                    this.addPreparedStatementSQL_$eq(true);
                    break block5;
                }
                case -1279552451: {
                    if (!"prepared".equals(string)) break;
                    this.addStatementSQL_$eq(false);
                    this.addPreparedStatementSQL_$eq(true);
                    break block5;
                }
                case 104712844: {
                    if (!"never".equals(string)) break;
                    this.addStatementSQL_$eq(false);
                    this.addPreparedStatementSQL_$eq(false);
                    break block5;
                }
            }
            this.logger().warn(new StringBuilder(94).append("Unrecognized value [").append(string).append("] for the [add-db-statement-as-span-tag] setting. ").append("Falling back to [always]").toString());
        }
    }

    public Option<StatementMonitor.Invocation> start(Object statement, String sql, String statementType) {
        block10: {
            String string;
            RangeSampler rangeSampler;
            DatabaseTags databaseTags;
            Instant startTimestamp;
            block12: {
                Tuple2 tuple2;
                block11: {
                    Tuple2 tuple22;
                    HasConnectionPoolTelemetry hasConnectionPoolTelemetry;
                    if (CallStackDepth.incrementFor((Object)statement) != 0) break block10;
                    startTimestamp = Kamon$.MODULE$.clock().instant();
                    Object object = statement;
                    if (object instanceof HasConnectionPoolTelemetry && (hasConnectionPoolTelemetry = (HasConnectionPoolTelemetry)object).connectionPoolTelemetry() != null && hasConnectionPoolTelemetry.connectionPoolTelemetry().get() != null) {
                        ConnectionPoolTelemetry poolTelemetry = hasConnectionPoolTelemetry.connectionPoolTelemetry().get();
                        tuple22 = new Tuple2((Object)poolTelemetry.instruments().inFlightStatements(), (Object)poolTelemetry.databaseTags());
                    } else {
                        HasDatabaseTags hasDatabaseTags;
                        tuple22 = tuple2 = object instanceof HasDatabaseTags && (hasDatabaseTags = (HasDatabaseTags)object).databaseTags() != null ? new Tuple2(JdbcMetrics$.MODULE$.InFlightStatements().withTags(hasDatabaseTags.databaseTags().metricTags()), (Object)hasDatabaseTags.databaseTags()) : new Tuple2((Object)JdbcMetrics$.MODULE$.InFlightStatements().withoutTags(), (Object)new DatabaseTags(TagSet$.MODULE$.Empty(), TagSet$.MODULE$.Empty()));
                    }
                    if (tuple2 == null) break block11;
                    RangeSampler inFlightRangeSampler = (RangeSampler)tuple2._1();
                    databaseTags = (DatabaseTags)tuple2._2();
                    if (inFlightRangeSampler == null) break block11;
                    rangeSampler = inFlightRangeSampler;
                    if (databaseTags != null) break block12;
                }
                throw new MatchError((Object)tuple2);
            }
            DatabaseTags databaseTags2 = databaseTags;
            Tuple2 tuple2 = new Tuple2((Object)rangeSampler, (Object)databaseTags2);
            RangeSampler inFlightRangeSampler = (RangeSampler)tuple2._1();
            DatabaseTags databaseTags3 = (DatabaseTags)tuple2._2();
            if (this.parseSqlOperationName()) {
                try {
                    Statement statement2 = CCJSqlParserUtil.parse(sql);
                    SqlVisitor statementVisitor = new SqlVisitor(statementType);
                    statement2.accept(statementVisitor);
                    string = statementVisitor.operation();
                }
                catch (Exception e) {
                    if (this.logger().isInfoEnabled()) {
                        this.logger().info(new StringBuilder(43).append("Could not parse sql to get operation name: ").append(sql).toString(), (Throwable)e);
                    }
                    string = statementType;
                }
            } else {
                string = statementType;
            }
            String spanName = string;
            SpanBuilder clientSpan = Kamon$.MODULE$.clientSpanBuilder(spanName, "jdbc");
            Object object = this.addStatementSQL() || statement instanceof PreparedStatement && this.addPreparedStatementSQL() ? clientSpan.tag("db.statement", sql) : BoxedUnit.UNIT;
            databaseTags3.spanTags().iterator().foreach((Function1 & Serializable)t -> clientSpan.tag(t.key(), (String)databaseTags3.spanTags().get(Lookups$.MODULE$.coerce(t.key()))));
            databaseTags3.metricTags().iterator().foreach((Function1 & Serializable)t -> clientSpan.tagMetrics(t.key(), (String)databaseTags3.metricTags().get(Lookups$.MODULE$.coerce(t.key()))));
            inFlightRangeSampler.increment();
            return new Some((Object)new StatementMonitor.Invocation(statement, clientSpan.start(startTimestamp), sql, startTimestamp, inFlightRangeSampler));
        }
        return None$.MODULE$;
    }

    private StatementMonitor$() {
    }
}

