/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.executor;

import com.typesafe.config.Config;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kamon.Kamon;
import kamon.instrumentation.executor.CaptureContextOnSubmitAdvices;
import kamon.instrumentation.executor.ContextAware;
import kanela.agent.api.instrumentation.InstrumentationBuilder;
import kanela.agent.bootstrap.context.ContextHandler;
import kanela.agent.bootstrap.context.ContextProvider;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaptureContextOnSubmitInstrumentation
extends InstrumentationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CaptureContextOnSubmitInstrumentation.class);
    private static volatile Settings settings = CaptureContextOnSubmitInstrumentation.readSettings(Kamon.config());

    public CaptureContextOnSubmitInstrumentation() {
        ContextHandler.setContextProvider((ContextProvider)new KamonContextProvider());
        Kamon.onReconfigure(config -> {
            settings = CaptureContextOnSubmitInstrumentation.readSettings(config);
        });
        this.onSubTypesOf(new String[]{"java.util.concurrent.Executor"}).advise(this.method("execute").and((ElementMatcher)this.withArgument(Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class);
        this.onSubTypesOf(new String[]{"java.util.concurrent.ExecutorService"}).advise(this.method("submit").and((ElementMatcher)this.withArgument(Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class).advise(this.method("submit").and((ElementMatcher)this.withArgument(Callable.class)), CaptureContextOnSubmitAdvices.CallableWrapperAdvisor.class).advise(this.anyMethods(new String[]{"invokeAny", "invokeAll"}).and((ElementMatcher)this.withArgument(Collection.class)), CaptureContextOnSubmitAdvices.CallableCollectionWrapperAdvisor.class);
        this.onSubTypesOf(new String[]{"java.util.concurrent.ScheduledExecutorService"}).advise(this.method("schedule").and((ElementMatcher)this.withArgument(0, Runnable.class)), CaptureContextOnSubmitAdvices.RunnableWrapperAdvisor.class).advise(this.method("schedule").and((ElementMatcher)this.withArgument(0, Callable.class)), CaptureContextOnSubmitAdvices.CallableWrapperAdvisor.class);
    }

    private static Settings readSettings(Config config) {
        Config config2 = config.getConfig("kanela.modules.executor-service-capture-on-submit");
        List list = config2.hasPath("context-aware-runnable-providers") ? config2.getStringList("context-aware-runnable-providers").stream().map(CaptureContextOnSubmitInstrumentation::loadRunnableProvider).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()) : Collections.emptyList();
        List list2 = config2.hasPath("context-aware-callable-providers") ? config2.getStringList("context-aware-callable-providers").stream().map(CaptureContextOnSubmitInstrumentation::loadCallableProvider).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()) : Collections.emptyList();
        return new Settings(list, list2);
    }

    private static Optional<ContextAware.ContextAwareRunnableProvider> loadRunnableProvider(String string) {
        Optional<ContextAware.ContextAwareRunnableProvider> optional;
        try {
            optional = Optional.of((ContextAware.ContextAwareRunnableProvider)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            LOG.warn(MessageFormat.format("Error trying to load ContextAwareRunnableProvider: {0}.", string), (Throwable)exception);
            optional = Optional.empty();
        }
        return optional;
    }

    private static Optional<ContextAware.ContextAwareCallableProvider> loadCallableProvider(String string) {
        Optional<ContextAware.ContextAwareCallableProvider> optional;
        try {
            optional = Optional.of((ContextAware.ContextAwareCallableProvider)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            LOG.warn(MessageFormat.format("Error trying to load ContextAwareCallableProvider: {0}.", string), (Throwable)exception);
            optional = Optional.empty();
        }
        return optional;
    }

    private static final class Settings {
        public final List<ContextAware.ContextAwareRunnableProvider> runnableAwareProviders;
        public final List<ContextAware.ContextAwareCallableProvider> callableAwareProviders;

        private Settings(List<ContextAware.ContextAwareRunnableProvider> list, List<ContextAware.ContextAwareCallableProvider> list2) {
            this.runnableAwareProviders = list;
            this.callableAwareProviders = list2;
        }
    }

    private static class KamonContextProvider
    implements ContextProvider {
        private KamonContextProvider() {
        }

        public Runnable wrapInContextAware(Runnable runnable) {
            return settings.runnableAwareProviders.stream().filter(contextAwareRunnableProvider -> contextAwareRunnableProvider.test(runnable)).findFirst().map(contextAwareRunnableProvider -> contextAwareRunnableProvider.provide(runnable)).orElse(new ContextAware.DefaultContextAwareRunnable(runnable));
        }

        public <A> Callable wrapInContextAware(Callable<A> callable) {
            return settings.callableAwareProviders.stream().filter(contextAwareCallableProvider -> contextAwareCallableProvider.test(callable)).findFirst().map(contextAwareCallableProvider -> contextAwareCallableProvider.provide(callable)).orElse(new ContextAware.DefaultContextAwareCallable<A>(callable));
        }
    }
}

