/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.pekko.instrumentations;

import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public class SchedulerRunnableAdvice {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void enter(@Advice.Argument(value=1, readOnly=false) Runnable runnable) {
        runnable = new ContextAwareRunnable(Kamon.currentContext(), runnable);
    }

    public static class ContextAwareRunnable
    implements Runnable {
        private final Context context;
        private final Runnable underlyingRunnable;

        public ContextAwareRunnable(Context context, Runnable runnable) {
            this.context = context;
            this.underlyingRunnable = runnable;
        }

        @Override
        public void run() {
            try (Storage.Scope scope = Kamon.storeContext((Context)this.context);){
                this.underlyingRunnable.run();
            }
        }
    }
}

