/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.executor;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import kamon.Kamon$;
import kamon.instrumentation.executor.ExecutorInstrumentation;
import kamon.instrumentation.executor.ExecutorInstrumentation$ForkJoinPoolTelemetryReader$;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

public final class ExecutorInstrumentation$ {
    public static final ExecutorInstrumentation$ MODULE$;
    private static final Logger _logger;
    private static volatile Duration kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval;
    private static final ExecutorInstrumentation.Settings DefaultSettings;
    private static final ExecutorInstrumentation.Settings NoExtraSettings;
    private static final Field _executionContextExecutorField;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new ExecutorInstrumentation$();
        _logger = LoggerFactory.getLogger((String)"kamon.instrumentation.executors.ExecutorsInstrumentation");
        kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval = MODULE$.readSampleInterval(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable)newConfig -> {
            ExecutorInstrumentation$.MODULE$._sampleInterval_$eq(ExecutorInstrumentation$.MODULE$.readSampleInterval(newConfig));
            return BoxedUnit.UNIT;
        });
        DefaultSettings = new ExecutorInstrumentation.Settings(true, false);
        NoExtraSettings = new ExecutorInstrumentation.Settings(false, false);
        Field field = Class.forName("scala.concurrent.impl.ExecutionContextImpl").getDeclaredField("executor");
        field.setAccessible(true);
        _executionContextExecutorField = var0;
    }

    private Logger _logger() {
        return _logger;
    }

    public Duration kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval() {
        return kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval;
    }

    private void _sampleInterval_$eq(Duration x$1) {
        kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval = x$1;
    }

    public ExecutorService instrument(ExecutorService executor, String name) {
        return this.instrument(executor, name, TagSet$.MODULE$.Empty(), this.DefaultSettings());
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name) {
        return this.instrumentExecutionContext(executionContext, name, TagSet$.MODULE$.Empty(), name, this.DefaultSettings());
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name) {
        return this.instrumentScheduledExecutor(executor, name, TagSet$.MODULE$.Empty(), name);
    }

    public ExecutorService instrument(ExecutorService executor, String name, ExecutorInstrumentation.Settings settings) {
        return this.instrument(executor, name, TagSet$.MODULE$.Empty(), settings);
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name, ExecutorInstrumentation.Settings settings) {
        return this.instrumentExecutionContext(executionContext, name, TagSet$.MODULE$.Empty(), name, settings);
    }

    public ExecutorService instrument(ExecutorService executor, String name, TagSet extraTags) {
        return this.instrument(executor, name, extraTags, this.DefaultSettings());
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name, TagSet extraTags) {
        return this.instrumentExecutionContext(executionContext, name, extraTags, name, this.DefaultSettings());
    }

    public ExecutorService instrument(ExecutorService executor, String name, TagSet extraTags, ExecutorInstrumentation.Settings settings) {
        return this.instrument(executor, name, extraTags, name, settings);
    }

    public ExecutorService instrument(ExecutorService executor, String name, TagSet extraTags, String scheduledActionName, ExecutorInstrumentation.Settings settings) {
        boolean bl = false;
        ForkJoinPool forkJoinPool = null;
        ExecutorService executorService = executor;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return new ExecutorInstrumentation.InstrumentedThreadPool(threadPoolExecutor, name, extraTags, scheduledActionName, settings);
        }
        if (executorService instanceof ForkJoinPool) {
            bl = true;
            forkJoinPool = (ForkJoinPool)executorService;
            return new ExecutorInstrumentation.InstrumentedForkJoinPool(forkJoinPool, ExecutorInstrumentation$ForkJoinPoolTelemetryReader$.MODULE$.forJava(forkJoinPool), name, extraTags, scheduledActionName, settings);
        }
        if (bl) {
            return new ExecutorInstrumentation.InstrumentedForkJoinPool(forkJoinPool, ExecutorInstrumentation$ForkJoinPoolTelemetryReader$.MODULE$.forScala(forkJoinPool), name, extraTags, scheduledActionName, settings);
        }
        this._logger().warn("Cannot instrument unknown executor [{}]", (Object)executorService);
        return executor;
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name, TagSet extraTags) {
        return this.instrumentScheduledExecutor(executor, name, extraTags, name);
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name, TagSet extraTags, String scheduledActionName) {
        ScheduledExecutorService scheduledExecutorService = executor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            return new ExecutorInstrumentation.InstrumentedScheduledThreadPoolExecutor(scheduledThreadPoolExecutor, name, extraTags.withTag("scheduled", Predef$.MODULE$.boolean2Boolean(true)), scheduledActionName);
        }
        this._logger().warn("Cannot instrument unknown executor [{}]", (Object)scheduledExecutorService);
        return executor;
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name, TagSet extraTags, String scheduledActionName, ExecutorInstrumentation.Settings settings) {
        Option underlyingExecutor = this.unwrapExecutionContext(executionContext).map((Function1 & Serializable)executor -> MODULE$.instrument((ExecutorService)executor, name, extraTags, scheduledActionName, settings));
        return new ExecutorInstrumentation.InstrumentedExecutionContext(executionContext, (Option<ExecutorService>)underlyingExecutor);
    }

    public ExecutorService instrument(ExecutorService executor, ExecutorInstrumentation.ForkJoinPoolTelemetryReader telemetryReader, String name, TagSet extraTags, String scheduledActionName, ExecutorInstrumentation.Settings settings) {
        return new ExecutorInstrumentation.InstrumentedForkJoinPool(executor, telemetryReader, name, extraTags, scheduledActionName, settings);
    }

    public ExecutorInstrumentation.Settings DefaultSettings() {
        return DefaultSettings;
    }

    public ExecutorInstrumentation.Settings NoExtraSettings() {
        return NoExtraSettings;
    }

    private Field _executionContextExecutorField() {
        return _executionContextExecutorField;
    }

    private Option<ExecutorService> unwrapExecutionContext(ExecutionContext executionContext) {
        Some some;
        try {
            some = new Some((Object)((ExecutorService)this._executionContextExecutorField().get(executionContext)));
        }
        catch (Throwable throwable) {
            this._logger().warn("Cannot unwrap unsupported ExecutionContext [{}]", (Object)executionContext);
            some = None$.MODULE$;
        }
        return some;
    }

    private Duration readSampleInterval(Config config) {
        return (Duration)Try$.MODULE$.apply((Function0 & Serializable)() -> Kamon$.MODULE$.config().getDuration("kamon.instrumentation.executor.sample-interval")).getOrElse((Function0 & Serializable)() -> Duration.ofSeconds(10L));
    }

    private ExecutorInstrumentation$() {
    }
}

