/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.apache.httpclient;

import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.apache.httpclient.ApacheHttpClientHelper;
import kamon.instrumentation.apache.httpclient.ApacheHttpClientInstrumentation;
import kamon.instrumentation.context.HasContext;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.http.HttpMessage;
import kamon.trace.Span;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class RequestAdvisor {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnter(@Advice.Argument(value=0) HttpHost httpHost, @Advice.Argument(value=1, readOnly=false) HttpRequest httpRequest, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        if (((HasContext)httpRequest).context().nonEmpty()) {
            return;
        }
        Context context = Kamon.currentContext();
        HttpMessage.RequestBuilder<HttpRequest> requestBuilder = ApacheHttpClientHelper.toRequestBuilder(httpHost, httpRequest);
        requestHandler = ApacheHttpClientInstrumentation.httpClientInstrumentation().createHandler(requestBuilder, context);
        Context context2 = context.withEntry(Span.Key(), (Object)requestHandler.span());
        scope = Kamon.storeContext((Context)context2);
        httpRequest = requestHandler.request();
        ((HasContext)httpRequest).setContext(context2);
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void onExit(@Advice.Return HttpResponse httpResponse, @Advice.Thrown Throwable throwable, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        if (scope == null) {
            return;
        }
        ApacheHttpClientInstrumentation.processResponse(requestHandler, httpResponse, throwable);
        scope.close();
    }
}

