/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.executor;

import java.util.concurrent.Callable;
import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;

public final class ContextAware {
    private ContextAware() {
    }

    public static interface ContextAwareCallableProvider {
        public <A> ContextAwareCallable<A> provide(Callable<A> var1);

        public boolean test(Callable<?> var1);
    }

    public static interface ContextAwareRunnableProvider {
        public ContextAwareRunnable provide(Runnable var1);

        public boolean test(Runnable var1);
    }

    public static final class DefaultContextAwareCallable<A>
    implements ContextAwareCallable<A> {
        private final Callable<A> underlying;
        private final Context context = Kamon.currentContext();

        public DefaultContextAwareCallable(Callable<A> callable) {
            this.underlying = callable;
        }

        @Override
        public Callable<A> getUnderlying() {
            return this.underlying;
        }

        @Override
        public Context getContext() {
            return this.context;
        }
    }

    public static final class DefaultContextAwareRunnable
    implements ContextAwareRunnable {
        private final Runnable underlying;
        private final Context context = Kamon.currentContext();

        public DefaultContextAwareRunnable(Runnable runnable) {
            this.underlying = runnable;
        }

        @Override
        public Runnable getUnderlying() {
            return this.underlying;
        }

        @Override
        public Context getContext() {
            return this.context;
        }
    }

    public static interface ContextAwareCallable<A>
    extends Callable<A> {
        public Callable<A> getUnderlying();

        public Context getContext();

        @Override
        default public A call() throws Exception {
            try (Storage.Scope scope = Kamon.storeContext((Context)this.getContext());){
                A a = this.getUnderlying().call();
                return a;
            }
        }
    }

    public static interface ContextAwareRunnable
    extends Runnable {
        public Runnable getUnderlying();

        public Context getContext();

        @Override
        default public void run() {
            try (Storage.Scope scope = Kamon.storeContext((Context)this.getContext());){
                this.getUnderlying().run();
            }
        }
    }
}

