/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.grpc;

import akka.http.javadsl.model.HttpEntity;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kamon.Kamon;
import kamon.context.Context;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public class AkkaGRPCUnmarshallingContextPropagation {
    @Advice.OnMethodExit
    public static void onExit(@Advice.Return(readOnly=false) CompletionStage<?> completionStage, @Advice.Argument(value=0) Object object) {
        if (object instanceof HttpEntity && completionStage instanceof CompletableFuture) {
            Context context = Kamon.currentContext();
            completionStage = new ContextPropagatingCompletionStage((CompletableFuture)completionStage, context);
        }
    }

    public static class ContextPropagatingCompletionStage<T>
    extends CompletableFuture<T> {
        private final CompletableFuture<T> wrapped;
        private final Context context;

        public ContextPropagatingCompletionStage(CompletableFuture<T> completableFuture, Context context) {
            this.wrapped = completableFuture;
            this.context = context;
        }

        @Override
        public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> function) {
            Function<Object, CompletionStage> function2 = object -> (CompletionStage)Kamon.runWithContext((Context)this.context, () -> (CompletionStage)function.apply(object));
            return this.wrapped.thenCompose(function2);
        }
    }
}

