/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Objects;
import jnr.ffi.Pointer;
import jnr.ffi.provider.MemoryManager;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.Library;

final class KeyVal<T>
implements AutoCloseable {
    private static final MemoryManager MEM_MGR = Library.RUNTIME.getMemoryManager();
    private boolean closed;
    private T k;
    private final BufferProxy<T> proxy;
    private final Pointer ptrArray;
    private final Pointer ptrKey;
    private final long ptrKeyAddr;
    private final Pointer ptrVal;
    private final long ptrValAddr;
    private T v;

    KeyVal(BufferProxy<T> proxy) {
        Objects.requireNonNull(proxy);
        this.proxy = proxy;
        this.k = proxy.allocate();
        this.v = proxy.allocate();
        this.ptrKey = MEM_MGR.allocateTemporary(16, false);
        this.ptrKeyAddr = this.ptrKey.address();
        this.ptrArray = MEM_MGR.allocateTemporary(32, false);
        this.ptrVal = this.ptrArray.slice(0L, 16L);
        this.ptrValAddr = this.ptrVal.address();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.proxy.deallocate(this.k);
        this.proxy.deallocate(this.v);
    }

    T key() {
        return this.k;
    }

    void keyIn(T key) {
        this.proxy.in(key, this.ptrKey, this.ptrKeyAddr);
    }

    T keyOut() {
        this.k = this.proxy.out(this.k, this.ptrKey, this.ptrKeyAddr);
        return this.k;
    }

    Pointer pointerKey() {
        return this.ptrKey;
    }

    Pointer pointerVal() {
        return this.ptrVal;
    }

    T val() {
        return this.v;
    }

    void valIn(T val) {
        this.proxy.in(val, this.ptrVal, this.ptrValAddr);
    }

    void valIn(int size) {
        this.proxy.in(this.v, size, this.ptrVal, this.ptrValAddr);
    }

    Pointer valInMulti(T val, int elements) {
        long ptrVal2SizeOff = 16L;
        this.ptrArray.putLong(16L, elements);
        this.proxy.in(val, this.ptrVal, this.ptrValAddr);
        long totalBufferSize = this.ptrVal.getLong(0L);
        long elemSize = totalBufferSize / (long)elements;
        this.ptrVal.putLong(0L, elemSize);
        return this.ptrArray;
    }

    T valOut() {
        this.v = this.proxy.out(this.v, this.ptrVal, this.ptrValAddr);
        return this.v;
    }
}

