/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Comparator;
import java.util.Objects;

public enum KeyRangeType {
    FORWARD_ALL(true, false, false),
    FORWARD_AT_LEAST(true, true, false),
    FORWARD_AT_MOST(true, false, true),
    FORWARD_CLOSED(true, true, true),
    FORWARD_CLOSED_OPEN(true, true, true),
    FORWARD_GREATER_THAN(true, true, false),
    FORWARD_LESS_THAN(true, false, true),
    FORWARD_OPEN(true, true, true),
    FORWARD_OPEN_CLOSED(true, true, true),
    BACKWARD_ALL(false, false, false),
    BACKWARD_AT_LEAST(false, true, false),
    BACKWARD_AT_MOST(false, false, true),
    BACKWARD_CLOSED(false, true, true),
    BACKWARD_CLOSED_OPEN(false, true, true),
    BACKWARD_GREATER_THAN(false, true, false),
    BACKWARD_LESS_THAN(false, false, true),
    BACKWARD_OPEN(false, true, true),
    BACKWARD_OPEN_CLOSED(false, true, true);

    private final boolean directionForward;
    private final boolean startKeyRequired;
    private final boolean stopKeyRequired;

    private KeyRangeType(boolean directionForward, boolean startKeyRequired, boolean stopKeyRequired) {
        this.directionForward = directionForward;
        this.startKeyRequired = startKeyRequired;
        this.stopKeyRequired = stopKeyRequired;
    }

    public boolean isDirectionForward() {
        return this.directionForward;
    }

    public boolean isStartKeyRequired() {
        return this.startKeyRequired;
    }

    public boolean isStopKeyRequired() {
        return this.stopKeyRequired;
    }

    CursorOp initialOp() {
        switch (this) {
            case FORWARD_ALL: {
                return CursorOp.FIRST;
            }
            case FORWARD_AT_LEAST: {
                return CursorOp.GET_START_KEY;
            }
            case FORWARD_AT_MOST: {
                return CursorOp.FIRST;
            }
            case FORWARD_CLOSED: {
                return CursorOp.GET_START_KEY;
            }
            case FORWARD_CLOSED_OPEN: {
                return CursorOp.GET_START_KEY;
            }
            case FORWARD_GREATER_THAN: {
                return CursorOp.GET_START_KEY;
            }
            case FORWARD_LESS_THAN: {
                return CursorOp.FIRST;
            }
            case FORWARD_OPEN: {
                return CursorOp.GET_START_KEY;
            }
            case FORWARD_OPEN_CLOSED: {
                return CursorOp.GET_START_KEY;
            }
            case BACKWARD_ALL: {
                return CursorOp.LAST;
            }
            case BACKWARD_AT_LEAST: {
                return CursorOp.GET_START_KEY_BACKWARD;
            }
            case BACKWARD_AT_MOST: {
                return CursorOp.LAST;
            }
            case BACKWARD_CLOSED: {
                return CursorOp.GET_START_KEY_BACKWARD;
            }
            case BACKWARD_CLOSED_OPEN: {
                return CursorOp.GET_START_KEY_BACKWARD;
            }
            case BACKWARD_GREATER_THAN: {
                return CursorOp.GET_START_KEY_BACKWARD;
            }
            case BACKWARD_LESS_THAN: {
                return CursorOp.LAST;
            }
            case BACKWARD_OPEN: {
                return CursorOp.GET_START_KEY_BACKWARD;
            }
            case BACKWARD_OPEN_CLOSED: {
                return CursorOp.GET_START_KEY_BACKWARD;
            }
        }
        throw new IllegalStateException("Invalid type");
    }

    <T, C extends Comparator<T>> IteratorOp iteratorOp(T start2, T stop, T buffer, C c) {
        Objects.requireNonNull(c, "Comparator required");
        if (buffer == null) {
            return IteratorOp.TERMINATE;
        }
        switch (this) {
            case FORWARD_ALL: {
                return IteratorOp.RELEASE;
            }
            case FORWARD_AT_LEAST: {
                return IteratorOp.RELEASE;
            }
            case FORWARD_AT_MOST: {
                return c.compare(buffer, stop) > 0 ? IteratorOp.TERMINATE : IteratorOp.RELEASE;
            }
            case FORWARD_CLOSED: {
                return c.compare(buffer, stop) > 0 ? IteratorOp.TERMINATE : IteratorOp.RELEASE;
            }
            case FORWARD_CLOSED_OPEN: {
                return c.compare(buffer, stop) >= 0 ? IteratorOp.TERMINATE : IteratorOp.RELEASE;
            }
            case FORWARD_GREATER_THAN: {
                return c.compare(buffer, start2) == 0 ? IteratorOp.CALL_NEXT_OP : IteratorOp.RELEASE;
            }
            case FORWARD_LESS_THAN: {
                return c.compare(buffer, stop) >= 0 ? IteratorOp.TERMINATE : IteratorOp.RELEASE;
            }
            case FORWARD_OPEN: {
                if (c.compare(buffer, start2) == 0) {
                    return IteratorOp.CALL_NEXT_OP;
                }
                return c.compare(buffer, stop) >= 0 ? IteratorOp.TERMINATE : IteratorOp.RELEASE;
            }
            case FORWARD_OPEN_CLOSED: {
                if (c.compare(buffer, start2) == 0) {
                    return IteratorOp.CALL_NEXT_OP;
                }
                return c.compare(buffer, stop) > 0 ? IteratorOp.TERMINATE : IteratorOp.RELEASE;
            }
            case BACKWARD_ALL: {
                return IteratorOp.RELEASE;
            }
            case BACKWARD_AT_LEAST: {
                return c.compare(buffer, start2) > 0 ? IteratorOp.CALL_NEXT_OP : IteratorOp.RELEASE;
            }
            case BACKWARD_AT_MOST: {
                return c.compare(buffer, stop) >= 0 ? IteratorOp.RELEASE : IteratorOp.TERMINATE;
            }
            case BACKWARD_CLOSED: {
                if (c.compare(buffer, start2) > 0) {
                    return IteratorOp.CALL_NEXT_OP;
                }
                return c.compare(buffer, stop) >= 0 ? IteratorOp.RELEASE : IteratorOp.TERMINATE;
            }
            case BACKWARD_CLOSED_OPEN: {
                if (c.compare(buffer, start2) > 0) {
                    return IteratorOp.CALL_NEXT_OP;
                }
                return c.compare(buffer, stop) > 0 ? IteratorOp.RELEASE : IteratorOp.TERMINATE;
            }
            case BACKWARD_GREATER_THAN: {
                return c.compare(buffer, start2) >= 0 ? IteratorOp.CALL_NEXT_OP : IteratorOp.RELEASE;
            }
            case BACKWARD_LESS_THAN: {
                return c.compare(buffer, stop) > 0 ? IteratorOp.RELEASE : IteratorOp.TERMINATE;
            }
            case BACKWARD_OPEN: {
                if (c.compare(buffer, start2) >= 0) {
                    return IteratorOp.CALL_NEXT_OP;
                }
                return c.compare(buffer, stop) > 0 ? IteratorOp.RELEASE : IteratorOp.TERMINATE;
            }
            case BACKWARD_OPEN_CLOSED: {
                if (c.compare(buffer, start2) >= 0) {
                    return IteratorOp.CALL_NEXT_OP;
                }
                return c.compare(buffer, stop) >= 0 ? IteratorOp.RELEASE : IteratorOp.TERMINATE;
            }
        }
        throw new IllegalStateException("Invalid type");
    }

    CursorOp nextOp() {
        return this.isDirectionForward() ? CursorOp.NEXT : CursorOp.PREV;
    }

    static enum CursorOp {
        FIRST,
        LAST,
        GET_START_KEY,
        GET_START_KEY_BACKWARD,
        NEXT,
        PREV;

    }

    static enum IteratorOp {
        TERMINATE,
        CALL_NEXT_OP,
        RELEASE;

    }
}

