/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Objects;
import org.lmdbjava.KeyRangeType;

public final class KeyRange<T> {
    private static final KeyRange<?> BK = new KeyRange<Object>(KeyRangeType.BACKWARD_ALL, null, null);
    private static final KeyRange<?> FW = new KeyRange<Object>(KeyRangeType.FORWARD_ALL, null, null);
    private final T start;
    private final T stop;
    private final KeyRangeType type;

    public KeyRange(KeyRangeType type, T start2, T stop) {
        Objects.requireNonNull(type, "Key range type is required");
        if (type.isStartKeyRequired()) {
            Objects.requireNonNull(start2, "Start key is required for this key range type");
        }
        if (type.isStopKeyRequired()) {
            Objects.requireNonNull(stop, "Stop key is required for this key range type");
        }
        this.start = start2;
        this.stop = stop;
        this.type = type;
    }

    public static <T> KeyRange<T> all() {
        return FW;
    }

    public static <T> KeyRange<T> allBackward() {
        return BK;
    }

    public static <T> KeyRange<T> atLeast(T start2) {
        return new KeyRange<Object>(KeyRangeType.FORWARD_AT_LEAST, start2, null);
    }

    public static <T> KeyRange<T> atLeastBackward(T start2) {
        return new KeyRange<Object>(KeyRangeType.BACKWARD_AT_LEAST, start2, null);
    }

    public static <T> KeyRange<T> atMost(T stop) {
        return new KeyRange<Object>(KeyRangeType.FORWARD_AT_MOST, null, stop);
    }

    public static <T> KeyRange<T> atMostBackward(T stop) {
        return new KeyRange<Object>(KeyRangeType.BACKWARD_AT_MOST, null, stop);
    }

    public static <T> KeyRange<T> closed(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.FORWARD_CLOSED, start2, stop);
    }

    public static <T> KeyRange<T> closedBackward(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.BACKWARD_CLOSED, start2, stop);
    }

    public static <T> KeyRange<T> closedOpen(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.FORWARD_CLOSED_OPEN, start2, stop);
    }

    public static <T> KeyRange<T> closedOpenBackward(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.BACKWARD_CLOSED_OPEN, start2, stop);
    }

    public static <T> KeyRange<T> greaterThan(T start2) {
        return new KeyRange<Object>(KeyRangeType.FORWARD_GREATER_THAN, start2, null);
    }

    public static <T> KeyRange<T> greaterThanBackward(T start2) {
        return new KeyRange<Object>(KeyRangeType.BACKWARD_GREATER_THAN, start2, null);
    }

    public static <T> KeyRange<T> lessThan(T stop) {
        return new KeyRange<Object>(KeyRangeType.FORWARD_LESS_THAN, null, stop);
    }

    public static <T> KeyRange<T> lessThanBackward(T stop) {
        return new KeyRange<Object>(KeyRangeType.BACKWARD_LESS_THAN, null, stop);
    }

    public static <T> KeyRange<T> open(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.FORWARD_OPEN, start2, stop);
    }

    public static <T> KeyRange<T> openBackward(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.BACKWARD_OPEN, start2, stop);
    }

    public static <T> KeyRange<T> openClosed(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.FORWARD_OPEN_CLOSED, start2, stop);
    }

    public static <T> KeyRange<T> openClosedBackward(T start2, T stop) {
        return new KeyRange<T>(KeyRangeType.BACKWARD_OPEN_CLOSED, start2, stop);
    }

    public T getStart() {
        return this.start;
    }

    public T getStop() {
        return this.stop;
    }

    public KeyRangeType getType() {
        return this.type;
    }
}

