/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import jnr.ffi.Pointer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.UnsafeBuffer;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.UnsafeAccess;

public final class DirectBufferProxy
extends BufferProxy<DirectBuffer> {
    public static final BufferProxy<DirectBuffer> PROXY_DB = new DirectBufferProxy();
    private static final ThreadLocal<OneToOneConcurrentArrayQueue<DirectBuffer>> BUFFERS = ThreadLocal.withInitial(() -> new OneToOneConcurrentArrayQueue(16));

    public static int compareBuff(DirectBuffer o1, DirectBuffer o2) {
        int i;
        Objects.requireNonNull(o1);
        Objects.requireNonNull(o2);
        if (o1.equals(o2)) {
            return 0;
        }
        int minLength = Math.min(o1.capacity(), o2.capacity());
        int minWords = minLength / 8;
        for (i = 0; i < minWords * 8; i += 8) {
            long rw;
            long lw = o1.getLong(i, ByteOrder.BIG_ENDIAN);
            int diff = Long.compareUnsigned(lw, rw = o2.getLong(i, ByteOrder.BIG_ENDIAN));
            if (diff == 0) continue;
            return diff;
        }
        for (i = minWords * 8; i < minLength; ++i) {
            int rw;
            int lw = Byte.toUnsignedInt(o1.getByte(i));
            int result = Integer.compareUnsigned(lw, rw = Byte.toUnsignedInt(o2.getByte(i)));
            if (result == 0) continue;
            return result;
        }
        return o1.capacity() - o2.capacity();
    }

    @Override
    protected DirectBuffer allocate() {
        OneToOneConcurrentArrayQueue<DirectBuffer> q = BUFFERS.get();
        DirectBuffer buffer = q.poll();
        if (buffer != null && buffer.capacity() >= 0) {
            return buffer;
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(0);
        return new UnsafeBuffer(bb);
    }

    @Override
    protected int compare(DirectBuffer o1, DirectBuffer o2) {
        return DirectBufferProxy.compareBuff(o1, o2);
    }

    @Override
    protected void deallocate(DirectBuffer buff) {
        OneToOneConcurrentArrayQueue<DirectBuffer> q = BUFFERS.get();
        q.offer(buff);
    }

    @Override
    protected byte[] getBytes(DirectBuffer buffer) {
        byte[] dest = new byte[buffer.capacity()];
        buffer.getBytes(0, dest, 0, buffer.capacity());
        return dest;
    }

    @Override
    protected void in(DirectBuffer buffer, Pointer ptr, long ptrAddr) {
        long addr = buffer.addressOffset();
        long size = buffer.capacity();
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, addr);
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, size);
    }

    @Override
    protected void in(DirectBuffer buffer, int size, Pointer ptr, long ptrAddr) {
        long addr = buffer.addressOffset();
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, addr);
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, size);
    }

    @Override
    protected DirectBuffer out(DirectBuffer buffer, Pointer ptr, long ptrAddr) {
        long addr = UnsafeAccess.UNSAFE.getLong(ptrAddr + 8L);
        long size = UnsafeAccess.UNSAFE.getLong(ptrAddr + 0L);
        buffer.wrap(addr, (int)size);
        return buffer;
    }
}

