/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.DoubleLinkedList;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.apache.pekko.util.RecencyList;
import org.apache.pekko.util.SegmentedRecencyList$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dvAB%K\u0011\u0003a%K\u0002\u0004U\u0015\"\u0005A*\u0016\u0005\u00069\u0006!\tA\u0018\u0005\u0006?\u0006!\t\u0001Y\u0004\b\u0005\u001b\u000b\u0001\u0012\u0001BH\r\u001d\u0011\t*\u0001E\u0001\u0005'Ca\u0001X\u0003\u0005\u0002\tU\u0005BB0\u0006\t\u0003\u00119J\u0002\u0004\u0002Z\u00051\u00111\f\u0005\u000b\u0003?B!Q1A\u0005\u0002\u0005\u0005\u0004BCA4\u0011\t\u0005\t\u0015!\u0003\u0002d!1A\f\u0003C\u0001\u0003SB\u0011\"!\u001d\t\u0001\u0004%\t!a\r\t\u0013\u0005M\u0004\u00021A\u0005\u0002\u0005U\u0004bBA=\u0011\u0001\u0006KA\u001c\u0005\n\u0003wB\u0001\u0019!C\u0001\u0003{B\u0011\"!\"\t\u0001\u0004%\t!a\"\t\u0011\u0005-\u0005\u0002)Q\u0005\u0003\u007fB\u0011\"!$\t\u0001\u0004%\t!a$\t\u0013\u0005M\u0005\u00021A\u0005\u0002\u0005U\u0005\u0002CAM\u0011\u0001\u0006K!!%\t\u0013\u0005m\u0005\u00021A\u0005\u0002\u0005=\u0005\"CAO\u0011\u0001\u0007I\u0011AAP\u0011!\t\u0019\u000b\u0003Q!\n\u0005E\u0005\"CAS\u0011\u0001\u0007I\u0011AAH\u0011%\t9\u000b\u0003a\u0001\n\u0003\tI\u000b\u0003\u0005\u0002.\"\u0001\u000b\u0015BAI\u0011%\ty\u000b\u0003a\u0001\n\u0003\ty\tC\u0005\u00022\"\u0001\r\u0011\"\u0001\u00024\"A\u0011q\u0017\u0005!B\u0013\t\tJB\u0003U\u0015\na5\r\u0003\u0005f=\t\u0005\t\u0015!\u0003g\u0011!\thD!A!\u0002\u0013\u0011\b\"\u0002/\u001f\t\u0003a\b\"CA\f=\u0001\u0007I\u0011BA\r\u0011%\t\tC\ba\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u00020y\u0001\u000b\u0015BA\u000e\u0011%\t\tD\ba\u0001\n\u0013\t\u0019\u0004C\u0005\u00026y\u0001\r\u0011\"\u0003\u00028!9\u00111\b\u0010!B\u0013q\u0007\"CA\u001f=\t\u0007I\u0011BA\u001a\u0011\u001d\tyD\bQ\u0001\n9D\u0011\"!\u0011\u001f\u0005\u0004%I!a\r\t\u000f\u0005\rc\u0004)A\u0005]\"I\u0011Q\t\u0010C\u0002\u0013%\u00111\u0007\u0005\b\u0003\u000fr\u0002\u0015!\u0003o\u0011%\tIE\bb\u0001\n\u0013\tY\u0005\u0003\u0005\u0002:z\u0001\u000b\u0011BA'\u0011%\tYL\bb\u0001\n\u0013\ti\f\u0003\u0005\u0002Jz\u0001\u000b\u0011BA`\u0011%\tYM\bb\u0001\n\u0013\ti\r\u0003\u0005\u0002Pz\u0001\u000b\u0011BA(\u0011%\t\tN\bb\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0002\\z\u0001\u000b\u0011BAk\u0011\u001d\tiN\bC\u0001\u0003gAq!a8\u001f\t\u0003\t\t\u000fC\u0004\u0002fz!\t!a:\t\u000f\u0005-h\u0004\"\u0001\u0002n\"9\u0011\u0011\u001f\u0010\u0005\u0002\u0005M\bbBA\u007f=\u0011\u0005\u0011q \u0005\b\u0005\u0007qB\u0011\u0001B\u0003\u0011\u001d\u0011\tC\bC\u0001\u0005GAqAa\n\u001f\t\u0003\u0011\u0019\u0003C\u0004\u0003*y!\tAa\u000b\t\u000f\t}b\u0004\"\u0001\u0003B!9!q\t\u0010\u0005\n\t%\u0003b\u0002B&=\u0011%!Q\n\u0005\b\u0005#rB\u0011\u0002B*\u0011\u001d\u0011IF\bC\u0005\u00057BqAa\u0018\u001f\t\u0013\u0011\t\u0007C\u0004\u0003fy!IAa\u001a\t\u000f\t5d\u0004\"\u0003\u0003p!9!1\u000f\u0010\u0005\n\tU\u0014\u0001F*fO6,g\u000e^3e%\u0016\u001cWM\\2z\u0019&\u001cHO\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\tie*A\u0003qK.\\wN\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0007CA*\u0002\u001b\u0005Q%\u0001F*fO6,g\u000e^3e%\u0016\u001cWM\\2z\u0019&\u001cHo\u0005\u0002\u0002-B\u0011qKW\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002%\u0006)Q-\u001c9usV\u0019\u0011M!#\u0015\u0007\t\u0014Y\t\u0005\u0003T=\t\u001dUc\u00013\u0002\u0002M\u0011aDV\u0001\u000eS:LG/[1m\u0019&l\u0017\u000e^:\u0011\u0007\u001ddg.D\u0001i\u0015\tI'.A\u0005j[6,H/\u00192mK*\u00111\u000eW\u0001\u000bG>dG.Z2uS>t\u0017BA7i\u0005\r\u0019V-\u001d\t\u0003/>L!\u0001\u001d-\u0003\u0007%sG/A\u0003dY>\u001c7\u000eE\u0002TgVL!\u0001\u001e&\u0003\u0013=\u0003H/[8o-\u0006d\u0007C\u0001<z\u001d\t\u0019v/\u0003\u0002y\u0015\u0006Y!+Z2f]\u000eLH*[:u\u0013\tQ8PA\u0003DY>\u001c7N\u0003\u0002y\u0015R)Q0a\u0005\u0002\u0016A\u00191K\b@\u0011\u0007}\f\t\u0001\u0004\u0001\u0005\u000f\u0005\raD1\u0001\u0002\u0006\t\t\u0011)\u0005\u0003\u0002\b\u00055\u0001cA,\u0002\n%\u0019\u00111\u0002-\u0003\u000f9{G\u000f[5oOB\u0019q+a\u0004\n\u0007\u0005E\u0001LA\u0002B]fDQ!Z\u0011A\u0002\u0019DQ!]\u0011A\u0002I\fa\u0001\\5nSR\u001cXCAA\u000e!\u00119\u0017Q\u00048\n\u0007\u0005}\u0001N\u0001\u0006J]\u0012,\u00070\u001a3TKF\f!\u0002\\5nSR\u001cx\fJ3r)\u0011\t)#a\u000b\u0011\u0007]\u000b9#C\u0002\u0002*a\u0013A!\u00168ji\"I\u0011QF\u0012\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014a\u00027j[&$8\u000fI\u0001\u000bi>$\u0018\r\u001c'j[&$X#\u00018\u0002\u001dQ|G/\u00197MS6LGo\u0018\u0013fcR!\u0011QEA\u001d\u0011!\tiCJA\u0001\u0002\u0004q\u0017a\u0003;pi\u0006dG*[7ji\u0002\na\u0001\\3wK2\u001c\u0018a\u00027fm\u0016d7\u000fI\u0001\u0007Y><Xm\u001d;\u0002\u000f1|w/Z:uA\u00059\u0001.[4iKN$\u0018\u0001\u00035jO\",7\u000f\u001e\u0011\u0002\u0011M,w-\\3oiN,\"!!\u0014\u0011\u000b\u001d\fi\"a\u0014\u0011\u000bM\u000b\t&!\u0016\n\u0007\u0005M#J\u0001\tE_V\u0014G.\u001a'j].,G\rT5tiB!\u0011q\u000b\u0005\u007f\u001d\t\u0019\u0006A\u0001\u0003O_\u0012,W\u0003BA/\u0003K\u001a\"\u0001\u0003,\u0002\u000bY\fG.^3\u0016\u0005\u0005\r\u0004cA@\u0002f\u00119\u00111\u0001\u0005C\u0002\u0005\u0015\u0011A\u0002<bYV,\u0007\u0005\u0006\u0003\u0002l\u0005=\u0004#BA7\u0011\u0005\rT\"A\u0001\t\u000f\u0005}3\u00021\u0001\u0002d\u0005)A.\u001a<fY\u0006IA.\u001a<fY~#S-\u001d\u000b\u0005\u0003K\t9\b\u0003\u0005\u0002.5\t\t\u00111\u0001o\u0003\u0019aWM^3mA\u0005IA/[7fgR\fW\u000e]\u000b\u0003\u0003\u007f\u00022aVAA\u0013\r\t\u0019\t\u0017\u0002\u0005\u0019>tw-A\u0007uS6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003K\tI\tC\u0005\u0002.A\t\t\u00111\u0001\u0002\u0000\u0005QA/[7fgR\fW\u000e\u001d\u0011\u0002\u00151,7o\u001d*fG\u0016tG/\u0006\u0002\u0002\u0012B!1k]A6\u00039aWm]:SK\u000e,g\u000e^0%KF$B!!\n\u0002\u0018\"I\u0011QF\n\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\fY\u0016\u001c8OU3dK:$\b%\u0001\u0006n_J,'+Z2f]R\fa\"\\8sKJ+7-\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005\u0005\u0006\"CA\u0017-\u0005\u0005\t\u0019AAI\u0003-iwN]3SK\u000e,g\u000e\u001e\u0011\u0002#=4XM]1mY2+7o\u001d*fG\u0016tG/A\u000bpm\u0016\u0014\u0018\r\u001c7MKN\u001c(+Z2f]R|F%Z9\u0015\t\u0005\u0015\u00121\u0016\u0005\n\u0003[I\u0012\u0011!a\u0001\u0003#\u000b!c\u001c<fe\u0006dG\u000eT3tgJ+7-\u001a8uA\u0005\trN^3sC2dWj\u001c:f%\u0016\u001cWM\u001c;\u0002+=4XM]1mY6{'/\u001a*fG\u0016tGo\u0018\u0013fcR!\u0011QEA[\u0011%\ti\u0003HA\u0001\u0002\u0004\t\t*\u0001\npm\u0016\u0014\u0018\r\u001c7N_J,'+Z2f]R\u0004\u0013!C:fO6,g\u000e^:!\u0003\u0015\u0019\u0018N_3t+\t\ty\fE\u0003\u0002B\u0006\u001dg.\u0004\u0002\u0002D*\u0019\u0011Q\u00196\u0002\u000f5,H/\u00192mK&!\u0011qDAb\u0003\u0019\u0019\u0018N_3tA\u0005qqN^3sC2d'+Z2f]\u000eLXCAA(\u0003=yg/\u001a:bY2\u0014VmY3oGf\u0004\u0013A\u00037p_.,\bOT8eKV\u0011\u0011Q\u001b\t\b\u0003\u0003\f9N`A+\u0013\u0011\tI.a1\u0003\u00075\u000b\u0007/A\u0006m_>\\W\u000f\u001d(pI\u0016\u0004\u0013\u0001B:ju\u0016\faa]5{K>3Gc\u00018\u0002d\"1\u0011\u0011O\u001cA\u00029\fa!\u001e9eCR,GcA?\u0002j\"1\u0011q\f\u001dA\u0002y\faA]3n_Z,GcA?\u0002p\"1\u0011qL\u001dA\u0002y\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003k\fY\u0010E\u0002X\u0003oL1!!?Y\u0005\u001d\u0011un\u001c7fC:Da!a\u0018;\u0001\u0004q\u0018a\u00037fCN$(+Z2f]R,\"A!\u0001\u0011\u0007M\u001bh0A\nmK\u0006\u001cH\u000fV8N_N$(+Z2f]R|e\r\u0006\u0003\u0003\b\t}\u0001#\u0002B\u0005\u00053qh\u0002\u0002B\u0006\u0005+qAA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0004\u0005#i\u0016A\u0002\u001fs_>$h(C\u0001Z\u0013\r\u00119\u0002W\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YB!\b\u0003\u0011%#XM]1u_JT1Aa\u0006Y\u0011\u0019\t\t\b\u0010a\u0001]\u0006Q\"/Z7pm\u0016dU-Y:u%\u0016\u001cWM\u001c;Pm\u0016\u0014H*[7jiR\u0011!Q\u0005\t\u0004O2t\u0018!\u0005:f[>4X\rT3bgR\u0014VmY3oi\u0006y\"/Z7pm\u0016|e/\u001a:bY2dU-Y:u%\u0016\u001cWM\u001c;PkR\u001c\u0018\u000eZ3\u0015\t\t\u0015\"Q\u0006\u0005\b\u0005_y\u0004\u0019\u0001B\u0019\u0003!!WO]1uS>t\u0007\u0003\u0002B\u001a\u0005wi!A!\u000e\u000b\t\t=\"q\u0007\u0006\u0004\u0005sA\u0016AC2p]\u000e,(O]3oi&!!Q\bB\u001b\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fA\"\u001e9eCR,G*[7jiN$B!!\n\u0003D!1!Q\t!A\u0002\u0019\f\u0011B\\3x\u0019&l\u0017\u000e^:\u0002+\u0005$'.^:u!J|G/Z2uK\u0012dUM^3mgR\u0011\u0011QE\u0001\u0007C\u0012TWo\u001d;\u0015\t\u0005\u0015\"q\n\u0005\u0007\u0003c\u0012\u0005\u0019\u00018\u0002\r%t7/\u001a:u)\u0011\t)C!\u0016\t\u000f\t]3\t1\u0001\u0002V\u0005!an\u001c3f\u0003\u001d\u0001(o\\7pi\u0016$B!!\n\u0003^!9!q\u000b#A\u0002\u0005U\u0013A\u00023f[>$X\r\u0006\u0003\u0002&\t\r\u0004b\u0002B,\u000b\u0002\u0007\u0011QK\u0001\tCB\u0004XM\u001c3U_R1\u0011Q\u0005B5\u0005WBa!!\u001dG\u0001\u0004q\u0007b\u0002B,\r\u0002\u0007\u0011QK\u0001\u0017e\u0016lwN^3Ge>l7)\u001e:sK:$H*\u001a<fYR!\u0011Q\u0005B9\u0011\u001d\u00119f\u0012a\u0001\u0003+\n!B]3n_Z,gj\u001c3f)\rq(q\u000f\u0005\b\u0005/B\u0005\u0019AA+Q\rq\"1\u0010\t\u0005\u0005{\u0012\u0019)\u0004\u0002\u0003\u0000)\u0019!\u0011\u0011'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0006\n}$aC%oi\u0016\u0014h.\u00197Ba&\u00042a BE\t\u001d\t\u0019a\u0001b\u0001\u0003\u000bAa!a\u0006\u0004\u0001\u00041\u0017AE<ji\"|e/\u001a:bY2\u0014VmY3oGf\u00042!!\u001c\u0006\u0005I9\u0018\u000e\u001e5Pm\u0016\u0014\u0018\r\u001c7SK\u000e,gnY=\u0014\u0005\u00151FC\u0001BH+\u0011\u0011IJa(\u0015\t\tm%\u0011\u0015\t\u0005'z\u0011i\nE\u0002\u0000\u0005?#q!a\u0001\b\u0005\u0004\t)\u0001\u0003\u0004\u0002\u0018\u001d\u0001\rA\u001a\u0015\u0004\u0003\tm\u0004f\u0001\u0001\u0003|\u0001")
@InternalApi
public final class SegmentedRecencyList<A> {
    private final RecencyList.Clock clock;
    private scala.collection.immutable.IndexedSeq<Object> limits;
    private int totalLimit;
    private final int levels;
    private final int lowest;
    private final int highest;
    private final scala.collection.immutable.IndexedSeq<DoubleLinkedList<Node<A>>> segments;
    private final IndexedSeq<Object> sizes;
    private final DoubleLinkedList<Node<A>> overallRecency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> SegmentedRecencyList<A> empty(Seq<Object> limits) {
        return SegmentedRecencyList$.MODULE$.empty(limits);
    }

    private scala.collection.immutable.IndexedSeq<Object> limits() {
        return this.limits;
    }

    private void limits_$eq(scala.collection.immutable.IndexedSeq<Object> x$1) {
        this.limits = x$1;
    }

    private int totalLimit() {
        return this.totalLimit;
    }

    private void totalLimit_$eq(int x$1) {
        this.totalLimit = x$1;
    }

    private int levels() {
        return this.levels;
    }

    private int lowest() {
        return this.lowest;
    }

    private int highest() {
        return this.highest;
    }

    private scala.collection.immutable.IndexedSeq<DoubleLinkedList<Node<A>>> segments() {
        return this.segments;
    }

    private IndexedSeq<Object> sizes() {
        return this.sizes;
    }

    private DoubleLinkedList<Node<A>> overallRecency() {
        return this.overallRecency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public int sizeOf(int level) {
        return BoxesRunTime.unboxToInt((Object)this.sizes().apply(level));
    }

    public SegmentedRecencyList<A> update(A value) {
        if (this.lookupNode().contains(value)) {
            this.promote((Node)this.lookupNode().apply(value));
        } else {
            this.insert(new Node<A>(value));
        }
        return this;
    }

    public SegmentedRecencyList<A> remove(A value) {
        Object object = this.lookupNode().contains(value) ? this.removeNode((Node)this.lookupNode().apply(value)) : BoxedUnit.UNIT;
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public A leastRecent() {
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            return OptionVal$Some$.MODULE$.apply(first.value());
        }
        return OptionVal$.MODULE$.none();
    }

    public Iterator<A> leastToMostRecentOf(int level) {
        return ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().map((Function1 & Serializable)x$5 -> x$5.value());
    }

    public Seq<A> removeLeastRecentOverLimit() {
        if (this.size() > this.totalLimit()) {
            this.adjustProtectedLevels();
            int excess = this.size() - this.totalLimit();
            if (excess == 1) {
                return this.removeLeastRecent();
            }
            return ((DoubleLinkedList)this.segments().apply(this.lowest())).forwardIterator().take(excess).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
        }
        return Nil$.MODULE$;
    }

    public Seq<A> removeLeastRecent() {
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(first)}));
        }
        return Nil$.MODULE$;
    }

    public Seq<A> removeOverallLeastRecentOutside(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled");
        }
        long min2 = OptionVal$.MODULE$.get$extension(this.clock).earlierTime(duration);
        return this.overallRecency().forwardIterator().takeWhile((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SegmentedRecencyList.$anonfun$removeOverallLeastRecentOutside$1(min2, x$6))).map((Function1 & Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public void updateLimits(Seq<Object> newLimits) {
        this.limits_$eq((scala.collection.immutable.IndexedSeq<Object>)newLimits.toIndexedSeq());
        this.totalLimit_$eq(BoxesRunTime.unboxToInt((Object)this.limits().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    private void adjustProtectedLevels() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.highest()), this.lowest()).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)level -> this.adjust(level));
    }

    private void adjust(int level) {
        int excess = BoxesRunTime.unboxToInt((Object)this.sizes().apply(level)) - BoxesRunTime.unboxToInt((Object)this.limits().apply(level));
        if (excess > 0) {
            ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().take(excess).foreach((Function1 & Serializable)node -> {
                this.demote(node);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void insert(Node<A> node) {
        this.appendTo(this.lowest(), node);
        this.lookupNode().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(node.value()), node));
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().append(node);
            return;
        }
    }

    private void promote(Node<A> node) {
        BoxedUnit boxedUnit;
        if (node.level() == this.highest()) {
            boxedUnit = ((DoubleLinkedList)this.segments().apply(node.level())).moveToBack(node);
        } else {
            int newLevel = node.level() + 1;
            this.removeFromCurrentLevel(node);
            this.appendTo(newLevel, node);
            this.adjust(newLevel);
            boxedUnit = BoxedUnit.UNIT;
        }
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().moveToBack(node);
            return;
        }
    }

    private void demote(Node<A> node) {
        this.removeFromCurrentLevel(node);
        this.appendTo(node.level() - 1, node);
    }

    private void appendTo(int level, Node<A> node) {
        node.level_$eq(level);
        ((DoubleLinkedList)this.segments().apply(level)).append(node);
        this.sizes().update(level, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizes().apply(level)) + 1)));
    }

    private void removeFromCurrentLevel(Node<A> node) {
        ((DoubleLinkedList)this.segments().apply(node.level())).remove(node);
        int n = node.level();
        this.sizes().update(n, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizes().apply(n)) - 1)));
    }

    private A removeNode(Node<A> node) {
        A value = node.value();
        this.removeFromCurrentLevel(node);
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            this.overallRecency().remove(node);
        }
        this.lookupNode().$minus$eq(value);
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$removeOverallLeastRecentOutside$1(long min$1, Node x$6) {
        return x$6.timestamp() < min$1;
    }

    public SegmentedRecencyList(Seq<Object> initialLimits, RecencyList.Clock clock) {
        this.clock = clock;
        this.limits = initialLimits.toIndexedSeq();
        this.totalLimit = BoxesRunTime.unboxToInt((Object)this.limits().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.levels = this.limits().size();
        this.lowest = 0;
        this.highest = this.levels() - 1;
        this.segments = (scala.collection.immutable.IndexedSeq)package$.MODULE$.IndexedSeq().fill(this.levels(), (Function0 & Serializable)() -> new DoubleLinkedList((Function1 & Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1 & Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2 & Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(node, next2) -> {
            node.moreRecent_$eq((Node)((OptionVal)next2).x());
            return BoxedUnit.UNIT;
        }));
        this.sizes = (IndexedSeq)IndexedSeq$.MODULE$.fill(this.levels(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
        this.overallRecency = new DoubleLinkedList((Function1 & Serializable)x$3 -> new OptionVal<Node>(x$3.overallLessRecent()), (Function1 & Serializable)x$4 -> new OptionVal<Node>(x$4.overallMoreRecent()), (Function2 & Serializable)(node, previous) -> {
            node.overallLessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(node, next2) -> {
            node.overallMoreRecent_$eq((Node)((OptionVal)next2).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
    }

    private static final class Node<A> {
        private final A value;
        private int level;
        private long timestamp;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private Node<A> overallLessRecent;
        private Node<A> overallMoreRecent;

        public A value() {
            return this.value;
        }

        public int level() {
            return this.level;
        }

        public void level_$eq(int x$1) {
            this.level = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public Node<A> overallLessRecent() {
            return this.overallLessRecent;
        }

        public void overallLessRecent_$eq(Node<A> x$1) {
            this.overallLessRecent = x$1;
        }

        public Node<A> overallMoreRecent() {
            return this.overallMoreRecent;
        }

        public void overallMoreRecent_$eq(Node<A> x$1) {
            this.overallMoreRecent = x$1;
        }

        public Node(A value) {
            this.value = value;
            this.level = 0;
            this.timestamp = 0L;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            OptionVal$.MODULE$.None();
            this.overallLessRecent = null;
            OptionVal$.MODULE$.None();
            this.overallMoreRecent = null;
        }
    }
}

