/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Close$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Finished$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Initialized$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$ReadElementAcknowledgement$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}f!\u0002\u000e\u001c\u0001\u0005:\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011%\u0003!\u0011!Q\u0001\n)C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\u0006=\u0002!\ta\u0018\u0005\bK\u0002\u0001\r\u0011\"\u0001g\u0011\u001dQ\u0007\u00011A\u0005\u0002-DaA\u001c\u0001!B\u00139\u0007bB8\u0001\u0005\u0004%\t\u0001\u001d\u0005\u0007o\u0002\u0001\u000b\u0011B9\t\u000fa\u0004\u0001\u0019!C\u0001M\"9\u0011\u0010\u0001a\u0001\n\u0003Q\bB\u0002?\u0001A\u0003&q\rC\u0003~\u0001\u0011\u0005a\u0010C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0001\u0002\b!I\u0011\u0011\u0004\u0001A\u0002\u0013\u0005\u00111\u0004\u0005\t\u0003?\u0001\u0001\u0015)\u0003\u0002\n!A\u0011\u0011\u0005\u0001!\n\u0013\t\u0019\u0003C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005E\u0003\u0001\"\u0011\u0002^!9\u0011\u0011\u000b\u0001\u0005B\u0005E\u0004\u0002CA@\u0001\u0001&I!!!\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"A\u0011q\u0012\u0001!\n\u0013\t\t\n\u0003\u0005\u0002.\u0002\u0001K\u0011BAF\u0011!\ty\u000b\u0001Q\u0005\n\u0005E&AE%oaV$8\u000b\u001e:fC6\fE-\u00199uKJT!\u0001H\u000f\u0002\u0005%|'B\u0001\u0010 \u0003\u0011IW\u000e\u001d7\u000b\u0005\u0001\n\u0013AB:ue\u0016\fWN\u0003\u0002#G\u0005)\u0001/Z6l_*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h'\t\u0001\u0001\u0006\u0005\u0002*[5\t!F\u0003\u0002\u001dW)\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018+\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0019MD\u0017M]3e\u0005V4g-\u001a:\u0004\u0001A\u0019!gN\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00027W\u0005!Q\u000f^5m\u0013\tA4GA\u0007CY>\u001c7.\u001b8h#V,W/\u001a\t\u0003u\u0019s!a\u000f#\u000f\u0005q\u001aeBA\u001fC\u001d\tq\u0014I\u0004\u0002@\u00016\t1%\u0003\u0002#G%\u0011\u0001%I\u0005\u0003=}I!\u0001H\u000f\n\u0005\u0015[\u0012\u0001F%oaV$8\u000b\u001e:fC6\u001c\u0016N\\6Ti\u0006<W-\u0003\u0002H\u0011\n12\u000b\u001e:fC6$v.\u00113baR,'/T3tg\u0006<WM\u0003\u0002F7\u0005Y1/\u001a8e)>\u001cF/Y4f!\u0011Ye\nU*\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0005i\n\u0016B\u0001*I\u0005U\tE-\u00199uKJ$vn\u0015;bO\u0016lUm]:bO\u0016\u0004\"a\u0013+\n\u0005Uc%\u0001B+oSR\f1B]3bIRKW.Z8viB\u0011\u0001\fX\u0007\u00023*\u0011!lW\u0001\tIV\u0014\u0018\r^5p]*\u0011A\u0007T\u0005\u0003;f\u0013aBR5oSR,G)\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0005A\n\u001cG\r\u0005\u0002b\u00015\t1\u0004C\u00030\t\u0001\u0007\u0011\u0007C\u0003J\t\u0001\u0007!\nC\u0003W\t\u0001\u0007q+A\u0007jg&s\u0017\u000e^5bY&TX\rZ\u000b\u0002OB\u00111\n[\u0005\u0003S2\u0013qAQ8pY\u0016\fg.A\tjg&s\u0017\u000e^5bY&TX\rZ0%KF$\"a\u00157\t\u000f54\u0011\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\u0002\u001d%\u001c\u0018J\\5uS\u0006d\u0017N_3eA\u0005A\u0011n]!di&4X-F\u0001r!\t\u0011X/D\u0001t\u0015\t!8'\u0001\u0004bi>l\u0017nY\u0005\u0003mN\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!C5t\u0003\u000e$\u0018N^3!\u00031I7o\u0015;bO\u0016\fE.\u001b<f\u0003AI7o\u0015;bO\u0016\fE.\u001b<f?\u0012*\u0017\u000f\u0006\u0002Tw\"9QnCA\u0001\u0002\u00049\u0017!D5t'R\fw-Z!mSZ,\u0007%A\rtk\n\u001c8M]5cKJ\u001cEn\\:fI\u0016C8-\u001a9uS>tW#A@\u0011\u0007%\n\t!C\u0002\u0002\u0004)\u00121\"S(Fq\u000e,\u0007\u000f^5p]\u0006iA-\u001a;bG\",Gm\u00115v].,\"!!\u0003\u0011\u000b-\u000bY!a\u0004\n\u0007\u00055AJ\u0001\u0004PaRLwN\u001c\t\u0005\u0003#\t)\"\u0004\u0002\u0002\u0014)\u0011a'I\u0005\u0005\u0003/\t\u0019B\u0001\u0006CsR,7\u000b\u001e:j]\u001e\f\u0011\u0003Z3uC\u000eDW\rZ\"ik:\\w\fJ3r)\r\u0019\u0016Q\u0004\u0005\t[>\t\t\u00111\u0001\u0002\n\u0005qA-\u001a;bG\",Gm\u00115v].\u0004\u0013AE3yK\u000e,H/Z%g\u001d>$8\t\\8tK\u0012,B!!\n\u0002,Q!\u0011qEA\u001f!\u0011\tI#a\u000b\r\u0001\u00119\u0011QF\tC\u0002\u0005=\"!\u0001+\u0012\t\u0005E\u0012q\u0007\t\u0004\u0017\u0006M\u0012bAA\u001b\u0019\n9aj\u001c;iS:<\u0007cA&\u0002:%\u0019\u00111\b'\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002@E\u0001\r!!\u0011\u0002\u0003\u0019\u0004RaSA\"\u0003OI1!!\u0012M\u0005%1UO\\2uS>t\u0007\u0007K\u0003\u0012\u0003\u0013\ny\u0005\u0005\u0003L\u0003\u0017z\u0018bAA'\u0019\n1A\u000f\u001b:poN\u001c\u0013a`\u0001\u0005e\u0016\fG\r\u0006\u0002\u0002VA\u00191*a\u0016\n\u0007\u0005eCJA\u0002J]RDSAEA%\u0003\u001f\"B!!\u0016\u0002`!9\u0011\u0011M\nA\u0002\u0005\r\u0014!A1\u0011\u000b-\u000b)'!\u001b\n\u0007\u0005\u001dDJA\u0003BeJ\f\u0017\u0010E\u0002L\u0003WJ1!!\u001cM\u0005\u0011\u0011\u0015\u0010^3)\u000bM\tI%a\u0014\u0015\u0011\u0005U\u00131OA;\u0003sBq!!\u0019\u0015\u0001\u0004\t\u0019\u0007C\u0004\u0002xQ\u0001\r!!\u0016\u0002\u000b\t,w-\u001b8\t\u000f\u0005mD\u00031\u0001\u0002V\u00051A.\u001a8hi\"DS\u0001FA%\u0003\u001f\n\u0011B]3bI\nKH/Z:\u0015\u0011\u0005U\u00131QAC\u0003\u000fCq!!\u0019\u0016\u0001\u0004\t\u0019\u0007C\u0004\u0002xU\u0001\r!!\u0016\t\u000f\u0005mT\u00031\u0001\u0002V\u0005)1\r\\8tKR\t1\u000bK\u0003\u0017\u0003\u0013\ny%A\u0004hKR$\u0015\r^1\u0015\u0015\u0005U\u00131SAL\u00033\u000bY\nC\u0004\u0002\u0016^\u0001\r!a\u0019\u0002\u0007\u0005\u0014(\u000fC\u0004\u0002x]\u0001\r!!\u0016\t\u000f\u0005mt\u00031\u0001\u0002V!9\u0011QT\fA\u0002\u0005U\u0013\u0001C4pi\nKH/Z:)\u0007]\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9\u000bT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAV\u0003K\u0013q\u0001^1jYJ,7-\u0001\u000bxC&$\u0018J\u001a(pi&s\u0017\u000e^5bY&TX\rZ\u0001\u000eOJ\f'\rR1uC\u000eCWO\\6\u0015\u0005\u0005%\u0001f\u0001\u0001\u00026B!\u0011qWA^\u001b\t\tILC\u0002\u0002(\u0006JA!!0\u0002:\nY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public class InputStreamAdapter
extends InputStream {
    private final BlockingQueue<InputStreamSinkStage.StreamToAdapterMessage> sharedBuffer;
    private final Function1<InputStreamSinkStage.AdapterToStageMessage, BoxedUnit> sendToStage;
    private final FiniteDuration readTimeout;
    private boolean isInitialized;
    private final AtomicBoolean isActive;
    private boolean isStageAlive;
    private Option<ByteString> detachedChunk;

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    public boolean isStageAlive() {
        return this.isStageAlive;
    }

    public void isStageAlive_$eq(boolean x$1) {
        this.isStageAlive = x$1;
    }

    public IOException subscriberClosedException() {
        return new IOException("Reactive stream is terminated, no reads are possible");
    }

    public Option<ByteString> detachedChunk() {
        return this.detachedChunk;
    }

    public void detachedChunk_$eq(Option<ByteString> x$1) {
        this.detachedChunk = x$1;
    }

    private <T> T executeIfNotClosed(Function0<T> f) throws IOException {
        if (this.isActive().get()) {
            this.waitIfNotInitialized();
            return (T)f.apply();
        }
        throw this.subscriberClosedException();
    }

    @Override
    public int read() throws IOException {
        byte[] a = new byte[1];
        int n = this.read(a, 0, 1);
        switch (n) {
            case 1: {
                return a[0] & 0xFF;
            }
            case -1: {
                return -1;
            }
        }
        throw new IllegalStateException(new StringBuilder(17).append("Invalid length [").append(n).append("]").toString());
    }

    @Override
    public int read(byte[] a) throws IOException {
        return this.read(a, 0, a.length);
    }

    @Override
    public int read(byte[] a, int begin, int length) throws IOException {
        Predef$.MODULE$.require(a.length > 0, (Function0 & Serializable)() -> "array size must be >= 0");
        Predef$.MODULE$.require(begin >= 0, (Function0 & Serializable)() -> "begin must be >= 0");
        Predef$.MODULE$.require(length >= 0, (Function0 & Serializable)() -> "length must be >= 0");
        Predef$.MODULE$.require(begin + length <= a.length, (Function0 & Serializable)() -> "begin + length must be smaller or equal to the array length");
        if (length == 0) {
            return 0;
        }
        return BoxesRunTime.unboxToInt(this.executeIfNotClosed((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            if (this.isStageAlive()) {
                Option<ByteString> option = this.detachedChunk();
                if (None$.MODULE$.equals(option)) {
                    int n;
                    block10: {
                        try {
                            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = $this.sharedBuffer.poll($this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                            if (streamToAdapterMessage instanceof InputStreamSinkStage.Data) {
                                InputStreamSinkStage.Data data = (InputStreamSinkStage.Data)streamToAdapterMessage;
                                ByteString data2 = data.data();
                                this.detachedChunk_$eq((Option<ByteString>)new Some((Object)data2));
                                n = this.readBytes(a, begin, length);
                                break block10;
                            }
                            if (InputStreamSinkStage$Finished$.MODULE$.equals(streamToAdapterMessage)) {
                                this.isStageAlive_$eq(false);
                                n = -1;
                                break block10;
                            }
                            if (streamToAdapterMessage instanceof InputStreamSinkStage.Failed) {
                                InputStreamSinkStage.Failed failed = (InputStreamSinkStage.Failed)streamToAdapterMessage;
                                Throwable ex = failed.cause();
                                this.isStageAlive_$eq(false);
                                throw new IOException(ex);
                            }
                            if (streamToAdapterMessage == null) {
                                throw new IOException("Timeout on waiting for new data");
                            }
                            if (InputStreamSinkStage$Initialized$.MODULE$.equals(streamToAdapterMessage)) {
                                throw new IllegalStateException("message 'Initialized' must come first");
                            }
                            throw new MatchError((Object)streamToAdapterMessage);
                        }
                        catch (InterruptedException ex) {
                            throw new IOException(ex);
                        }
                    }
                    return n;
                }
                if (option instanceof Some) {
                    return this.readBytes(a, begin, length);
                }
                throw new MatchError(option);
            }
            return -1;
        }));
    }

    private int readBytes(byte[] a, int begin, int length) {
        Predef$.MODULE$.require(this.detachedChunk().nonEmpty(), (Function0 & Serializable)() -> "Chunk must be pulled from shared buffer");
        int availableInChunk = ((SeqOps)this.detachedChunk().get()).size();
        int readBytes = this.getData(a, begin, length, 0);
        Object object = readBytes >= availableInChunk ? this.sendToStage.apply((Object)InputStreamSinkStage$ReadElementAcknowledgement$.MODULE$) : BoxedUnit.UNIT;
        return readBytes;
    }

    @Override
    public void close() throws IOException {
        if (this.isActive().getAndSet(false)) {
            if (this.isStageAlive()) {
                this.sendToStage.apply((Object)InputStreamSinkStage$Close$.MODULE$);
                return;
            }
            return;
        }
    }

    private int getData(byte[] arr, int begin, int length, int gotBytes) {
        Option<ByteString> option;
        while ((option = this.grabDataChunk()) instanceof Some) {
            Some some = (Some)option;
            ByteString data = (ByteString)some.value();
            int size = data.size();
            if (size <= length) {
                data.copyToArray(arr, begin, size);
                this.detachedChunk_$eq((Option<ByteString>)None$.MODULE$);
                if (size == length) {
                    return gotBytes + size;
                }
                gotBytes += size;
                length -= size;
                begin += size;
                continue;
            }
            data.copyToArray(arr, begin, length);
            this.detachedChunk_$eq((Option<ByteString>)new Some((Object)data.drop(length)));
            return gotBytes + length;
        }
        if (None$.MODULE$.equals(option)) {
            return gotBytes;
        }
        throw new MatchError(option);
    }

    private void waitIfNotInitialized() {
        if (!this.isInitialized()) {
            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = this.sharedBuffer.poll(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (InputStreamSinkStage$Initialized$.MODULE$.equals(streamToAdapterMessage)) {
                this.isInitialized_$eq(true);
                return;
            }
            if (streamToAdapterMessage == null) {
                throw new IOException(new StringBuilder(57).append("Timeout after ").append(this.readTimeout).append(" waiting for Initialized message from stage").toString());
            }
            Predef$.MODULE$.require(false, (Function0 & Serializable)() -> new StringBuilder(52).append("First message must be Initialized notification, got ").append(streamToAdapterMessage).toString());
            return;
        }
    }

    private Option<ByteString> grabDataChunk() {
        Option<ByteString> option = this.detachedChunk();
        if (None$.MODULE$.equals(option)) {
            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = (InputStreamSinkStage.StreamToAdapterMessage)this.sharedBuffer.poll();
            if (streamToAdapterMessage instanceof InputStreamSinkStage.Data) {
                InputStreamSinkStage.Data data = (InputStreamSinkStage.Data)streamToAdapterMessage;
                ByteString data2 = data.data();
                this.detachedChunk_$eq((Option<ByteString>)new Some((Object)data2));
                return this.detachedChunk();
            }
            if (InputStreamSinkStage$Finished$.MODULE$.equals(streamToAdapterMessage)) {
                this.isStageAlive_$eq(false);
                return None$.MODULE$;
            }
            if (streamToAdapterMessage instanceof InputStreamSinkStage.Failed) {
                InputStreamSinkStage.Failed failed = (InputStreamSinkStage.Failed)streamToAdapterMessage;
                Throwable e = failed.cause();
                throw new IOException(e);
            }
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            return this.detachedChunk();
        }
        throw new MatchError(option);
    }

    public InputStreamAdapter(BlockingQueue<InputStreamSinkStage.StreamToAdapterMessage> sharedBuffer, Function1<InputStreamSinkStage.AdapterToStageMessage, BoxedUnit> sendToStage, FiniteDuration readTimeout) {
        this.sharedBuffer = sharedBuffer;
        this.sendToStage = sendToStage;
        this.readTimeout = readTimeout;
        this.isInitialized = false;
        this.isActive = new AtomicBoolean(true);
        this.isStageAlive = true;
        this.detachedChunk = None$.MODULE$;
    }
}

