/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterHeartbeatReceiver$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import org.apache.pekko.cluster.ClusterHeartbeatSenderState;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.ClusterMessage;
import org.apache.pekko.cluster.HeartbeatNodeRing;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.event.ActorWithLogClass;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.HeartbeatMessage;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rexACA\u0004\u0003\u0013A\t!!\u0003\u0002\u001a\u0019Q\u0011QDA\u0005\u0011\u0003\tI!a\b\t\u000f\u00055\u0012\u0001\"\u0001\u00022\u00191\u00111G\u0001C\u0003kA!\"a\u001d\u0004\u0005+\u0007I\u0011AA;\u0011)\tih\u0001B\tB\u0003%\u0011q\u000f\u0005\u000b\u0003\u007f\u001a!Q3A\u0005\u0002\u0005\u0005\u0005BCAE\u0007\tE\t\u0015!\u0003\u0002\u0004\"Q\u00111R\u0002\u0003\u0016\u0004%\t!!!\t\u0015\u000555A!E!\u0002\u0013\t\u0019\tC\u0004\u0002.\r!\t!a$\t\u0013\u0005m5!!A\u0005\u0002\u0005u\u0005\"CAS\u0007E\u0005I\u0011AAT\u0011%\tilAI\u0001\n\u0003\ty\fC\u0005\u0002D\u000e\t\n\u0011\"\u0001\u0002@\"I\u0011QY\u0002\u0002\u0002\u0013\u0005\u0013q\u0019\u0005\n\u00033\u001c\u0011\u0011!C\u0001\u00037D\u0011\"a9\u0004\u0003\u0003%\t!!:\t\u0013\u0005E8!!A\u0005B\u0005M\b\"\u0003B\u0001\u0007\u0005\u0005I\u0011\u0001B\u0002\u0011%\u0011iaAA\u0001\n\u0003\u0012y\u0001C\u0005\u0003\u0014\r\t\t\u0011\"\u0011\u0003\u0016!I!qC\u0002\u0002\u0002\u0013\u0005#\u0011\u0004\u0005\n\u00057\u0019\u0011\u0011!C!\u0005;9\u0011B!\t\u0002\u0003\u0003E\tAa\t\u0007\u0013\u0005M\u0012!!A\t\u0002\t\u0015\u0002bBA\u00173\u0011\u0005!Q\b\u0005\n\u0005/I\u0012\u0011!C#\u00053A\u0011Ba\u0010\u001a\u0003\u0003%\tI!\u0011\t\u0013\t%\u0013$!A\u0005\u0002\n-\u0003\"\u0003B/3\u0005\u0005I\u0011\u0002B0\r\u0019\u00119'\u0001\"\u0003j!Q\u00111O\u0010\u0003\u0016\u0004%\tAa\u001b\t\u0015\u0005utD!E!\u0002\u0013\u0011i\u0007\u0003\u0006\u0002\u0000}\u0011)\u001a!C\u0001\u0003\u0003C!\"!# \u0005#\u0005\u000b\u0011BAB\u0011)\tYi\bBK\u0002\u0013\u0005\u0011\u0011\u0011\u0005\u000b\u0003\u001b{\"\u0011#Q\u0001\n\u0005\r\u0005bBA\u0017?\u0011\u0005!1\u000f\u0005\n\u00037{\u0012\u0011!C\u0001\u0005{B\u0011\"!* #\u0003%\tA!\"\t\u0013\u0005uv$%A\u0005\u0002\u0005}\u0006\"CAb?E\u0005I\u0011AA`\u0011%\t)mHA\u0001\n\u0003\n9\rC\u0005\u0002Z~\t\t\u0011\"\u0001\u0002\\\"I\u00111]\u0010\u0002\u0002\u0013\u0005!\u0011\u0012\u0005\n\u0003c|\u0012\u0011!C!\u0003gD\u0011B!\u0001 \u0003\u0003%\tA!$\t\u0013\t5q$!A\u0005B\tE\u0005\"\u0003B\n?\u0005\u0005I\u0011\tB\u000b\u0011%\u00119bHA\u0001\n\u0003\u0012I\u0002C\u0005\u0003\u001c}\t\t\u0011\"\u0011\u0003\u0016\u001eI!\u0011T\u0001\u0002\u0002#\u0005!1\u0014\u0004\n\u0005O\n\u0011\u0011!E\u0001\u0005;Cq!!\f6\t\u0003\u0011\t\u000bC\u0005\u0003\u0018U\n\t\u0011\"\u0012\u0003\u001a!I!qH\u001b\u0002\u0002\u0013\u0005%1\u0015\u0005\n\u0005\u0013*\u0014\u0011!CA\u0005WC\u0011B!\u00186\u0003\u0003%IAa\u0018\b\u000f\tM\u0016\u0001#!\u00036\u001a9!qW\u0001\t\u0002\ne\u0006bBA\u0017y\u0011\u0005!1\u0018\u0005\n\u0003\u000bd\u0014\u0011!C!\u0003\u000fD\u0011\"!7=\u0003\u0003%\t!a7\t\u0013\u0005\rH(!A\u0005\u0002\tu\u0006\"CAyy\u0005\u0005I\u0011IAz\u0011%\u0011\t\u0001PA\u0001\n\u0003\u0011\t\rC\u0005\u0003\u0014q\n\t\u0011\"\u0011\u0003\u0016!I!q\u0003\u001f\u0002\u0002\u0013\u0005#\u0011\u0004\u0005\n\u0005;b\u0014\u0011!C\u0005\u0005?2aA!2\u0002\u0005\n\u001d\u0007BCA:\r\nU\r\u0011\"\u0001\u0003l!Q\u0011Q\u0010$\u0003\u0012\u0003\u0006IA!\u001c\t\u000f\u00055b\t\"\u0001\u0003J\"I\u00111\u0014$\u0002\u0002\u0013\u0005!q\u001a\u0005\n\u0003K3\u0015\u0013!C\u0001\u0005\u000bC\u0011\"!2G\u0003\u0003%\t%a2\t\u0013\u0005eg)!A\u0005\u0002\u0005m\u0007\"CAr\r\u0006\u0005I\u0011\u0001Bj\u0011%\t\tPRA\u0001\n\u0003\n\u0019\u0010C\u0005\u0003\u0002\u0019\u000b\t\u0011\"\u0001\u0003X\"I!Q\u0002$\u0002\u0002\u0013\u0005#1\u001c\u0005\n\u0005'1\u0015\u0011!C!\u0005+A\u0011Ba\u0006G\u0003\u0003%\tE!\u0007\t\u0013\tma)!A\u0005B\t}w!\u0003Br\u0003\u0005\u0005\t\u0012\u0001Bs\r%\u0011)-AA\u0001\u0012\u0003\u00119\u000fC\u0004\u0002.Y#\tAa<\t\u0013\t]a+!A\u0005F\te\u0001\"\u0003B -\u0006\u0005I\u0011\u0011By\u0011%\u0011IEVA\u0001\n\u0003\u0013)\u0010C\u0005\u0003^Y\u000b\t\u0011\"\u0003\u0003`\u0019I\u0011QDA\u0005\u0001\u0005%!1 \u0005\b\u0003[aF\u0011AB\u0002\u0011%\tY\u0001\u0018b\u0001\n\u0003\u00199\u0001\u0003\u0005\u0004\u0010q\u0003\u000b\u0011BB\u0005\u0011%\u0019\t\u0002\u0018b\u0001\n\u0003\u0019\u0019\u0002\u0003\u0005\u0004\u0016q\u0003\u000b\u0011\u0002B\u0003\u0011%\u00199\u0002\u0018b\u0001\n\u0013\u0019I\u0002\u0003\u0005\u0004&q\u0003\u000b\u0011BB\u000e\u0011%\u00199\u0003\u0018b\u0001\n\u0003\u0019I\u0003\u0003\u0005\u00048q\u0003\u000b\u0011BB\u0016\u0011%\ty\b\u0018a\u0001\n\u0003\tY\u000eC\u0005\u0004:q\u0003\r\u0011\"\u0001\u0004<!A\u0011\u0011\u0012/!B\u0013\ti\u000eC\u0004\u0004Fq#\taa\u0012\t\u0013\r5CL1A\u0005\u0002\r=\u0003\u0002CB,9\u0002\u0006Ia!\u0015\t\u0013\reC\f1A\u0005\u0002\rm\u0003\"CB29\u0002\u0007I\u0011AB3\u0011!\u0019I\u0007\u0018Q!\n\ru\u0003\"CB69\n\u0007I\u0011AB7\u0011!\u0019)\b\u0018Q\u0001\n\r=\u0004\"CB<9\u0002\u0007I\u0011BAA\u0011%\u0019I\b\u0018a\u0001\n\u0013\u0019Y\b\u0003\u0005\u0004\u0000q\u0003\u000b\u0015BAB\u0011\u001d\u0019\t\t\u0018C!\u0007\u0007Cqa!\"]\t\u0003\u001a\u0019\tC\u0004\u0004\br#\ta!#\t\u000f\rUE\f\"\u0001\u0004\u0018\"91q\u0015/\u0005\u0002\r]\u0005bBBU9\u0012\u00051q\u0013\u0005\b\u0007WcF\u0011ABW\u0011\u001d\u0019Y\r\u0018C\u0001\u0007\u001bDqaa5]\t\u0003\u0019)\u000eC\u0004\u0004Zr#\taa7\t\u000f\r}G\f\"\u0001\u0004b\"91Q\u001d/\u0005\u0002\r\r\u0005bBBt9\u0012%11\u0011\u0005\b\u0007SdF\u0011ABv\u0011\u001d\u0019\u0019\u0010\u0018C\u0001\u0007k\fac\u00117vgR,'\u000fS3beR\u0014W-\u0019;TK:$WM\u001d\u0006\u0005\u0003\u0017\ti!A\u0004dYV\u001cH/\u001a:\u000b\t\u0005=\u0011\u0011C\u0001\u0006a\u0016\\7n\u001c\u0006\u0005\u0003'\t)\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003/\t1a\u001c:h!\r\tY\"A\u0007\u0003\u0003\u0013\u0011ac\u00117vgR,'\u000fS3beR\u0014W-\u0019;TK:$WM]\n\u0004\u0003\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0005\u0005\u001d\u0012!B:dC2\f\u0017\u0002BA\u0016\u0003K\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0005\u0005e!!\u0003%fCJ$(-Z1u'5\u0019\u0011\u0011EA\u001c\u0003{\tI%!\u0016\u0002\\A!\u00111DA\u001d\u0013\u0011\tY$!\u0003\u0003\u001d\rcWo\u001d;fe6+7o]1hKB!\u0011qHA#\u001b\t\t\tE\u0003\u0003\u0002D\u00055\u0011A\u0002:f[>$X-\u0003\u0003\u0002H\u0005\u0005#\u0001\u0005%fCJ$(-Z1u\u001b\u0016\u001c8/Y4f!\u0011\tY%!\u0015\u000e\u0005\u00055#\u0002BA(\u0003\u001b\tQ!Y2u_JLA!a\u0015\u0002N\t)B)Z1e\u0019\u0016$H/\u001a:TkB\u0004(/Z:tS>t\u0007\u0003BA\u0012\u0003/JA!!\u0017\u0002&\t9\u0001K]8ek\u000e$\b\u0003BA/\u0003[rA!a\u0018\u0002j9!\u0011\u0011MA4\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005=\u0012A\u0002\u001fs_>$h(\u0003\u0002\u0002(%!\u00111NA\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001c\u0002r\ta1+\u001a:jC2L'0\u00192mK*!\u00111NA\u0013\u0003\u00111'o\\7\u0016\u0005\u0005]\u0004\u0003BA&\u0003sJA!a\u001f\u0002N\t9\u0011\t\u001a3sKN\u001c\u0018!\u00024s_6\u0004\u0013AC:fcV,gnY3OeV\u0011\u00111\u0011\t\u0005\u0003G\t))\u0003\u0003\u0002\b\u0006\u0015\"\u0001\u0002'p]\u001e\f1b]3rk\u0016t7-\u001a(sA\u0005\t2M]3bi&|g\u000eV5nK:\u000bgn\\:\u0002%\r\u0014X-\u0019;j_:$\u0016.\\3OC:|7\u000f\t\u000b\t\u0003#\u000b)*a&\u0002\u001aB\u0019\u00111S\u0002\u000e\u0003\u0005Aq!a\u001d\u000b\u0001\u0004\t9\bC\u0004\u0002\u0000)\u0001\r!a!\t\u000f\u0005-%\u00021\u0001\u0002\u0004\u0006!1m\u001c9z)!\t\t*a(\u0002\"\u0006\r\u0006\"CA:\u0017A\u0005\t\u0019AA<\u0011%\tyh\u0003I\u0001\u0002\u0004\t\u0019\tC\u0005\u0002\f.\u0001\n\u00111\u0001\u0002\u0004\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAUU\u0011\t9(a+,\u0005\u00055\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\nk:\u001c\u0007.Z2lK\u0012TA!a.\u0002&\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0016\u0011\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0003TC!a!\u0002,\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017\u0001\u00027b]\u001eT!!a5\u0002\t)\fg/Y\u0005\u0005\u0003/\fiM\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\u0004B!a\t\u0002`&!\u0011\u0011]A\u0013\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9/!<\u0011\t\u0005\r\u0012\u0011^\u0005\u0005\u0003W\f)CA\u0002B]fD\u0011\"a<\u0012\u0003\u0003\u0005\r!!8\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0010\u0005\u0004\u0002x\u0006u\u0018q]\u0007\u0003\u0003sTA!a?\u0002&\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0018\u0011 \u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0006\t-\u0001\u0003BA\u0012\u0005\u000fIAA!\u0003\u0002&\t9!i\\8mK\u0006t\u0007\"CAx'\u0005\u0005\t\u0019AAt\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005%'\u0011\u0003\u0005\n\u0003_$\u0012\u0011!a\u0001\u0003;\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003;\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0013\fa!Z9vC2\u001cH\u0003\u0002B\u0003\u0005?A\u0011\"a<\u0018\u0003\u0003\u0005\r!a:\u0002\u0013!+\u0017M\u001d;cK\u0006$\bcAAJ3M)\u0011Da\n\u00034Aa!\u0011\u0006B\u0018\u0003o\n\u0019)a!\u0002\u00126\u0011!1\u0006\u0006\u0005\u0005[\t)#A\u0004sk:$\u0018.\\3\n\t\tE\"1\u0006\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\u001b\u0005wi!Aa\u000e\u000b\t\te\u0012\u0011[\u0001\u0003S>LA!a\u001c\u00038Q\u0011!1E\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003#\u0013\u0019E!\u0012\u0003H!9\u00111\u000f\u000fA\u0002\u0005]\u0004bBA@9\u0001\u0007\u00111\u0011\u0005\b\u0003\u0017c\u0002\u0019AAB\u0003\u001d)h.\u00199qYf$BA!\u0014\u0003ZA1\u00111\u0005B(\u0005'JAA!\u0015\u0002&\t1q\n\u001d;j_:\u0004\"\"a\t\u0003V\u0005]\u00141QAB\u0013\u0011\u00119&!\n\u0003\rQ+\b\u000f\\34\u0011%\u0011Y&HA\u0001\u0002\u0004\t\t*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0019\u0011\t\u0005-'1M\u0005\u0005\u0005K\niM\u0001\u0004PE*,7\r\u001e\u0002\r\u0011\u0016\f'\u000f\u001e2fCR\u00146\u000f]\n\u000e?\u0005\u0005\u0012qGA\u001f\u0003\u0013\n)&a\u0017\u0016\u0005\t5\u0004\u0003BA\u000e\u0005_JAA!\u001d\u0002\n\tiQK\\5rk\u0016\fE\r\u001a:fgN$\u0002B!\u001e\u0003x\te$1\u0010\t\u0004\u0003'{\u0002bBA:M\u0001\u0007!Q\u000e\u0005\b\u0003\u007f2\u0003\u0019AAB\u0011\u001d\tYI\na\u0001\u0003\u0007#\u0002B!\u001e\u0003\u0000\t\u0005%1\u0011\u0005\n\u0003g:\u0003\u0013!a\u0001\u0005[B\u0011\"a (!\u0003\u0005\r!a!\t\u0013\u0005-u\u0005%AA\u0002\u0005\rUC\u0001BDU\u0011\u0011i'a+\u0015\t\u0005\u001d(1\u0012\u0005\n\u0003_l\u0013\u0011!a\u0001\u0003;$BA!\u0002\u0003\u0010\"I\u0011q^\u0018\u0002\u0002\u0003\u0007\u0011q\u001d\u000b\u0005\u0003\u0013\u0014\u0019\nC\u0005\u0002pB\n\t\u00111\u0001\u0002^R!!Q\u0001BL\u0011%\tyoMA\u0001\u0002\u0004\t9/\u0001\u0007IK\u0006\u0014HOY3biJ\u001b\b\u000fE\u0002\u0002\u0014V\u001aR!\u000eBP\u0005g\u0001BB!\u000b\u00030\t5\u00141QAB\u0005k\"\"Aa'\u0015\u0011\tU$Q\u0015BT\u0005SCq!a\u001d9\u0001\u0004\u0011i\u0007C\u0004\u0002\u0000a\u0002\r!a!\t\u000f\u0005-\u0005\b1\u0001\u0002\u0004R!!Q\u0016BY!\u0019\t\u0019Ca\u0014\u00030BQ\u00111\u0005B+\u0005[\n\u0019)a!\t\u0013\tm\u0013(!AA\u0002\tU\u0014!\u0004%fCJ$(-Z1u)&\u001c7\u000eE\u0002\u0002\u0014r\u0012Q\u0002S3beR\u0014W-\u0019;US\u000e\\7c\u0002\u001f\u0002\"\u0005U\u00131\f\u000b\u0003\u0005k#B!a:\u0003@\"I\u0011q\u001e!\u0002\u0002\u0003\u0007\u0011Q\u001c\u000b\u0005\u0005\u000b\u0011\u0019\rC\u0005\u0002p\n\u000b\t\u00111\u0001\u0002h\n1R\t\u001f9fGR,GMR5sgRDU-\u0019:uE\u0016\fGoE\u0004G\u0003C\t)&a\u0017\u0015\t\t-'Q\u001a\t\u0004\u0003'3\u0005bBA:\u0013\u0002\u0007!Q\u000e\u000b\u0005\u0005\u0017\u0014\t\u000eC\u0005\u0002t)\u0003\n\u00111\u0001\u0003nQ!\u0011q\u001dBk\u0011%\tyOTA\u0001\u0002\u0004\ti\u000e\u0006\u0003\u0003\u0006\te\u0007\"CAx!\u0006\u0005\t\u0019AAt)\u0011\tIM!8\t\u0013\u0005=\u0018+!AA\u0002\u0005uG\u0003\u0002B\u0003\u0005CD\u0011\"a<U\u0003\u0003\u0005\r!a:\u0002-\u0015C\b/Z2uK\u00124\u0015N]:u\u0011\u0016\f'\u000f\u001e2fCR\u00042!a%W'\u00151&\u0011\u001eB\u001a!!\u0011ICa;\u0003n\t-\u0017\u0002\u0002Bw\u0005W\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011)\u000f\u0006\u0003\u0003L\nM\bbBA:3\u0002\u0007!Q\u000e\u000b\u0005\u0005o\u0014I\u0010\u0005\u0004\u0002$\t=#Q\u000e\u0005\n\u00057R\u0016\u0011!a\u0001\u0005\u0017\u001cR\u0001XA\u0011\u0005{\u0004B!a\u0013\u0003\u0000&!1\u0011AA'\u0005\u0015\t5\r^8s)\t\u0019)\u0001E\u0002\u0002\u001cq+\"a!\u0003\u0011\t\u0005m11B\u0005\u0005\u0007\u001b\tIAA\u0004DYV\u001cH/\u001a:\u0002\u0011\rdWo\u001d;fe\u0002\n\u0001C^3sE>\u001cX\rS3beR\u0014W-\u0019;\u0016\u0005\t\u0015\u0011!\u0005<fe\n|7/\u001a%fCJ$(-Z1uA\u0005i1\r\\;ti\u0016\u0014Hj\\4hKJ,\"aa\u0007\u0011\t\ru1\u0011\u0005\b\u0004\u0007?qV\"\u0001/\n\t\r\r21\u0002\u0002\u000e\u00072,8\u000f^3s\u0019><w-\u001a:\u0002\u001d\rdWo\u001d;fe2{wmZ3sA\u0005ab-\u001b7uKJLe\u000e^3s]\u0006d7\t\\;ti\u0016\u0014X*Z7cKJ\u001cXCAB\u0016!!\t\u0019c!\f\u00042\t\u0015\u0011\u0002BB\u0018\u0003K\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005m11G\u0005\u0005\u0007k\tIA\u0001\u0004NK6\u0014WM]\u0001\u001eM&dG/\u001a:J]R,'O\\1m\u00072,8\u000f^3s\u001b\u0016l'-\u001a:tA\u0005q1/Z9vK:\u001cWM\u0014:`I\u0015\fH\u0003BB\u001f\u0007\u0007\u0002B!a\t\u0004@%!1\u0011IA\u0013\u0005\u0011)f.\u001b;\t\u0013\u0005=x-!AA\u0002\u0005u\u0017!D:fY\u001aDU-\u0019:uE\u0016\fG\u000f\u0006\u0002\u0004JA\u001911J\u0002\u000f\u0007\u0005m\u0001!A\bgC&dWO]3EKR,7\r^8s+\t\u0019\t\u0006\u0005\u0004\u0002@\rM\u0013qO\u0005\u0005\u0007+\n\tEA\fGC&dWO]3EKR,7\r^8s%\u0016<\u0017n\u001d;ss\u0006\u0001b-Y5mkJ,G)\u001a;fGR|'\u000fI\u0001\u0006gR\fG/Z\u000b\u0003\u0007;\u0002B!a\u0007\u0004`%!1\u0011MA\u0005\u0005m\u0019E.^:uKJDU-\u0019:uE\u0016\fGoU3oI\u0016\u00148\u000b^1uK\u0006I1\u000f^1uK~#S-\u001d\u000b\u0005\u0007{\u00199\u0007C\u0005\u0002p6\f\t\u00111\u0001\u0004^\u000511\u000f^1uK\u0002\nQ\u0002[3beR\u0014W-\u0019;UCN\\WCAB8!\u0011\tYe!\u001d\n\t\rM\u0014Q\n\u0002\f\u0007\u0006t7-\u001a7mC\ndW-\u0001\biK\u0006\u0014HOY3biR\u000b7o\u001b\u0011\u0002\u001bQL7m\u001b+j[\u0016\u001cH/Y7q\u0003E!\u0018nY6US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0007{\u0019i\bC\u0005\u0002pJ\f\t\u00111\u0001\u0002\u0004\u0006qA/[2l)&lWm\u001d;b[B\u0004\u0013\u0001\u00039sKN#\u0018M\u001d;\u0015\u0005\ru\u0012\u0001\u00039pgR\u001cFo\u001c9\u0002#!,\u0017M\u001d;cK\u0006$(+Z2fSZ,'\u000f\u0006\u0003\u0004\f\u000eE\u0005\u0003BA&\u0007\u001bKAaa$\u0002N\tq\u0011i\u0019;peN+G.Z2uS>t\u0007bBBJm\u0002\u0007\u0011qO\u0001\bC\u0012$'/Z:t\u0003\u001d\u0011XmY3jm\u0016,\"a!'\u0011\t\rm5\u0011\u0015\b\u0005\u0003\u0017\u001ai*\u0003\u0003\u0004 \u00065\u0013!B!di>\u0014\u0018\u0002BBR\u0007K\u0013qAU3dK&4XM\u0003\u0003\u0004 \u00065\u0013\u0001D5oSRL\u0017\r\\5{S:<\u0017AB1di&4X-\u0001\u0003j]&$H\u0003BB\u001f\u0007_Cqa!-{\u0001\u0004\u0019\u0019,\u0001\u0005t]\u0006\u00048\u000f[8u!\u0011\u0019)l!2\u000f\t\r]6\u0011\u0019\b\u0005\u0007s\u001byL\u0004\u0003\u0004<\u000euVBAA\t\u0013\u0011\ty!!\u0005\n\t\u0005-\u0011QB\u0005\u0005\u0007\u0007\fI!\u0001\u0007DYV\u001cH/\u001a:Fm\u0016tG/\u0003\u0003\u0004H\u000e%'aE\"veJ,g\u000e^\"mkN$XM]*uCR,'\u0002BBb\u0003\u0013\t\u0011\"\u00193e\u001b\u0016l'-\u001a:\u0015\t\ru2q\u001a\u0005\b\u0007#\\\b\u0019AB\u0019\u0003\u0005i\u0017\u0001\u0004:f[>4X-T3nE\u0016\u0014H\u0003BB\u001f\u0007/Dqa!5}\u0001\u0004\u0019\t$A\tv]J,\u0017m\u00195bE2,W*Z7cKJ$Ba!\u0010\u0004^\"91\u0011[?A\u0002\rE\u0012a\u0004:fC\u000eD\u0017M\u00197f\u001b\u0016l'-\u001a:\u0015\t\ru21\u001d\u0005\b\u0007#t\b\u0019AB\u0019\u0003%AW-\u0019:uE\u0016\fG/A\tdQ\u0016\u001c7\u000eV5dW&sG/\u001a:wC2\fA\u0002[3beR\u0014W-\u0019;SgB$Ba!\u0010\u0004n\"A1q^A\u0002\u0001\u0004\u0019\t0\u0001\u0005sKN\u0004xN\\:f!\r\u0019YeH\u0001\u0016iJLwmZ3s\r&\u00148\u000f\u001e%fCJ$(-Z1u)\u0011\u0019ida>\t\u0011\u0005M\u0014Q\u0001a\u0001\u0005[\u0002")
public class ClusterHeartbeatSender
implements Actor {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private final Function1<Member, Object> filterInternalClusterMembers;
    private int sequenceNr;
    private final FailureDetectorRegistry<Address> failureDetector;
    private ClusterHeartbeatSenderState state;
    private final Cancellable heartbeatTask;
    private long org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp;
    private ActorContext context;
    private ActorRef self;

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    private Cluster.ClusterLogger clusterLogger() {
        return this.clusterLogger;
    }

    public Function1<Member, Object> filterInternalClusterMembers() {
        return this.filterInternalClusterMembers;
    }

    public int sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(int x$1) {
        this.sequenceNr = x$1;
    }

    public Heartbeat selfHeartbeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1);
        return new Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public ClusterHeartbeatSenderState state() {
        return this.state;
    }

    public void state_$eq(ClusterHeartbeatSenderState x$1) {
        this.state = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    private long tickTimestamp() {
        return this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp;
    }

    public void org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(long x$1) {
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp = x$1;
    }

    @Override
    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    @Override
    public void postStop() {
        this.state().activeReceivers().foreach((Function1 & Serializable)a -> {
            ClusterHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return this.initializing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    this.$outer.context().become(this.$outer.active());
                    return (B1)BoxedUnit.UNIT;
                }
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(System.nanoTime());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    return true;
                }
                return ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof HeartbeatRsp) {
                    HeartbeatRsp heartbeatRsp = (HeartbeatRsp)A1;
                    this.$outer.heartbeatRsp(heartbeatRsp);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m3 = memberRemoved.member();
                    this.$outer.removeMember(m3);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m4 = unreachableMember.member();
                    this.$outer.unreachableMember(m4);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m5 = reachableMember.member();
                    this.$outer.reachableMember(m5);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ExpectedFirstHeartbeat) {
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof HeartbeatRsp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    return true;
                }
                return object instanceof ExpectedFirstHeartbeat;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet nodes2 = (SortedSet)snapshot.members().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1))) {
                    return (B1)A1.uniqueAddress();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Set unreachable = (Set)snapshot.unreachable().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1))) {
                    return (B1)A1.uniqueAddress();
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Member x2) {
                Member member = x2;
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.state_$eq(this.state().init((Set<UniqueAddress>)nodes2, (Set<UniqueAddress>)unreachable));
    }

    public void addMember(Member m3) {
        UniqueAddress uniqueAddress = m3.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if ((uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) && !this.state().contains(m3.uniqueAddress()) && BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m3))) {
            this.state_$eq(this.state().addMember(m3.uniqueAddress()));
            return;
        }
    }

    public void removeMember(Member m3) {
        if (BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m3))) {
            UniqueAddress uniqueAddress = m3.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
                return;
            }
            this.state_$eq(this.state().removeMember(m3.uniqueAddress()));
            return;
        }
    }

    public void unreachableMember(Member m3) {
        this.state_$eq(this.state().unreachableMember(m3.uniqueAddress()));
    }

    public void reachableMember(Member m3) {
        this.state_$eq(this.state().reachableMember(m3.uniqueAddress()));
    }

    public void heartbeat() {
        Heartbeat nextHB = this.selfHeartbeat();
        this.state().activeReceivers().foreach((Function1 & Serializable)to -> {
            ClusterHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
        this.checkTickInterval();
    }

    private void checkTickInterval() {
        long now = System.nanoTime();
        if (now - this.tickTimestamp() >= this.cluster().settings().HeartbeatInterval().toNanos() * 2L) {
            this.clusterLogger().logWarning(ClusterLogMarker$.MODULE$.heartbeatStarvation(), "Scheduled sending of heartbeat was delayed. Previous heartbeat was sent [{}] ms ago, expected interval is [{}] ms. This may cause failure detection to mark members as unreachable. The reason can be thread starvation, CPU overload, or GC.", (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(now - this.tickTimestamp())), (Object)BoxesRunTime.boxToLong((long)this.cluster().settings().HeartbeatInterval().toMillis()));
        }
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(now);
    }

    public void heartbeatRsp(HeartbeatRsp response) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("Heartbeat response from [{}]", response.from().address());
        }
        this.state_$eq(this.state().heartbeatRsp(response.from()));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        if (this.state().activeReceivers().apply((Object)from) && !this.failureDetector().isMonitoring(from.address())) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logDebug("Trigger extra expected heartbeat from [{}]", from.address());
            }
            this.failureDetector().heartbeat(from.address());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$filterInternalClusterMembers$1(ClusterHeartbeatSender $this, Member x$1) {
        String string = x$1.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(ClusterHeartbeatSender $this, UniqueAddress a) {
        $this.failureDetector().remove(a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(ClusterHeartbeatSender $this, Heartbeat nextHB$1, UniqueAddress to) {
        Object object;
        if ($this.failureDetector().isMonitoring(to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("Heartbeat to [{}]", to.address());
            }
            object = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("First Heartbeat to [{}]", to.address());
            }
            object = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang(nextHB$1, $this.self());
    }

    public ClusterHeartbeatSender() {
        Actor.$init$(this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), new ActorWithLogClass(this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.filterInternalClusterMembers = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterHeartbeatSender.$anonfun$filterInternalClusterMembers$1(this, x$1));
        this.sequenceNr = 0;
        this.failureDetector = this.cluster().failureDetector();
        this.state = new ClusterHeartbeatSenderState(new HeartbeatNodeRing(this.cluster().selfUniqueAddress(), (Set<UniqueAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.cluster().selfUniqueAddress()}))), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.cluster().settings().MonitoredByNrOfMembers()), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.failureDetector());
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime() + this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()).toNanos();
        Statics.releaseFence();
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    Serializable {
        private final UniqueAddress from;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UniqueAddress from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(UniqueAddress from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.from();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpectedFirstHeartbeat;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "from";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = expectedFirstHeartbeat.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public ExpectedFirstHeartbeat(UniqueAddress from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class Heartbeat
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final Address from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Address from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public Heartbeat copy(Address from, long sequenceNr, long creationTimeNanos) {
            return new Heartbeat(from, sequenceNr, creationTimeNanos);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "Heartbeat";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.from();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.sequenceNr());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Heartbeat;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "from";
                }
                case 1: {
                    return "sequenceNr";
                }
                case 2: {
                    return "creationTimeNanos";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Heartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            Heartbeat heartbeat = (Heartbeat)x$1;
            if (this.sequenceNr() != heartbeat.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeat.creationTimeNanos()) return false;
            Address address = this.from();
            Address address2 = heartbeat.from();
            if (address != null) {
                if (!((Object)address).equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public Heartbeat(Address from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }

    public static final class HeartbeatRsp
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final UniqueAddress from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UniqueAddress from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public HeartbeatRsp copy(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            return new HeartbeatRsp(from, sequenceNr, creationTimeNanos);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.from();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.sequenceNr());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HeartbeatRsp;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "from";
                }
                case 1: {
                    return "sequenceNr";
                }
                case 2: {
                    return "creationTimeNanos";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HeartbeatRsp)) return false;
            boolean bl = true;
            if (!bl) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)x$1;
            if (this.sequenceNr() != heartbeatRsp.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeatRsp.creationTimeNanos()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = heartbeatRsp.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public HeartbeatRsp(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }
}

