/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Index {
    private String type;
    private String using;
    private List<ColumnParams> columns;
    private final List<String> name = new ArrayList<String>();
    private List<String> idxSpec;

    public List<String> getColumnsNames() {
        return this.columns.stream().map(col -> col.columnName).collect(Collectors.toList());
    }

    @Deprecated
    public List<ColumnParams> getColumnWithParams() {
        return this.getColumns();
    }

    @Deprecated
    public void setColumnNamesWithParams(List<ColumnParams> list) {
        this.setColumns(list);
    }

    public List<ColumnParams> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnParams> columns) {
        this.columns = columns;
    }

    public Index withColumns(List<ColumnParams> columns) {
        this.setColumns(columns);
        return this;
    }

    public Index addColumns(ColumnParams ... functionDeclarationParts) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, functionDeclarationParts);
        return this.withColumns(collection);
    }

    public Index addColumns(Collection<? extends ColumnParams> functionDeclarationParts) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(functionDeclarationParts);
        return this.withColumns(collection);
    }

    public String getName() {
        return this.name.isEmpty() ? null : String.join((CharSequence)".", this.name);
    }

    public List<String> getNameParts() {
        return Collections.unmodifiableList(this.name);
    }

    public String getType() {
        return this.type;
    }

    public void setUsing(String using2) {
        this.using = using2;
    }

    public void setColumnsNames(List<String> list) {
        this.columns = list.stream().map(ColumnParams::new).collect(Collectors.toList());
    }

    public Index withColumnsNames(List<String> list) {
        this.setColumnsNames(list);
        return this;
    }

    public void setName(String name) {
        this.name.clear();
        this.name.add(name);
    }

    public void setName(List<String> name) {
        this.name.clear();
        this.name.addAll(name);
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getUsing() {
        return this.using;
    }

    public List<String> getIndexSpec() {
        return this.idxSpec;
    }

    public void setIndexSpec(List<String> idxSpec) {
        this.idxSpec = idxSpec;
    }

    public Index withIndexSpec(List<String> idxSpec) {
        this.setIndexSpec(idxSpec);
        return this;
    }

    public String toString() {
        String idxSpecText = PlainSelect.getStringList(this.idxSpec, false, false);
        return this.type + (!this.name.isEmpty() ? " " + this.getName() : "") + " " + PlainSelect.getStringList(this.columns, true, true) + (!"".equals(idxSpecText) ? " " + idxSpecText : "");
    }

    public Index withType(String type) {
        this.setType(type);
        return this;
    }

    public Index withUsing(String using2) {
        this.setUsing(using2);
        return this;
    }

    public Index withName(List<String> name) {
        this.setName(name);
        return this;
    }

    public Index withName(String name) {
        this.setName(name);
        return this;
    }

    public static class ColumnParams {
        public final String columnName;
        public final List<String> params;

        public ColumnParams(String columnName) {
            this.columnName = columnName;
            this.params = null;
        }

        public ColumnParams(String columnName, List<String> params) {
            this.columnName = columnName;
            this.params = params;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public List<String> getParams() {
            return this.params;
        }

        public String toString() {
            return this.columnName + (this.params != null ? " " + String.join((CharSequence)" ", this.params) : "");
        }
    }
}

