/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.log;

import java.util.function.Supplier;
import kanela.agent.bootstrap.log.LoggerHandler;
import kanela.agent.bootstrap.log.LoggerProvider;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.org.pmw.tinylog.Configurator;
import kanela.agent.libs.org.pmw.tinylog.labelers.TimestampLabeler;
import kanela.agent.libs.org.pmw.tinylog.policies.SizePolicy;
import kanela.agent.libs.org.pmw.tinylog.policies.StartupPolicy;
import kanela.agent.libs.org.pmw.tinylog.writers.RollingFileWriter;
import kanela.agent.util.conf.KanelaConfiguration;

public class Logger {
    public static void configureLogger(KanelaConfiguration config) {
        Try.run(() -> {
            Configurator configurator2 = Configurator.fromResource("kanela-log.properties").maxStackTraceElements(400).level(config.getLogLevel());
            if (config.isDebugMode()) {
                configurator2.addWriter(new RollingFileWriter("kanela-agent.log", 2, true, new TimestampLabeler(), new StartupPolicy(), new SizePolicy(10240L)));
            }
            configurator2.activate();
        }).andThen(() -> LoggerHandler.setLoggerProvider(new LoggerProvider(){

            @Override
            public void error(String msg, Throwable t) {
                Logger.error(() -> msg, t);
            }

            @Override
            public void info(String msg) {
                Logger.info(() -> msg);
            }
        })).getOrElseThrow(error -> new RuntimeException("Error when trying to load configuration: " + error.getMessage()));
    }

    private Logger() {
    }

    public static void debug(Supplier<String> msg) {
        kanela.agent.libs.org.pmw.tinylog.Logger.debug(msg.get());
    }

    public static void trace(Supplier<String> msg) {
        kanela.agent.libs.org.pmw.tinylog.Logger.trace(msg.get());
    }

    public static void info(Supplier<String> msg) {
        kanela.agent.libs.org.pmw.tinylog.Logger.info(msg.get());
    }

    public static void info(Supplier<String> msg, Throwable t) {
        kanela.agent.libs.org.pmw.tinylog.Logger.info(t, msg.get());
    }

    public static void warn(Supplier<String> msg) {
        kanela.agent.libs.org.pmw.tinylog.Logger.warn(msg.get());
    }

    public static void warn(Supplier<String> msg, Throwable t) {
        kanela.agent.libs.org.pmw.tinylog.Logger.warn(t, msg.get());
    }

    public static void error(Supplier<String> msg) {
        kanela.agent.libs.org.pmw.tinylog.Logger.error(msg.get());
    }

    public static void error(Supplier<String> msg, Throwable t) {
        kanela.agent.libs.org.pmw.tinylog.Logger.error(t, msg.get());
    }

    static {
        Logger.configureLogger(KanelaConfiguration.instance());
    }
}

