/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.Map;

public final class GcEvent {
    static final long ONE_KIBIBYTE = 1024L;
    static final long ONE_MEBIBYTE = 0x100000L;
    static final long ONE_GIBIBYTE = 0x40000000L;
    private final GarbageCollectionNotificationInfo info;
    private final double percentageFreeMemoryAfterGc;
    private final long startTime;

    public String toString() {
        GcInfo gcInfo = this.info.getGcInfo();
        long totalBefore = GcEvent.getTotalUsage(gcInfo.getMemoryUsageBeforeGc());
        long totalAfter = GcEvent.getTotalUsage(gcInfo.getMemoryUsageAfterGc());
        long max = GcEvent.getTotalMaxUsage(gcInfo.getMemoryUsageAfterGc());
        String name = this.info.getGcName();
        String unit = "KiB";
        double cnv = 1024.0;
        if (max > 0x40000000L) {
            unit = "GiB";
            cnv = 1.073741824E9;
        } else if (max > 0x100000L) {
            unit = "MiB";
            cnv = 1048576.0;
        }
        Date d = new Date(this.startTime);
        String change = String.format("%.1f%s => %.1f%s / %.1f%s", (double)totalBefore / cnv, unit, (double)totalAfter / cnv, unit, (double)max / cnv, unit);
        String percentChange = String.format("%.1f%% => %.1f%%", 100.0 * (double)totalBefore / (double)max, 100.0 * (double)totalAfter / (double)max);
        return "OLD: " + name + ", id=" + gcInfo.getId() + ", at=" + d.toString() + ", duration=" + gcInfo.getDuration() + "ms, cause=[" + this.info.getGcCause() + "], " + change + " (" + percentChange + ")";
    }

    private static long getTotalUsage(Map<String, MemoryUsage> usages) {
        long sum = 0L;
        for (Map.Entry<String, MemoryUsage> e : usages.entrySet()) {
            sum += e.getValue().getUsed();
        }
        return sum;
    }

    private static long getTotalMaxUsage(Map<String, MemoryUsage> usages) {
        long sum = 0L;
        for (Map.Entry<String, MemoryUsage> e : usages.entrySet()) {
            long max = e.getValue().getMax();
            if (max <= 0L) continue;
            sum += e.getValue().getMax();
        }
        return sum;
    }

    private GcEvent(GarbageCollectionNotificationInfo info, double percentageFreeMemoryAfterGc, long startTime) {
        this.info = info;
        this.percentageFreeMemoryAfterGc = percentageFreeMemoryAfterGc;
        this.startTime = startTime;
    }

    public static GcEvent from(GarbageCollectionNotificationInfo info, double percentageFreeMemoryAfterGc, long startTime) {
        return new GcEvent(info, percentageFreeMemoryAfterGc, startTime);
    }

    public GarbageCollectionNotificationInfo getInfo() {
        return this.info;
    }

    public double getPercentageFreeMemoryAfterGc() {
        return this.percentageFreeMemoryAfterGc;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GcEvent)) {
            return false;
        }
        GcEvent other = (GcEvent)o;
        if (Double.compare(this.getPercentageFreeMemoryAfterGc(), other.getPercentageFreeMemoryAfterGc()) != 0) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        GarbageCollectionNotificationInfo this$info = this.getInfo();
        GarbageCollectionNotificationInfo other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !this$info.equals(other$info));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $percentageFreeMemoryAfterGc = Double.doubleToLongBits(this.getPercentageFreeMemoryAfterGc());
        result = result * 59 + (int)($percentageFreeMemoryAfterGc >>> 32 ^ $percentageFreeMemoryAfterGc);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        GarbageCollectionNotificationInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        return result;
    }
}

