/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;

public class ScalaCompilerClassLoaderMatcher
extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
    private static Map<ClassLoader, Boolean> knownClassLoaders = new ConcurrentHashMap<ClassLoader, Boolean>();

    @Override
    public boolean matches(ClassLoader classLoader) {
        return ScalaCompilerClassLoaderMatcher.isScalaCompilerClassLoader(classLoader);
    }

    public static boolean isScalaCompilerClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            boolean hasLessThanSixJars;
            Boolean isScalaCompilerLoader = knownClassLoaders.get(classLoader);
            if (isScalaCompilerLoader != null) {
                return isScalaCompilerLoader;
            }
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            boolean foundScalaCompiler = false;
            boolean foundJLine = false;
            boolean bl = hasLessThanSixJars = urlClassLoader.getURLs().length < 6;
            if (hasLessThanSixJars) {
                for (URL url : urlClassLoader.getURLs()) {
                    if (url.getFile().contains("scala-compiler")) {
                        foundScalaCompiler = true;
                    }
                    if (!url.getFile().contains("jline")) continue;
                    foundJLine = true;
                }
            }
            boolean isScalaCompiler = hasLessThanSixJars && foundScalaCompiler && foundJLine;
            knownClassLoaders.put(classLoader, isScalaCompiler);
            return isScalaCompiler;
        }
        return false;
    }
}

