/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.classloader;

import java.util.ArrayList;
import java.util.List;
import kanela.agent.libs.com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.util.log.Logger;

public final class PreInitializeClasses {
    public static volatile Object toPreventDeadCodeElimination;

    public static void preInitializeClasses(ClassLoader loader) {
        for (String type : PreInitializeClasses.usedTypes()) {
            PreInitializeClasses.initialize(type, loader);
        }
        PreInitializeClasses.preExpiryMapKeySetAndKeySetIterator();
    }

    private static void initialize(String type, ClassLoader loader) {
        Try.of(() -> Class.forName(type, true, loader)).onFailure(cause -> Logger.warn(() -> "class not found: " + type, cause));
    }

    public static List<String> usedTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(PreInitializeClasses.getJavaUsedTypes());
        types.addAll(PreInitializeClasses.getBytebuddyUsedTypes());
        return types;
    }

    private static String prependByteBuddyPrefix(String s2) {
        return "kanela.agent.libs.net.bytebuddy." + s2;
    }

    private static List<String> getJavaUsedTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("java.util.concurrent.locks.LockSupport");
        types.add("java.util.concurrent.ThreadLocalRandom");
        types.add("java.util.concurrent.locks.AbstractQueuedSynchronizer$Node");
        return types;
    }

    private static List<String> getBytebuddyUsedTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(PreInitializeClasses.prependByteBuddyPrefix("agent.builder.ResettableClassFileTransformer"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("agent.ByteBuddyAgent"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("asm.Advice"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("asm.AsmVisitorWrapper"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("ByteBuddy"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("ClassFileVersion"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("description.ByteCodeElement"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("description.field.FieldDescription"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("description.field.FieldList"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("description.method.MethodDescription"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("description.method.MethodList"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("description.NamedElement"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("description.type.TypeDescription"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("dynamic.ClassFileLocator"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("dynamic.DynamicType"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("dynamic.loading.ClassInjector"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("dynamic.scaffold.MethodGraph"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("dynamic.scaffold.TypeValidation"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("implementation.bytecode.StackManipulation"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("implementation.Implementation"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("implementation.MethodDelegation"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.ClassReader"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.ClassVisitor"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.ClassWriter"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.commons.AdviceAdapter"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.commons.ClassRemapper"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.commons.Method"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.commons.MethodRemapper"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.commons.SimpleRemapper"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.Label"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.MethodVisitor"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.Opcodes"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.tree.ClassNode"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.tree.MethodNode"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("jar.asm.Type"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("matcher.ElementMatcher"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("matcher.ElementMatchers"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("pool.TypePool"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("utility.JavaModule"));
        types.add(PreInitializeClasses.prependByteBuddyPrefix("utility.OpenedClassReader"));
        return types;
    }

    private static void preExpiryMapKeySetAndKeySetIterator() {
        toPreventDeadCodeElimination = new WeakConcurrentMap(false).iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof PreInitializeClasses;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PreInitializeClasses()";
    }
}

