/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog.policies;

import java.util.Calendar;
import java.util.regex.Pattern;
import kanela.agent.libs.org.pmw.tinylog.policies.AbstractTimeBasedPolicy;
import kanela.agent.libs.org.pmw.tinylog.policies.PropertiesSupport;

@PropertiesSupport(name="yearly")
public final class YearlyPolicy
extends AbstractTimeBasedPolicy {
    private static final Pattern MONTH_NUMBER_PATTERN = Pattern.compile("[123456789]|10|11|12");

    public YearlyPolicy() {
        super(YearlyPolicy.createCalendar(1), 1);
    }

    public YearlyPolicy(int n) {
        super(YearlyPolicy.createCalendar(n), 1);
    }

    public YearlyPolicy(String string) {
        this(YearlyPolicy.convert(string));
    }

    private static Calendar createCalendar(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("month must be between 1..12");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(2, n - 1);
        YearlyPolicy.normalize(calendar, 1);
        return calendar;
    }

    private static int convert(String string) {
        if ("January".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("February".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("March".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("April".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("May".equalsIgnoreCase(string)) {
            return 5;
        }
        if ("June".equalsIgnoreCase(string)) {
            return 6;
        }
        if ("July".equalsIgnoreCase(string)) {
            return 7;
        }
        if ("August".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("September".equalsIgnoreCase(string)) {
            return 9;
        }
        if ("October".equalsIgnoreCase(string)) {
            return 10;
        }
        if ("November".equalsIgnoreCase(string)) {
            return 11;
        }
        if ("December".equalsIgnoreCase(string)) {
            return 12;
        }
        if (MONTH_NUMBER_PATTERN.matcher(string).matches()) {
            return Integer.parseInt(string);
        }
        throw new IllegalArgumentException("Unknown month");
    }
}

