/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kanela.agent.libs.org.pmw.tinylog.Configurator;
import kanela.agent.libs.org.pmw.tinylog.Level;
import kanela.agent.libs.org.pmw.tinylog.StackTraceInformation;
import kanela.agent.libs.org.pmw.tinylog.Token;
import kanela.agent.libs.org.pmw.tinylog.Tokenizer;
import kanela.agent.libs.org.pmw.tinylog.WriterDefinition;
import kanela.agent.libs.org.pmw.tinylog.WritingThread;
import kanela.agent.libs.org.pmw.tinylog.writers.LogEntryValue;
import kanela.agent.libs.org.pmw.tinylog.writers.Writer;

public final class Configuration {
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private static final String DEFAULT_FORMAT_PATTERN = "{date} [{thread}] {class}.{method}()\n{level}: {message}";
    private static final int DEFAULT_MAX_STACK_TRACE_ELEMENTS = 40;
    private final Configurator configurator;
    private final Level level;
    private final Level lowestLevel;
    private final Map<String, Level> customLevels;
    private final String formatPattern;
    private final Locale locale;
    private final List<Writer> writers;
    private final WritingThread writingThread;
    private final int maxStackTraceElements;
    private final Map<Level, Writer[]> effectiveWriters;
    private final Map<Level, List<Token>[]> effectiveFormatTokens;
    private final Map<Level, Set<LogEntryValue>> requiredLogEntryValues;
    private final Map<Level, StackTraceInformation> requiredStackTraceInformation;

    Configuration(Configurator configurator2, Level level, Map<String, Level> map, String string, Locale locale, List<WriterDefinition> list, WritingThread writingThread, Integer n) {
        this.configurator = configurator2;
        this.level = level == null ? Configuration.getLevel(list) : level;
        this.lowestLevel = Configuration.getLowestLevel(this.level, map, list);
        this.customLevels = map;
        this.formatPattern = string == null ? DEFAULT_FORMAT_PATTERN : string;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.writers = Configuration.getWriters(list);
        this.writingThread = writingThread;
        this.maxStackTraceElements = n == null ? 40 : n;
        this.effectiveWriters = Configuration.getEffectiveWriters(list);
        this.effectiveFormatTokens = Configuration.getEffectiveFormatTokens(list, this.formatPattern, this.locale, this.maxStackTraceElements);
        this.requiredLogEntryValues = Configuration.getRequiredLogEntryValues(this.effectiveWriters, this.effectiveFormatTokens);
        this.requiredStackTraceInformation = Configuration.getRequiredStackTraceInformation(this.requiredLogEntryValues, map);
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean hasCustomLevels() {
        return !this.customLevels.isEmpty();
    }

    public Level getLevel(String string) {
        String string2 = string;
        while (true) {
            Level level;
            if ((level = this.customLevels.get(string2)) != null) {
                return level;
            }
            int n = string2.lastIndexOf(46);
            if (n <= 0) break;
            string2 = string2.substring(0, n);
        }
        return this.level;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<Writer> getWriters() {
        return this.writers;
    }

    public WritingThread getWritingThread() {
        return this.writingThread;
    }

    public int getMaxStackTraceElements() {
        return this.maxStackTraceElements;
    }

    Configurator getConfigurator() {
        return this.configurator.copy();
    }

    boolean isOutputPossible(Level level) {
        return this.lowestLevel.ordinal() <= level.ordinal();
    }

    Writer[] getEffectiveWriters(Level level) {
        return this.effectiveWriters.get((Object)level);
    }

    List<Token>[] getEffectiveFormatTokens(Level level) {
        return this.effectiveFormatTokens.get((Object)level);
    }

    Set<LogEntryValue> getRequiredLogEntryValues(Level level) {
        return this.requiredLogEntryValues.get((Object)level);
    }

    StackTraceInformation getRequiredStackTraceInformation(Level level) {
        return this.requiredStackTraceInformation.get((Object)level);
    }

    private static Level getLevel(List<WriterDefinition> list) {
        Level level = null;
        for (WriterDefinition writerDefinition : list) {
            if (writerDefinition.getLevel() == null || level != null && writerDefinition.getLevel().ordinal() >= level.ordinal()) continue;
            level = writerDefinition.getLevel();
        }
        return level == null ? DEFAULT_LEVEL : level;
    }

    private static Level getLowestLevel(Level level, Map<String, Level> map, List<WriterDefinition> list) {
        Level object = level;
        for (Level object2 : map.values()) {
            if (object.ordinal() <= object2.ordinal()) continue;
            object = object2;
        }
        Object object3 = Level.OFF;
        for (WriterDefinition writerDefinition : list) {
            Level level2 = writerDefinition.getLevel();
            if (level2 == null) {
                level2 = object;
            }
            if (level2.ordinal() > ((Enum)object3).ordinal()) continue;
            object3 = level2;
        }
        return ((Enum)object3).ordinal() > object.ordinal() ? object3 : object;
    }

    private static List<Writer> getWriters(List<WriterDefinition> list) {
        ArrayList arrayList = new ArrayList();
        for (WriterDefinition writerDefinition : list) {
            arrayList.add(writerDefinition.getWriter());
        }
        return arrayList.isEmpty() ? Collections.emptyList() : arrayList;
    }

    private static Map<Level, Writer[]> getEffectiveWriters(List<WriterDefinition> list) {
        EnumMap<Level, Writer[]> enumMap = new EnumMap<Level, Writer[]>(Level.class);
        for (Level level : Level.values()) {
            ArrayList<Writer> arrayList = new ArrayList<Writer>();
            for (WriterDefinition writerDefinition : list) {
                Level level2 = writerDefinition.getLevel();
                if (level2 == null) {
                    level2 = Level.TRACE;
                }
                if (level.ordinal() < level2.ordinal()) continue;
                arrayList.add(writerDefinition.getWriter());
            }
            enumMap.put(level, arrayList.toArray(new Writer[arrayList.size()]));
        }
        return enumMap;
    }

    private static Map<Level, List<Token>[]> getEffectiveFormatTokens(List<WriterDefinition> list, String string, Locale locale, int n) {
        HashMap<Writer, List<Token>> hashMap = new HashMap<Writer, List<Token>>();
        Tokenizer tokenizer = new Tokenizer(locale, n);
        EnumMap<Level, List<Token>[]> enumMap = new EnumMap<Level, List<Token>[]>(Level.class);
        for (Level level : Level.values()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (WriterDefinition writerDefinition : list) {
                Level level2 = writerDefinition.getLevel();
                if (level2 == null) {
                    level2 = Level.TRACE;
                }
                if (level.ordinal() < level2.ordinal()) continue;
                Writer writer = writerDefinition.getWriter();
                if (hashMap.containsKey(writer)) {
                    arrayList.add(hashMap.get(writer));
                    continue;
                }
                Set<LogEntryValue> set = writer.getRequiredLogEntryValues();
                if (set == null || !set.contains((Object)LogEntryValue.RENDERED_LOG_ENTRY)) {
                    arrayList.add(null);
                    hashMap.put(writer, null);
                    continue;
                }
                String string2 = writerDefinition.getFormatPattern();
                if (string2 == null) {
                    string2 = string;
                }
                List<Token> list2 = tokenizer.parse(string2);
                arrayList.add(list2);
                hashMap.put(writer, list2);
            }
            enumMap.put(level, arrayList.toArray(new List[arrayList.size()]));
        }
        return enumMap;
    }

    private static Map<Level, Set<LogEntryValue>> getRequiredLogEntryValues(Map<Level, Writer[]> map, Map<Level, List<Token>[]> map2) {
        EnumMap<Level, Set<LogEntryValue>> enumMap = new EnumMap<Level, Set<LogEntryValue>>(Level.class);
        for (Map.Entry<Level, Writer[]> entry : map.entrySet()) {
            Level level = entry.getKey();
            Writer[] writerArray = entry.getValue();
            if (writerArray.length == 0) {
                enumMap.put(level, Collections.emptySet());
                continue;
            }
            List<Token>[] listArray = map2.get((Object)level);
            EnumSet<LogEntryValue> enumSet = EnumSet.noneOf(LogEntryValue.class);
            for (int i = 0; i < writerArray.length; ++i) {
                Set<LogEntryValue> set = writerArray[i].getRequiredLogEntryValues();
                if (set == null) continue;
                if (set.contains((Object)LogEntryValue.RENDERED_LOG_ENTRY)) {
                    for (Token token : listArray[i]) {
                        for (LogEntryValue logEntryValue : token.getRequiredLogEntryValues()) {
                            set.add(logEntryValue);
                        }
                    }
                }
                enumSet.addAll(set);
            }
            if (enumSet.isEmpty()) {
                enumMap.put(level, Collections.emptySet());
                continue;
            }
            enumMap.put(level, enumSet);
        }
        return enumMap;
    }

    private static Map<Level, StackTraceInformation> getRequiredStackTraceInformation(Map<Level, Set<LogEntryValue>> map, Map<String, Level> map2) {
        EnumMap<Level, StackTraceInformation> enumMap = new EnumMap<Level, StackTraceInformation>(Level.class);
        for (Map.Entry<Level, Set<LogEntryValue>> entry : map.entrySet()) {
            Level level = entry.getKey();
            Set<LogEntryValue> set = entry.getValue();
            if (set.contains((Object)LogEntryValue.METHOD) || set.contains((Object)LogEntryValue.FILE) || set.contains((Object)LogEntryValue.LINE)) {
                enumMap.put(level, StackTraceInformation.FULL);
                continue;
            }
            if (set.contains((Object)LogEntryValue.CLASS) || !map2.isEmpty()) {
                enumMap.put(level, StackTraceInformation.CLASS_NAME);
                continue;
            }
            enumMap.put(level, StackTraceInformation.NONE);
        }
        return enumMap;
    }
}

