/*
 * Decompiled with CFR 0.152.
 */
package kamon.status.page;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.ClassLoading$;
import kamon.Kamon$;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.status.page.StatusPageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\u000b\u0016\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006k\u0001!\tA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019!\u0005\u0001)A\u0005y!9Q\t\u0001a\u0001\n\u00131\u0005bB'\u0001\u0001\u0004%IA\u0014\u0005\u0007)\u0002\u0001\u000b\u0015B$\t\u000bU\u0002A\u0011A-\t\u000bi\u0003A\u0011I.\t\u000bq\u0003A\u0011I/\t\u000b)\u0004A\u0011B6\t\u000b5\u0004A\u0011\u00028\t\r\u0005-\u0001\u0001\"\u0003\\\u000f\u001d\ti!\u0006E\u0001\u0003\u001f1a\u0001F\u000b\t\u0002\u0005E\u0001BB\u001b\u0010\t\u0003\t\u0019B\u0002\u0004\u0002\u0016=\u0001\u0011q\u0003\u0005\u0007kE!\t!a\b\t\u000f\u0005\u0015\u0012\u0003\"\u0011\u0002(\tQ1\u000b^1ukN\u0004\u0016mZ3\u000b\u0005Y9\u0012\u0001\u00029bO\u0016T!\u0001G\r\u0002\rM$\u0018\r^;t\u0015\u0005Q\u0012!B6b[>t7\u0001A\n\u0004\u0001u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%O5\tQE\u0003\u0002'3\u00051Qn\u001c3vY\u0016L!\u0001K\u0013\u0003\r5{G-\u001e7f\u0003)\u0019wN\u001c4jOB\u000bG\u000f\u001b\t\u0003WIr!\u0001\f\u0019\u0011\u00055zR\"\u0001\u0018\u000b\u0005=Z\u0012A\u0002\u001fs_>$h(\u0003\u00022?\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\tt$\u0001\u0004=S:LGO\u0010\u000b\u0003oe\u0002\"\u0001\u000f\u0001\u000e\u0003UAQ!\u000b\u0002A\u0002)\nqa\u00187pO\u001e,'/F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)A\u0003tY\u001a$$NC\u0001B\u0003\ry'oZ\u0005\u0003\u0007z\u0012a\u0001T8hO\u0016\u0014\u0018\u0001C0m_\u001e<WM\u001d\u0011\u0002#}\u001bH/\u0019;vgB\u000bw-Z*feZ,'/F\u0001H!\rq\u0002JS\u0005\u0003\u0013~\u0011aa\u00149uS>t\u0007C\u0001\u001dL\u0013\taUC\u0001\tTi\u0006$Xo\u001d)bO\u0016\u001cVM\u001d<fe\u0006)rl\u001d;biV\u001c\b+Y4f'\u0016\u0014h/\u001a:`I\u0015\fHCA(S!\tq\u0002+\u0003\u0002R?\t!QK\\5u\u0011\u001d\u0019f!!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0003Iy6\u000f^1ukN\u0004\u0016mZ3TKJ4XM\u001d\u0011)\u0005\u001d1\u0006C\u0001\u0010X\u0013\tAvD\u0001\u0005w_2\fG/\u001b7f)\u00059\u0014\u0001B:u_B$\u0012aT\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0002P=\")qL\u0003a\u0001A\u0006Ia.Z<D_:4\u0017n\u001a\t\u0003C\"l\u0011A\u0019\u0006\u0003G\u0012\faaY8oM&<'BA3g\u0003!!\u0018\u0010]3tC\u001a,'\"A4\u0002\u0007\r|W.\u0003\u0002jE\n11i\u001c8gS\u001e\fA!\u001b8jiR\u0011q\n\u001c\u0005\u0006G.\u0001\r\u0001Y\u0001\fgR\f'\u000f^*feZ,'\u000f\u0006\u0004P_F4\u0018\u0011\u0001\u0005\u0006a2\u0001\rAK\u0001\tQ>\u001cHO\\1nK\")!\u000f\u0004a\u0001g\u0006!\u0001o\u001c:u!\tqB/\u0003\u0002v?\t\u0019\u0011J\u001c;\t\u000b]d\u0001\u0019\u0001=\u0002\u001dI,7o\\;sG\u0016du.\u00193feB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005Y\u0006twMC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}T(aC\"mCN\u001cHj\\1eKJDq!a\u0001\r\u0001\u0004\t)!A\tsKR\u0014\u0018p\u00148SC:$w.\u001c)peR\u00042AHA\u0004\u0013\r\tIa\b\u0002\b\u0005>|G.Z1o\u0003)\u0019Ho\u001c9TKJ4XM]\u0001\u000b'R\fG/^:QC\u001e,\u0007C\u0001\u001d\u0010'\tyQ\u0004\u0006\u0002\u0002\u0010\t9a)Y2u_JL8\u0003B\t\u001e\u00033\u00012\u0001JA\u000e\u0013\r\ti\"\n\u0002\u000e\u001b>$W\u000f\\3GC\u000e$xN]=\u0015\u0005\u0005\u0005\u0002cAA\u0012#5\tq\"\u0001\u0004de\u0016\fG/\u001a\u000b\u0004G\u0005%\u0002bBA\u0016'\u0001\u0007\u0011QF\u0001\tg\u0016$H/\u001b8hgB!\u0011qFA\u001b\u001d\r!\u0013\u0011G\u0005\u0004\u0003g)\u0013!D'pIVdWMR1di>\u0014\u00180\u0003\u0003\u00028\u0005e\"\u0001C*fiRLgnZ:\u000b\u0007\u0005MR\u0005")
public class StatusPage
implements Module {
    private final String configPath;
    private final Logger _logger;
    private volatile Option<StatusPageServer> _statusPageServer;

    private Logger _logger() {
        return this._logger;
    }

    private Option<StatusPageServer> _statusPageServer() {
        return this._statusPageServer;
    }

    private void _statusPageServer_$eq(Option<StatusPageServer> x$1) {
        this._statusPageServer = x$1;
    }

    public void stop() {
        this.stopServer();
    }

    public void reconfigure(Config newConfig) {
        this.init(newConfig.getConfig(this.configPath));
    }

    private synchronized void init(Config config) {
        String hostname = config.getString("listen.hostname");
        int port = config.getInt("listen.port");
        boolean retryOnRandomPort = config.getBoolean("listen.retry-on-random-port");
        this._statusPageServer().fold((Function0)(JFunction0.mcV.sp & Serializable)() -> this.startServer(hostname, port, ClassLoading$.MODULE$.classLoader(), retryOnRandomPort), (Function1 & Serializable)existentServer -> {
            StatusPage.$anonfun$init$2(this, hostname, port, retryOnRandomPort, existentServer);
            return BoxedUnit.UNIT;
        });
    }

    private void startServer(String hostname, int port, ClassLoader resourceLoader, boolean retryOnRandomPort) {
        block4: {
            Try try_;
            Failure failure;
            boolean bl;
            while (true) {
                bl = false;
                failure = null;
                try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    void var3_3;
                    StatusPageServer server = new StatusPageServer(hostname, port, resourceLoader, Kamon$.MODULE$.status());
                    server.start();
                    return var3_3;
                });
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    StatusPageServer server = (StatusPageServer)success.value();
                    this._logger().info(new StringBuilder(32).append("Status Page started on http://").append(hostname).append(":").append(server.getListeningPort()).append("/").toString());
                    this._statusPageServer_$eq((Option<StatusPageServer>)new Some((Object)server));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                if (!retryOnRandomPort) break;
                retryOnRandomPort = false;
                port = 0;
            }
            if (bl) {
                Throwable t = failure.exception();
                this._logger().error("Failed to start the status page embedded server", t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
        }
    }

    private void stopServer() {
        this._statusPageServer().foreach((Function1 & Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
        this._statusPageServer_$eq((Option<StatusPageServer>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$init$2(StatusPage $this, String hostname$1, int port$1, boolean retryOnRandomPort$1, StatusPageServer existentServer) {
        block0: {
            String string = existentServer.getHostname();
            String string2 = hostname$1;
            if (!(string != null ? !string.equals(string2) : string2 != null) && existentServer.getListeningPort() == port$1) break block0;
            $this.stopServer();
            $this.startServer(hostname$1, port$1, ClassLoading$.MODULE$.classLoader(), retryOnRandomPort$1);
        }
    }

    public StatusPage(String configPath) {
        this.configPath = configPath;
        this._logger = LoggerFactory.getLogger(StatusPage.class);
        this._statusPageServer = None$.MODULE$;
        this.init(Kamon$.MODULE$.config().getConfig(configPath));
    }

    public StatusPage() {
        this("kamon.status-page");
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new StatusPage();
        }
    }
}

