/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.process;

import com.sun.jna.Platform;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.process.ProcessMetrics;
import kamon.metric.Timer;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001\u0002\u001d:\u0001\tC\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0011\u0019)\u0007\u0001)A\u0005;\"9a\r\u0001b\u0001\n\u00139\u0007B\u00028\u0001A\u0003%\u0001\u000eC\u0004p\u0001\t\u0007I\u0011\u00029\t\u000f\u0005\u001d\u0001\u0001)A\u0005c\"I\u0011\u0011\u0002\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0003'\u0003\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0013\u0001C\u0002\u0013%\u0011q\u0013\u0005\t\u0005\u0007\u0001\u0001\u0015!\u0003\u0002\u001a\"9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005b\u0002B\u0003\u0001\u0011\u0005\u00131\u0012\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005K1a!!\u0005\u0001\t\u0005M\u0001B\u0002,\u0012\t\u0003\t)\u0002C\u0005\u0002\u0018E\u0011\r\u0011\"\u0003\u0002\u001a!A\u0011qE\t!\u0002\u0013\tY\u0002C\u0005\u0002*E\u0011\r\u0011\"\u0003\u0002,!A\u0011\u0011H\t!\u0002\u0013\ti\u0003C\u0005\u0002<E\u0011\r\u0011\"\u0003\u0002>!A\u0011qJ\t!\u0002\u0013\ty\u0004C\u0005\u0002RE\u0011\r\u0011\"\u0003\u0002T!A\u00111L\t!\u0002\u0013\t)\u0006C\u0005\u0002^E\u0011\r\u0011\"\u0003\u0002`!A\u0011qM\t!\u0002\u0013\t\t\u0007C\u0005\u0002jE\u0001\r\u0011\"\u0003\u0002l!I\u0011\u0011P\tA\u0002\u0013%\u00111\u0010\u0005\t\u0003\u000f\u000b\u0002\u0015)\u0003\u0002n!9\u0011\u0011R\t\u0005\u0002\u0005-\u0005bBAG#\u0011\u0005\u00111\u0012\u0005\b\u0003\u001f\u000bB\u0011BAF\u0011\u001d\t\t*\u0005C\u0005\u0003\u00173a!a'\u0001\u0005\u0005u\u0005BCASI\t\u0005\t\u0015!\u0003\u0002(\"Q\u00111\u0017\u0013\u0003\u0002\u0003\u0006I!!.\t\rY#C\u0011AAa\u0011%\t9\r\na\u0001\n\u0013\tI\rC\u0005\u0002L\u0012\u0002\r\u0011\"\u0003\u0002N\"A\u0011\u0011\u001b\u0013!B\u0013\t\u0019\bC\u0005\u0002\\\u0012\u0002\r\u0011\"\u0003\u0002^\"I\u0011Q\u001d\u0013A\u0002\u0013%\u0011q\u001d\u0005\t\u0003W$\u0003\u0015)\u0003\u0002`\"9\u0011\u0011\u0012\u0013\u0005B\u0005-\u0005bBAxI\u0011\u0005\u0011\u0011\u001f\u0005\b\u0003w$C\u0011AAF\u0011\u001d\ti\u0010\nC\u0001\u0003\u007f<qAa\n:\u0011\u0003\u0011IC\u0002\u00049s!\u0005!1\u0006\u0005\u0007-N\"\tA!\f\u0007\r\t=2\u0007\u0001B\u0019\u0011\u00191V\u0007\"\u0001\u0003:!9!qH\u001b\u0005B\t\u0005#a\u0006)s_\u000e,7o]'fiJL7m]\"pY2,7\r^8s\u0015\tQ4(A\u0004qe>\u001cWm]:\u000b\u0005qj\u0014AB:zgR,WN\u0003\u0002?\u007f\u0005y\u0011N\\:ueVlWM\u001c;bi&|gNC\u0001A\u0003\u0015Y\u0017-\\8o\u0007\u0001\u00192\u0001A\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0019\te.\u001f*fMB\u0011!*T\u0007\u0002\u0017*\u0011AjP\u0001\u0007[>$W\u000f\\3\n\u00059[%aD*dQ\u0016$W\u000f\\3e\u0003\u000e$\u0018n\u001c8\u0002\u0005\u0015\u001c\u0007CA)U\u001b\u0005\u0011&BA*F\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003+J\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\tA&\f\u0005\u0002Z\u00015\t\u0011\bC\u0003P\u0005\u0001\u0007\u0001+A\n`Q&\u001c7-\u001e9J]R,'O^1m!\u0006$\b.F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013aa\u0015;sS:<\u0017\u0001F0iS\u000e\u001cW\u000f]%oi\u0016\u0014h/\u00197QCRD\u0007%\u0001\u0007`I\u00164\u0017-\u001e7u)\u0006<7/F\u0001i!\tIG.D\u0001k\u0015\tYw(A\u0002uC\u001eL!!\u001c6\u0003\rQ\u000bwmU3u\u00035yF-\u001a4bk2$H+Y4tA\u00051r\f\u001d:pG\u0016\u001c8o\u00119v\u0013:\u001cHO];nK:$8/F\u0001r!\r\u0011\u0018\u0011\u0001\b\u0003gzt!\u0001^?\u000f\u0005UdhB\u0001<|\u001d\t9(0D\u0001y\u0015\tI\u0018)\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0011ahP\u0005\u0003yuJ!AO\u001e\n\u0005}L\u0014A\u0004)s_\u000e,7o]'fiJL7m]\u0005\u0005\u0003\u0007\t)A\u0001\nQe>\u001cWm]:J]N$(/^7f]R\u001c(BA@:\u0003]y\u0006O]8dKN\u001c8\t];J]N$(/^7f]R\u001c\b%A\b`G>dG.Z2uS>tG+Y:l+\t\ti\u0001E\u0002\u0002\u0010Ei\u0011\u0001\u0001\u0002\u0016\u001b\u0016$(/[2t\u0007>dG.Z2uS>tG+Y:l'\t\t2\t\u0006\u0002\u0002\u000e\u0005Yql]=ti\u0016l\u0017J\u001c4p+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\t\t\t#\u0001\u0003pg\"L\u0017\u0002BA\u0013\u0003?\u0011!bU=ti\u0016l\u0017J\u001c4p\u00031y6/_:uK6LeNZ8!\u0003\u0011y\u0006.\u00197\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\t\u0005M\u0012qD\u0001\tQ\u0006\u0014Hm^1sK&!\u0011qGA\u0019\u0005aA\u0015M\u001d3xCJ,\u0017IY:ue\u0006\u001cG/[8o\u0019\u0006LXM]\u0001\u0006?\"\fG\u000eI\u0001\u0004?>\u001cXCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n!a\\:\u000b\t\u0005%\u0013qD\u0001\tg>4Go^1sK&!\u0011QJA\"\u0005=y\u0005/\u001a:bi&twmU=ti\u0016l\u0017\u0001B0pg\u0002\nAa\u00189jIV\u0011\u0011Q\u000b\t\u0004\t\u0006]\u0013bAA-\u000b\n\u0019\u0011J\u001c;\u0002\u000b}\u0003\u0018\u000e\u001a\u0011\u0002\u001f}\u0003(o\\2fgN|'oQ8v]R,\"!!\u0019\u0011\u0007\u0011\u000b\u0019'C\u0002\u0002f\u0015\u0013a\u0001R8vE2,\u0017\u0001E0qe>\u001cWm]:pe\u000e{WO\u001c;!\u0003]y\u0006O]3wS>,8\u000f\u0015:pG\u0016\u001c8o\u00119v)&lW-\u0006\u0002\u0002nA)A)a\u001c\u0002t%\u0019\u0011\u0011O#\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0011\u000b)(C\u0002\u0002x\u0015\u0013A\u0001T8oO\u0006Yr\f\u001d:fm&|Wo\u001d)s_\u000e,7o]\"qkRKW.Z0%KF$B!! \u0002\u0004B\u0019A)a \n\u0007\u0005\u0005UI\u0001\u0003V]&$\b\"CAC=\u0005\u0005\t\u0019AA7\u0003\rAH%M\u0001\u0019?B\u0014XM^5pkN\u0004&o\\2fgN\u001c\u0005/\u001e+j[\u0016\u0004\u0013a\u0001:v]R\u0011\u0011QP\u0001\bG2,\u0017M\\;q\u0003A\u0011XmY8sIB\u0013xnY3tg\u000e\u0003X/\u0001\u000bsK\u000e|'\u000f\u001a)s_\u000e,7o]+MS6LGo]\u0001\u0011?\u000e|G\u000e\\3di&|g\u000eV1tW\u0002\nab\u00185jG\u000e,\b/T8oSR|'/\u0006\u0002\u0002\u001aB\u0019\u0011q\u0002\u0013\u0003\u001b!K7mY;q\u001b>t\u0017\u000e^8s'\r!\u0013q\u0014\t\u0004=\u0006\u0005\u0016bAAR?\n1A\u000b\u001b:fC\u0012\f\u0001\u0003[5dGV\u0004H+[7f\u001b\u0016$(/[2\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,@\u0003\u0019iW\r\u001e:jG&!\u0011\u0011WAV\u0005\u0015!\u0016.\\3s\u0003!!WO]1uS>t\u0007\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m\u0016-\u0001\u0003uS6,\u0017\u0002BA`\u0003s\u0013\u0001\u0002R;sCRLwN\u001c\u000b\u0007\u00033\u000b\u0019-!2\t\u000f\u0005\u0015v\u00051\u0001\u0002(\"9\u00111W\u0014A\u0002\u0005U\u0016\u0001D0iS\u000e\u001cW\u000f\u001d(b]>\u001cXCAA:\u0003Ay\u0006.[2dkBt\u0015M\\8t?\u0012*\u0017\u000f\u0006\u0003\u0002~\u0005=\u0007\"CACS\u0005\u0005\t\u0019AA:\u00035y\u0006.[2dkBt\u0015M\\8tA!\u001a!&!6\u0011\u0007\u0011\u000b9.C\u0002\u0002Z\u0016\u0013\u0001B^8mCRLG.Z\u0001\u0007?\u0012|'+\u001e8\u0016\u0005\u0005}\u0007c\u0001#\u0002b&\u0019\u00111]#\u0003\u000f\t{w\u000e\\3b]\u0006Qq\fZ8Sk:|F%Z9\u0015\t\u0005u\u0014\u0011\u001e\u0005\n\u0003\u000bc\u0013\u0011!a\u0001\u0003?\fqa\u00183p%Vt\u0007\u0005K\u0002.\u0003+\faA]3d_J$GCBA?\u0003g\f9\u0010C\u0004\u0002v>\u0002\r!a\u001d\u0002\u000bY\fG.^3\t\u000f\u0005ex\u00061\u0001\u0002t\u0005\u0019S\r\u001f9fGR,G-\u00138uKJ4\u0018\r\u001c\"fi^,WM\u001c,bYV,7+Y7qY\u0016\u001c\u0018!\u0003;fe6Lg.\u0019;f\u00039)\b\u000fZ1uK&sG/\u001a:wC2$B!! \u0003\u0002!9\u00111W\u0019A\u0002\u0005U\u0016aD0iS\u000e\u001cW\u000f]'p]&$xN\u001d\u0011\u0002\tM$x\u000e]\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0003\u0002~\t-\u0001b\u0002B\u0007\u001f\u0001\u0007!qB\u0001\n]\u0016<8i\u001c8gS\u001e\u0004BA!\u0005\u0003 5\u0011!1\u0003\u0006\u0005\u0005+\u00119\"\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u00053\u0011Y\"\u0001\u0005usB,7/\u00194f\u0015\t\u0011i\"A\u0002d_6LAA!\t\u0003\u0014\t11i\u001c8gS\u001e\f!c\u001d;beRD\u0015nY2va6{g.\u001b;peR\u0011\u0011\u0011T\u0001\u0018!J|7-Z:t\u001b\u0016$(/[2t\u0007>dG.Z2u_J\u0004\"!W\u001a\u0014\u0005M\u001aEC\u0001B\u0015\u0005\u001d1\u0015m\u0019;pef\u001cB!N\"\u00034A\u0019!J!\u000e\n\u0007\t]2JA\u0007N_\u0012,H.\u001a$bGR|'/\u001f\u000b\u0003\u0005w\u00012A!\u00106\u001b\u0005\u0019\u0014AB2sK\u0006$X\r\u0006\u0003\u0003D\t%\u0003c\u0001&\u0003F%\u0019!qI&\u0003\r5{G-\u001e7f\u0011\u001d\u0011Ye\u000ea\u0001\u0005\u001b\n\u0001b]3ui&twm\u001d\t\u0005\u0005\u001f\u0012)FD\u0002K\u0005#J1Aa\u0015L\u00035iu\u000eZ;mK\u001a\u000b7\r^8ss&!!q\u000bB-\u0005!\u0019V\r\u001e;j]\u001e\u001c(b\u0001B*\u0017\u0002")
public class ProcessMetricsCollector
implements ScheduledAction {
    private final String _hiccupIntervalPath;
    private final TagSet _defaultTags = TagSet$.MODULE$.of("component", "process");
    private final ProcessMetrics.ProcessInstruments kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments = new ProcessMetrics.ProcessInstruments(this._defaultTags());
    private final MetricsCollectionTask _collectionTask = new MetricsCollectionTask();
    private final HiccupMonitor _hiccupMonitor = this.startHiccupMonitor();

    private String _hiccupIntervalPath() {
        return this._hiccupIntervalPath;
    }

    private TagSet _defaultTags() {
        return this._defaultTags;
    }

    public ProcessMetrics.ProcessInstruments kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments() {
        return this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments;
    }

    private MetricsCollectionTask _collectionTask() {
        return this._collectionTask;
    }

    private HiccupMonitor _hiccupMonitor() {
        return this._hiccupMonitor;
    }

    public void run() {
        this._collectionTask().run();
    }

    public void stop() {
        this._hiccupMonitor().terminate();
        this._collectionTask().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this._hiccupMonitor().updateInterval(newConfig.getDuration(this._hiccupIntervalPath()));
    }

    /*
     * WARNING - void declaration
     */
    private HiccupMonitor startHiccupMonitor() {
        void var2_2;
        Duration interval = Kamon$.MODULE$.config().getDuration(this._hiccupIntervalPath());
        HiccupMonitor monitorThread = new HiccupMonitor(this, this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().hiccups(), interval);
        monitorThread.setDaemon(true);
        monitorThread.setName("hiccup-monitor");
        monitorThread.start();
        return var2_2;
    }

    public ProcessMetricsCollector(ExecutionContext ec) {
        this._hiccupIntervalPath = "kamon.instrumentation.system.process.hiccup-monitor-interval";
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new ProcessMetricsCollector(settings.executionContext());
        }
    }

    public final class HiccupMonitor
    extends Thread {
        private final Timer hiccupTimeMetric;
        private volatile long _hiccupNanos;
        private volatile boolean _doRun;

        private long _hiccupNanos() {
            return this._hiccupNanos;
        }

        private void _hiccupNanos_$eq(long x$1) {
            this._hiccupNanos = x$1;
        }

        private boolean _doRun() {
            return this._doRun;
        }

        private void _doRun_$eq(boolean x$1) {
            this._doRun = x$1;
        }

        @Override
        public void run() {
            LongRef shortestObservedDelta = LongRef.create((long)Long.MAX_VALUE);
            while (this._doRun()) {
                long hiccupTime = HiccupMonitor.hic$1(this._hiccupNanos(), shortestObservedDelta);
                this.record(hiccupTime, this._hiccupNanos());
            }
        }

        public void record(long value, long expectedIntervalBetweenValueSamples) {
            this.hiccupTimeMetric.record(value);
            if (expectedIntervalBetweenValueSamples > 0L) {
                for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
                    this.hiccupTimeMetric.record(missingValue);
                }
            }
        }

        public void terminate() {
            this._doRun_$eq(false);
        }

        public void updateInterval(Duration duration) {
            this._hiccupNanos_$eq(duration.toNanos());
        }

        private static final long hic$1(long resolution, LongRef shortestObservedDelta$1) {
            long delta;
            block0: {
                long start2 = System.nanoTime();
                TimeUnit.NANOSECONDS.sleep(resolution);
                delta = System.nanoTime() - start2;
                if (delta >= shortestObservedDelta$1.elem) break block0;
                shortestObservedDelta$1.elem = delta;
            }
            return delta - shortestObservedDelta$1.elem;
        }

        public HiccupMonitor(ProcessMetricsCollector $outer, Timer hiccupTimeMetric, Duration duration) {
            this.hiccupTimeMetric = hiccupTimeMetric;
            this._hiccupNanos = duration.toNanos();
            this._doRun = true;
        }
    }

    private class MetricsCollectionTask {
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final int _pid;
        private final double _processorCount;
        private long[] _previousProcessCpuTime;

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private int _pid() {
            return this._pid;
        }

        private double _processorCount() {
            return this._processorCount;
        }

        private long[] _previousProcessCpuTime() {
            return this._previousProcessCpuTime;
        }

        private void _previousProcessCpuTime_$eq(long[] x$1) {
            this._previousProcessCpuTime = x$1;
        }

        public void run() {
            this.recordProcessCpu();
            this.recordProcessULimits();
        }

        public void cleanup() {
            this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().remove();
        }

        private void recordProcessCpu() {
            BoxedUnit boxedUnit;
            OSProcess process = this._os().getProcess(this._pid());
            long[] previous = this._previousProcessCpuTime();
            long[] current = new long[]{process.getKernelTime(), process.getUserTime(), process.getUpTime()};
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(previous))) {
                long kernelTime = package$.MODULE$.max(0L, current[0] - previous[0]);
                long userTime = package$.MODULE$.max(0L, current[1] - previous[1]);
                long totalTime = package$.MODULE$.max(0L, current[2] - previous[2]);
                this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().user().record(this.toPercent$1(userTime, totalTime));
                this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().system().record(this.toPercent$1(kernelTime, totalTime));
                boxedUnit = this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().combined().record(this.toPercent$1(userTime + kernelTime, totalTime));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this._previousProcessCpuTime_$eq(current);
        }

        private void recordProcessULimits() {
            OSProcess process = this._os().getProcess(this._pid());
            this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().openFilesCurrent().update((double)Math.max(process.getOpenFiles(), 0L));
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                BoxedUnit boxedUnit;
                if (Platform.isLinux()) {
                    List allLimits = FileUtil.readFile((String)String.format(new StringBuilder(13).append("/proc/").append(this._pid()).append("/limits").toString(), new Object[0]));
                    boxedUnit = ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)allLimits).asScala()).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsCollectionTask.$anonfun$recordProcessULimits$2(x$1))).map((Function1 & Serializable)openFilesLimitLine -> {
                        int openFilesLimit = ParseUtil.getNthIntValue((String)openFilesLimitLine, (int)1);
                        return this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().openFilesLimit().update((double)openFilesLimit);
                    });
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }

        public /* synthetic */ ProcessMetricsCollector kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer() {
            return ProcessMetricsCollector.this;
        }

        private final long toPercent$1(long value, long totalTime$1) {
            return totalTime$1 > 0L ? (long)(100.0 * (double)value / (double)totalTime$1 / this._processorCount()) : 0L;
        }

        public static final /* synthetic */ boolean $anonfun$recordProcessULimits$2(String x$1) {
            return x$1.toLowerCase().startsWith("max open files");
        }

        public MetricsCollectionTask() {
            if (ProcessMetricsCollector.this == null) {
                throw null;
            }
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._pid = this._os().getProcessId();
            this._processorCount = this._hal().getProcessor().getLogicalProcessorCount();
            this._previousProcessCpuTime = (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long());
        }
    }
}

