/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.pekko.instrumentations;

import java.io.Serializable;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.pekko.PekkoMetrics;
import kamon.instrumentation.pekko.PekkoMetrics$;
import kamon.instrumentation.pekko.instrumentations.ActorCellInfo;
import kamon.instrumentation.pekko.instrumentations.ActorCellInfo$;
import kamon.instrumentation.pekko.instrumentations.ActorMonitor$;
import kamon.instrumentation.pekko.instrumentations.PekkoPrivateAccess;
import kamon.metric.Counter;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanBuilder;
import kamon.util.Clock;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.dispatch.Envelope;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\rEfaB4i!\u0003\r\n!\u001d\u0005\u0006q\u00021\t!\u001f\u0005\b\u0003\u0003\u0001a\u0011AA\u0002\u0011\u001d\tY\u0001\u0001D\u0001\u0003\u0007Aq!!\u0004\u0001\r\u0003\ty\u0001C\u0004\u00028\u00011\t!!\u000f\t\u000f\u00055\u0003A\"\u0001\u0002P!9\u0011Q\u000e\u0001\u0007\u0002\u0005=\u0004bBA;\u0001\u0019\u0005\u0011q\u000f\u0005\b\u0003s\u0002a\u0011AA<\u000f\u001d\tY\b\u001bE\u0001\u0003{2aa\u001a5\t\u0002\u0005\u0005\u0005bBAB\u0017\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u000f[A\u0011AAE\u0011\u001d\tyk\u0003C\u0005\u0003cCq!a<\f\t\u0013\t\t\u0010C\u0004\u0002x.!I!!?\u0007\r\t=2\u0002\u0001B\u0019\u0011)\t),\u0005B\u0001B\u0003%\u0011q\u0017\u0005\u000b\u0005g\t\"\u0011!Q\u0001\n\u0005\u0005\u0007B\u0003B\u001b#\t\u0005\t\u0015!\u0003\u0002\f\"9\u00111Q\t\u0005\u0002\t]\u0002bBA\u0001#\u0011\u0005\u00131\u0001\u0005\u0006qF!\t%\u001f\u0005\b\u0003\u0017\tB\u0011IA\u0002\u0011\u001d\ti!\u0005C!\u0005\u0007Bq!a\u000e\u0012\t\u0003\u0012Y\u0005C\u0004\u0002NE!\tE!\u0016\t\u000f\u00055\u0014\u0003\"\u0011\u0003Z!9\u0011QO\t\u0005B\u0005]\u0004bBA=#\u0011\u0005\u0013q\u000f\u0005\b\u0005;\nB\u0011\u0002B0\u0011\u001d\u0011\u0019'\u0005C\u0005\u0005KBqAa!\u0012\t\u0013\u0011)I\u0002\u0004\u0003\u0010F!!\u0011\u0013\u0005\u000b\u0005'\u0013#Q1A\u0005\u0002\tU\u0005B\u0003BOE\t\u0005\t\u0015!\u0003\u0003\u0018\"Q!q\u0014\u0012\u0003\u0006\u0004%\tA!)\t\u0015\t\r&E!A!\u0002\u0013\t\t\u0002C\u0004\u0002\u0004\n\"\tA!*\u0007\r\t=6\u0002\u0001BY\u0011)\t)\f\u000bB\u0001B\u0003%\u0011q\u0017\u0005\u000b\u0003\u0013D#\u0011!Q\u0001\n\u0005\u0005\u0007B\u0003BZQ\t\u0005\t\u0015!\u0003\u0002B\"9\u00111\u0011\u0015\u0005\u0002\tU\u0006\"\u0003B`Q\t\u0007I\u0011\u0002Ba\u0011!\u0011i\r\u000bQ\u0001\n\t\r\u0007bBA\u0001Q\u0011\u0005\u00131\u0001\u0005\u0006q\"\"\t%\u001f\u0005\b\u0003\u0017AC\u0011IA\u0002\u0011\u001d\ti\u0001\u000bC!\u0005\u001fDq!a\u000e)\t\u0003\u00129\u000eC\u0004\u0002N!\"\tE!9\t\u000f\u00055\u0004\u0006\"\u0011\u0003f\"9\u0011Q\u000f\u0015\u0005B\u0005]\u0004bBA=Q\u0011\u0005\u0011q\u000f\u0004\u0007\u0005S\\\u0001Aa;\t\u0015\ru\u0002H!A!\u0002\u0013\u0019y\u0004\u0003\u0006\u0002Nb\u0012\t\u0011)A\u0005\u0003\u001fD!\"!.9\u0005\u0003\u0005\u000b\u0011BA\\\u0011\u001d\t\u0019\t\u000fC\u0001\u0007\u0017B\u0011b!\u00169\u0005\u0004%Iaa\u0016\t\u0011\r\u0015\u0004\b)A\u0005\u00073Bq!!\u00019\t\u0003\n\u0019\u0001C\u0003yq\u0011\u0005\u0013\u0010C\u0004\u0002\u000ea\"\tea\u001a\t\u000f\u0005]\u0002\b\"\u0011\u0004p!9\u0011Q\n\u001d\u0005B\re\u0004bBA=q\u0011\u0005\u0013q\u000f\u0004\u0007\u0007{Z\u0001aa \t\u0015\r\u0005UI!A!\u0002\u0013\u0019\u0019\t\u0003\u0006\u0002N\u0016\u0013\t\u0011)A\u0005\u0003\u001fD!\"!.F\u0005\u0003\u0005\u000b\u0011BA\\\u0011\u001d\t\u0019)\u0012C\u0001\u0007\u0013C\u0011ba%F\u0005\u0004%Iaa\u0016\t\u0011\rUU\t)A\u0005\u00073BQ\u0001_#\u0005BeDq!!\u0004F\t\u0003\u001a9\nC\u0004\u00028\u0015#\tea(\t\u000f\u00055S\t\"\u0011\u0004*\"9\u0011QN#\u0005B\r5\u0006bBA=\u000b\u0012\u0005\u0013q\u000f\u0004\b\u0005_\\\u0011\u0011\u0001By\u0011)\tiM\u0015B\u0001B\u0003%\u0011q\u001a\u0005\u000b\u0003k\u0013&\u0011!Q\u0001\n\u0005]\u0006bBAB%\u0012\u0005!1\u001f\u0005\n\u0005s\u0014\u0006\u0019!C\u0005\u0005wD\u0011B!@S\u0001\u0004%IAa@\t\u0011\r\u0015!\u000b)Q\u0005\u0003\u0003D\u0011ba\u0004S\u0005\u0004%IAa?\t\u0011\rE!\u000b)A\u0005\u0003\u0003D\u0011ba\u0005S\u0005\u0004%\tb!\u0006\t\u0011\r\r\"\u000b)A\u0005\u0007/A\u0011b!\nS\u0005\u0004%\tB!1\t\u0011\r\u001d\"\u000b)A\u0005\u0005\u0007Dq!!\u0001S\t\u0003\n\u0019\u0001C\u0003y%\u0012\u0005\u0013\u0010C\u0004\u0002\fI#\t%a\u0001\t\u000f\u00055#\u000b\"\u0011\u0004*!9\u0011Q\u000e*\u0005B\r5\u0002bBB\u0019%\u0012E11\u0007\u0005\b\u0003k\u0012F\u0011IA<\u0011\u001d\tIH\u0015C\u0001\u0003o\u0012A\"Q2u_JluN\\5u_JT!!\u001b6\u0002!%t7\u000f\u001e:v[\u0016tG/\u0019;j_:\u001c(BA6m\u0003\u0015\u0001Xm[6p\u0015\tig.A\bj]N$(/^7f]R\fG/[8o\u0015\u0005y\u0017!B6b[>t7\u0001A\n\u0003\u0001I\u0004\"a\u001d<\u000e\u0003QT\u0011!^\u0001\u0006g\u000e\fG.Y\u0005\u0003oR\u0014a!\u00118z%\u00164\u0017AF2baR,(/Z#om\u0016dw\u000e]3D_:$X\r\u001f;\u0015\u0003i\u0004\"a\u001f@\u000e\u0003qT!! 8\u0002\u000f\r|g\u000e^3yi&\u0011q\u0010 \u0002\b\u0007>tG/\u001a=u\u0003a\u0019\u0017\r\u001d;ve\u0016,eN^3m_B,G+[7fgR\fW\u000e\u001d\u000b\u0003\u0003\u000b\u00012a]A\u0004\u0013\r\tI\u0001\u001e\u0002\u0005\u0019>tw-A\u0010dCB$XO]3Qe>\u001cWm]:j]\u001e\u001cF/\u0019:u)&lWm\u001d;b[B\f\u0001d\u001c8NKN\u001c\u0018mZ3Qe>\u001cWm]:j]\u001e\u001cF/\u0019:u)!\t\t\"a\u0006\u0002\u001a\u0005u\u0001cA:\u0002\u0014%\u0019\u0011Q\u0003;\u0003\u0007\u0005s\u0017\u0010C\u0003~\t\u0001\u0007!\u0010C\u0004\u0002\u001c\u0011\u0001\r!!\u0002\u0002#\u0015tg/\u001a7pa\u0016$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002 \u0011\u0001\r!!\t\u0002\u0011\u0015tg/\u001a7pa\u0016\u0004B!a\t\u000245\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0005eSN\u0004\u0018\r^2i\u0015\rY\u00171\u0006\u0006\u0005\u0003[\ty#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003c\t1a\u001c:h\u0013\u0011\t)$!\n\u0003\u0011\u0015sg/\u001a7pa\u0016\fac\u001c8NKN\u001c\u0018mZ3Qe>\u001cWm]:j]\u001e,e\u000e\u001a\u000b\u000b\u0003w\t\t%a\u0011\u0002F\u0005%\u0003cA:\u0002>%\u0019\u0011q\b;\u0003\tUs\u0017\u000e\u001e\u0005\u0006{\u0016\u0001\rA\u001f\u0005\b\u00037)\u0001\u0019AA\u0003\u0011\u001d\t9%\u0002a\u0001\u0003\u000b\t\u0001\u0004\u001d:pG\u0016\u001c8/\u001b8h'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u001d\tY%\u0002a\u0001\u0003#\tab\u001d;bi\u00164%o\\7Ti\u0006\u0014H/A\u0005p]\u001a\u000b\u0017\u000e\\;sKR!\u00111HA)\u0011\u001d\t\u0019F\u0002a\u0001\u0003+\nqAZ1jYV\u0014X\r\u0005\u0003\u0002X\u0005\u001dd\u0002BA-\u0003GrA!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?\u0002\u0018A\u0002\u001fs_>$h(C\u0001v\u0013\r\t)\u0007^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI'a\u001b\u0003\u0013QC'o\\<bE2,'bAA3i\u0006\trN\u001c#s_B\u0004X\rZ'fgN\fw-Z:\u0015\t\u0005m\u0012\u0011\u000f\u0005\b\u0003g:\u0001\u0019AA\u0003\u0003\u0015\u0019w.\u001e8u\u0003Iyg\u000eV3s[&t\u0017\r^5p]N#\u0018M\u001d;\u0015\u0005\u0005m\u0012aB2mK\u0006tW\u000f]\u0001\r\u0003\u000e$xN]'p]&$xN\u001d\t\u0004\u0003\u007fZQ\"\u00015\u0014\u0005-\u0011\u0018A\u0002\u001fj]&$h\b\u0006\u0002\u0002~\u0005!aM]8n))\tY)!$\u0002\u0012\u0006\u0005\u0016Q\u0015\t\u0004\u0003\u007f\u0002\u0001bBAH\u001b\u0001\u0007\u0011\u0011C\u0001\nC\u000e$xN]\"fY2Dq!a%\u000e\u0001\u0004\t)*A\u0002sK\u001a\u0004B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bI#A\u0003bGR|'/\u0003\u0003\u0002 \u0006e%\u0001C!di>\u0014(+\u001a4\t\u000f\u0005\rV\u00021\u0001\u0002\u0016\u00061\u0001/\u0019:f]RDq!a*\u000e\u0001\u0004\tI+\u0001\u0004tsN$X-\u001c\t\u0005\u0003/\u000bY+\u0003\u0003\u0002.\u0006e%aC!di>\u00148+_:uK6\f\u0011d\u0019:fCR,'+Z4vY\u0006\u0014\u0018i\u0019;pe6{g.\u001b;peRQ\u00111RAZ\u0003{\u000b9-a3\t\u000f\u0005Uf\u00021\u0001\u00028\u0006A1-\u001a7m\u0013:4w\u000e\u0005\u0003\u0002\u0000\u0005e\u0016bAA^Q\ni\u0011i\u0019;pe\u000e+G\u000e\\%oM>Dq!a0\u000f\u0001\u0004\t\t-A\u0005jgR\u0013\u0018mY6fIB\u00191/a1\n\u0007\u0005\u0015GOA\u0004C_>dW-\u00198\t\u000f\u0005%g\u00021\u0001\u0002B\u0006)\u0002/\u0019:uS\u000eL\u0007/\u0019;fg&sGK]1dS:<\u0007bBAg\u001d\u0001\u0007\u0011qZ\u0001\rOJ|W\u000f]'fiJL7m\u001d\t\u0007\u0003/\n\t.!6\n\t\u0005M\u00171\u000e\u0002\u0004'\u0016\f\b\u0003BAl\u0003StA!!7\u0002f:!\u00111\\Ar\u001d\u0011\ti.!9\u000f\t\u0005m\u0013q\\\u0005\u0002_&\u0011QN\\\u0005\u0003W2L1!a:k\u00031\u0001Vm[6p\u001b\u0016$(/[2t\u0013\u0011\tY/!<\u0003+\u0005\u001bGo\u001c:He>,\b/\u00138tiJ,X.\u001a8ug*\u0019\u0011q\u001d6\u0002'\r\u0014X-\u0019;f%>,H/Z3N_:LGo\u001c:\u0015\r\u0005-\u00151_A{\u0011\u001d\t)l\u0004a\u0001\u0003oCq!!4\u0010\u0001\u0004\ty-A\fsKN|GN^3BkR|wI]8va&tw\rU1uQRQ\u00111 B\u0006\u0005O\u0011ICa\u000b\u0011\t\u0005u(Q\u0001\b\u0005\u0003\u007f\u0014\t\u0001E\u0002\u0002\\QL1Aa\u0001u\u0003\u0019\u0001&/\u001a3fM&!!q\u0001B\u0005\u0005\u0019\u0019FO]5oO*\u0019!1\u0001;\t\u000f\t5\u0001\u00031\u0001\u0003\u0010\u0005Q\u0011m\u0019;pe\u000ec\u0017m]:1\t\tE!1\u0004\t\u0007\u0003{\u0014\u0019Ba\u0006\n\t\tU!\u0011\u0002\u0002\u0006\u00072\f7o\u001d\t\u0005\u00053\u0011Y\u0002\u0004\u0001\u0005\u0019\tu!1BA\u0001\u0002\u0003\u0015\tAa\b\u0003\u0007}#\u0013'\u0005\u0003\u0003\"\u0005E\u0001cA:\u0003$%\u0019!Q\u0005;\u0003\u000f9{G\u000f[5oO\"9\u00111\u0013\tA\u0002\u0005U\u0005bBAR!\u0001\u0007\u0011Q\u0013\u0005\b\u0005[\u0001\u0002\u0019AA~\u0003)\u0019\u0018p\u001d;f[:\u000bW.\u001a\u0002\u000e)J\f7-\u001a3N_:LGo\u001c:\u0014\tE\u0011\u00181R\u0001\fgR\f'\u000f^:Ue\u0006\u001cW-A\u0004n_:LGo\u001c:\u0015\u0011\te\"Q\bB \u0005\u0003\u00022Aa\u000f\u0012\u001b\u0005Y\u0001bBA[+\u0001\u0007\u0011q\u0017\u0005\b\u0005g)\u0002\u0019AAa\u0011\u001d\u0011)$\u0006a\u0001\u0003\u0017#\u0002\"!\u0005\u0003F\t\u001d#\u0011\n\u0005\u0006{f\u0001\rA\u001f\u0005\b\u00037I\u0002\u0019AA\u0003\u0011\u001d\ty\"\u0007a\u0001\u0003C!\"\"a\u000f\u0003N\t=#\u0011\u000bB*\u0011\u0015i(\u00041\u0001{\u0011\u001d\tYB\u0007a\u0001\u0003\u000bAq!a\u0012\u001b\u0001\u0004\t)\u0001C\u0004\u0002Li\u0001\r!!\u0005\u0015\t\u0005m\"q\u000b\u0005\b\u0003'Z\u0002\u0019AA+)\u0011\tYDa\u0017\t\u000f\u0005MD\u00041\u0001\u0002\u0006\u0005\u0019R\r\u001f;sC\u000e$X*Z:tC\u001e,7\t\\1tgR!\u00111 B1\u0011\u001d\tyb\ba\u0001\u0003C\t\u0011BY;jY\u0012\u001c\u0006/\u00198\u0015\u0015\t\u001d$1\u0010B?\u0005\u007f\u0012\t\t\u0005\u0003\u0003j\tUd\u0002\u0002B6\u0005cj!A!\u001c\u000b\u0007\t=d.A\u0003ue\u0006\u001cW-\u0003\u0003\u0003t\t5\u0014\u0001B*qC:LAAa\u001e\u0003z\t9A)\u001a7bs\u0016$'\u0002\u0002B:\u0005[Bq!!.!\u0001\u0004\t9\fC\u0003~A\u0001\u0007!\u0010C\u0004\u0002\u001c\u0001\u0002\r!!\u0002\t\u000f\u0005}\u0001\u00051\u0001\u0002\"\u0005iq\u000e]3sCRLwN\u001c(b[\u0016$b!a?\u0003\b\n-\u0005b\u0002BEC\u0001\u0007\u00111`\u0001\r[\u0016\u001c8/Y4f\u00072\f7o\u001d\u0005\b\u0005\u001b\u000b\u0003\u0019AAK\u0003\u0019\u0019XM\u001c3fe\n\u00192\u000b]1o\u0003:$Wj\u001c8ji>\u00148\u000b^1uKN\u0011!E]\u0001\u0005gB\fg.\u0006\u0002\u0003\u0018B!!1\u000eBM\u0013\u0011\u0011YJ!\u001c\u0003\tM\u0003\u0018M\\\u0001\u0006gB\fg\u000eI\u0001\u0014oJ\f\u0007\u000f]3e\u001b>t\u0017\u000e^8s'R\fG/Z\u000b\u0003\u0003#\tAc\u001e:baB,G-T8oSR|'o\u0015;bi\u0016\u0004CC\u0002BT\u0005W\u0013i\u000bE\u0002\u0003*\nj\u0011!\u0005\u0005\b\u0005';\u0003\u0019\u0001BL\u0011\u001d\u0011yj\na\u0001\u0003#\u0011acQ8oi\u0016DH\u000f\u0015:pa\u0006<\u0017\r^5p]>sG._\n\u0005QI\fY)A\tue\u0006\u001c7.Q2uSZ,\u0017i\u0019;peN$\u0002Ba.\u0003:\nm&Q\u0018\t\u0004\u0005wA\u0003bBA[Y\u0001\u0007\u0011q\u0017\u0005\b\u0003\u0013d\u0003\u0019AAa\u0011\u001d\u0011\u0019\f\fa\u0001\u0003\u0003\fabX:zgR,W.T3ue&\u001c7/\u0006\u0002\u0003DB!!Q\u0019Be\u001d\u0011\u00119-!:\u000e\u0003)LAAa3\u0002n\n1\u0012i\u0019;peNK8\u000f^3n\u0013:\u001cHO];nK:$8/A\b`gf\u001cH/Z7NKR\u0014\u0018nY:!)!\t\tB!5\u0003T\nU\u0007\"B?3\u0001\u0004Q\bbBA\u000ee\u0001\u0007\u0011Q\u0001\u0005\b\u0003?\u0011\u0004\u0019AA\u0011))\tYD!7\u0003\\\nu'q\u001c\u0005\u0006{N\u0002\rA\u001f\u0005\b\u00037\u0019\u0004\u0019AA\u0003\u0011\u001d\t9e\ra\u0001\u0003\u000bAq!a\u00134\u0001\u0004\t\t\u0002\u0006\u0003\u0002<\t\r\bbBA*i\u0001\u0007\u0011Q\u000b\u000b\u0005\u0003w\u00119\u000fC\u0004\u0002tU\u0002\r!!\u0002\u0003\u0019Q\u0013\u0018mY6fI\u0006\u001bGo\u001c:\u0014\u0007a\u0012i\u000fE\u0002\u0003<I\u0013\u0011d\u0012:pkBlU\r\u001e:jGN$&/Y2lS:<\u0017i\u0019;peN!!K]AF)\u0019\u0011iO!>\u0003x\"9\u0011QZ+A\u0002\u0005=\u0007bBA[+\u0002\u0007\u0011qW\u0001\t?&\u001c\u0018\t\\5wKV\u0011\u0011\u0011Y\u0001\r?&\u001c\u0018\t\\5wK~#S-\u001d\u000b\u0005\u0003w\u0019\t\u0001C\u0005\u0004\u0004]\u000b\t\u00111\u0001\u0002B\u0006\u0019\u0001\u0010J\u0019\u0002\u0013}K7/\u00117jm\u0016\u0004\u0003f\u0001-\u0004\nA\u00191oa\u0003\n\u0007\r5AO\u0001\u0005w_2\fG/\u001b7f\u0003ay6\u000f[8vY\u0012$&/Y2l\u0003\u000e$\u0018N^3BGR|'o]\u0001\u001a?NDw.\u001e7e)J\f7m[!di&4X-Q2u_J\u001c\b%A\u0003dY>\u001c7.\u0006\u0002\u0004\u0018A!1\u0011DB\u0010\u001b\t\u0019YBC\u0002\u0004\u001e9\fA!\u001e;jY&!1\u0011EB\u000e\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005i1/_:uK6lU\r\u001e:jGN\fab]=ti\u0016lW*\u001a;sS\u000e\u001c\b\u0005\u0006\u0003\u0002<\r-\u0002bBA*E\u0002\u0007\u0011Q\u000b\u000b\u0005\u0003w\u0019y\u0003C\u0004\u0002t\r\u0004\r!!\u0002\u0002%I,7m\u001c:e\u000fJ|W\u000f]'fiJL7m\u001d\u000b\u0007\u0003w\u0019)d!\u000f\t\u000f\r]B\r1\u0001\u0002\u0006\u0005q\u0001O]8dKN\u001c\u0018N\\4US6,\u0007bBB\u001eI\u0002\u0007\u0011QA\u0001\u000ei&lW-\u00138NC&d'm\u001c=\u0002\u0019\u0005\u001cGo\u001c:NKR\u0014\u0018nY:\u0011\u000bM\u001c\te!\u0012\n\u0007\r\rCO\u0001\u0004PaRLwN\u001c\t\u0005\u0003/\u001c9%\u0003\u0003\u0004J\u00055(\u0001E!di>\u0014\u0018J\\:ueVlWM\u001c;t)!\u0019iea\u0014\u0004R\rM\u0003c\u0001B\u001eq!91Q\b\u001fA\u0002\r}\u0002bBAgy\u0001\u0007\u0011q\u001a\u0005\b\u0003kc\u0004\u0019AA\\\u0003ey\u0006O]8dKN\u001cX\rZ'fgN\fw-Z:D_VtG/\u001a:\u0016\u0005\re\u0003\u0003BB.\u0007Cj!a!\u0018\u000b\u0007\r}c.\u0001\u0004nKR\u0014\u0018nY\u0005\u0005\u0007G\u001aiFA\u0004D_VtG/\u001a:\u00025}\u0003(o\\2fgN,G-T3tg\u0006<Wm]\"pk:$XM\u001d\u0011\u0015\u0011\u0005E1\u0011NB6\u0007[BQ!`!A\u0002iDq!a\u0007B\u0001\u0004\t)\u0001C\u0004\u0002 \u0005\u0003\r!!\t\u0015\u0015\u0005m2\u0011OB:\u0007k\u001a9\bC\u0003~\u0005\u0002\u0007!\u0010C\u0004\u0002\u001c\t\u0003\r!!\u0002\t\u000f\u0005\u001d#\t1\u0001\u0002\u0006!9\u00111\n\"A\u0002\u0005EA\u0003BA\u001e\u0007wBq!a\u0015D\u0001\u0004\t)FA\u0007Ue\u0006\u001c7.\u001a3S_V$X-Z\n\u0004\u000b\n5\u0018!\u0004:pkR,'/T3ue&\u001c7\u000f\u0005\u0003\u0002X\u000e\u0015\u0015\u0002BBD\u0003[\u0014\u0011CU8vi\u0016\u0014\u0018J\\:ueVlWM\u001c;t)!\u0019Yi!$\u0004\u0010\u000eE\u0005c\u0001B\u001e\u000b\"91\u0011Q%A\u0002\r\r\u0005bBAg\u0013\u0002\u0007\u0011q\u001a\u0005\b\u0003kK\u0005\u0019AA\\\u0003a\u0001(o\\2fgN,G-T3tg\u0006<Wm]\"pk:$XM]\u0001\u001aaJ|7-Z:tK\u0012lUm]:bO\u0016\u001c8i\\;oi\u0016\u0014\b\u0005\u0006\u0005\u0002\u0012\re51TBO\u0011\u0015iX\n1\u0001{\u0011\u001d\tY\"\u0014a\u0001\u0003\u000bAq!a\bN\u0001\u0004\t\t\u0003\u0006\u0006\u0002<\r\u000561UBS\u0007OCQ! (A\u0002iDq!a\u0007O\u0001\u0004\t)\u0001C\u0004\u0002H9\u0003\r!!\u0002\t\u000f\u0005-c\n1\u0001\u0002\u0012Q!\u00111HBV\u0011\u001d\t\u0019f\u0014a\u0001\u0003+\"B!a\u000f\u00040\"9\u00111\u000f)A\u0002\u0005\u0015\u0001")
public interface ActorMonitor {
    public static ActorMonitor from(Object actorCell, ActorRef ref, ActorRef parent, ActorSystem system) {
        return ActorMonitor$.MODULE$.from(actorCell, ref, parent, system);
    }

    public Context captureEnvelopeContext();

    public long captureEnvelopeTimestamp();

    public long captureProcessingStartTimestamp();

    public Object onMessageProcessingStart(Context var1, long var2, Envelope var4);

    public void onMessageProcessingEnd(Context var1, long var2, long var4, Object var6);

    public void onFailure(Throwable var1);

    public void onDroppedMessages(long var1);

    public void onTerminationStart();

    public void cleanup();

    public static class ContextPropagationOnly
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean participatesInTracing;
        private final boolean trackActiveActors;
        private final PekkoMetrics.ActorSystemInstruments _systemMetrics;

        private PekkoMetrics.ActorSystemInstruments _systemMetrics() {
            return this._systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.participatesInTracing ? Kamon$.MODULE$.clock().nanos() : 0L;
        }

        @Override
        public Context captureEnvelopeContext() {
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.participatesInTracing ? Kamon$.MODULE$.clock().nanos() : 0L;
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._systemMetrics().processedMessagesByNonTracked().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            ((Storage.Scope)stateFromStart).close();
        }

        @Override
        public void onFailure(Throwable failure) {
        }

        @Override
        public void onDroppedMessages(long count) {
        }

        @Override
        public void onTerminationStart() {
        }

        @Override
        public void cleanup() {
            block0: {
                if (!this.trackActiveActors || this.cellInfo.isTemporary()) break block0;
                this._systemMetrics().activeActors().decrement();
            }
        }

        public ContextPropagationOnly(ActorCellInfo cellInfo, boolean participatesInTracing, boolean trackActiveActors) {
            this.cellInfo = cellInfo;
            this.participatesInTracing = participatesInTracing;
            this.trackActiveActors = trackActiveActors;
            this._systemMetrics = PekkoMetrics$.MODULE$.forSystem(cellInfo.systemName());
            Object object = trackActiveActors && !cellInfo.isTemporary() ? this._systemMetrics().activeActors().increment() : BoxedUnit.UNIT;
        }
    }

    public static abstract class GroupMetricsTrackingActor
    implements ActorMonitor {
        private final Seq<PekkoMetrics.ActorGroupInstruments> groupMetrics;
        private final ActorCellInfo cellInfo;
        private volatile boolean _isAlive;
        private final boolean _shouldTrackActiveActors;
        private final Clock clock;
        private final PekkoMetrics.ActorSystemInstruments systemMetrics;

        private boolean _isAlive() {
            return this._isAlive;
        }

        private void _isAlive_$eq(boolean x$1) {
            this._isAlive = x$1;
        }

        private boolean _shouldTrackActiveActors() {
            return this._shouldTrackActiveActors;
        }

        public Clock clock() {
            return this.clock;
        }

        public PekkoMetrics.ActorSystemInstruments systemMetrics() {
            return this.systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public Context captureEnvelopeContext() {
            block0: {
                if (!this._isAlive() || this.cellInfo.isTemporary()) break block0;
                this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.pendingMessages().increment());
            }
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public void onFailure(Throwable failure) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.errors().increment());
        }

        @Override
        public void onDroppedMessages(long count) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.pendingMessages().decrement(count));
        }

        public void recordGroupMetrics(long processingTime, long timeInMailbox) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> {
                gm.processingTime().record(processingTime);
                gm.timeInMailbox().record(timeInMailbox);
                return gm.pendingMessages().decrement();
            });
        }

        @Override
        public void onTerminationStart() {
            this._isAlive_$eq(false);
        }

        @Override
        public void cleanup() {
            block0: {
                if (!this._shouldTrackActiveActors()) break block0;
                this.systemMetrics().activeActors().decrement();
                this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.members().decrement());
            }
        }

        public GroupMetricsTrackingActor(Seq<PekkoMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            block0: {
                this.groupMetrics = groupMetrics;
                this.cellInfo = cellInfo;
                this._isAlive = true;
                this._shouldTrackActiveActors = !cellInfo.isTemporary();
                this.clock = Kamon$.MODULE$.clock();
                this.systemMetrics = PekkoMetrics$.MODULE$.forSystem(cellInfo.systemName());
                if (!this._shouldTrackActiveActors()) break block0;
                this.systemMetrics().activeActors().increment();
                groupMetrics.foreach((Function1 & Serializable)gm -> gm.members().increment());
            }
        }
    }

    public static class TracedMonitor
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean startsTrace;
        private final ActorMonitor monitor;

        @Override
        public long captureEnvelopeTimestamp() {
            return this.monitor.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            return this.monitor.captureEnvelopeContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.monitor.captureProcessingStartTimestamp();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            SpanAndMonitorState spanAndMonitorState;
            Context incomingContext = context;
            if (((Span)incomingContext.get(Span$.MODULE$.Key())).isEmpty() && !this.startsTrace) {
                spanAndMonitorState = new SpanAndMonitorState(this, null, this.monitor.onMessageProcessingStart(context, envelopeTimestamp, envelope));
            } else {
                Span.Delayed messageSpan = this.buildSpan(this.cellInfo, context, envelopeTimestamp, envelope).start();
                Context contextWithMessageSpan = incomingContext.withEntry(Span$.MODULE$.Key(), (Object)messageSpan);
                spanAndMonitorState = new SpanAndMonitorState(this, (Span)messageSpan, this.monitor.onMessageProcessingStart(contextWithMessageSpan, envelopeTimestamp, envelope));
            }
            return spanAndMonitorState;
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            block0: {
                SpanAndMonitorState spanAndMonitor = (SpanAndMonitorState)stateFromStart;
                this.monitor.onMessageProcessingEnd(context, envelopeTimestamp, processingStartTimestamp, spanAndMonitor.wrappedMonitorState());
                if (spanAndMonitor.span() == null) break block0;
                spanAndMonitor.span().finish();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.monitor.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            this.monitor.onDroppedMessages(count);
        }

        @Override
        public void onTerminationStart() {
            this.monitor.onTerminationStart();
        }

        @Override
        public void cleanup() {
            this.monitor.cleanup();
        }

        private String extractMessageClass(Envelope envelope) {
            return ActorCellInfo$.MODULE$.simpleClassName(envelope.message().getClass());
        }

        private Span.Delayed buildSpan(ActorCellInfo cellInfo, Context context, long envelopeTimestamp, Envelope envelope) {
            String messageClass = this.extractMessageClass(envelope);
            Span parentSpan = (Span)context.get(Span$.MODULE$.Key());
            SpanBuilder spanBuilder = Kamon$.MODULE$.internalSpanBuilder(this.operationName(messageClass, envelope.sender()), "pekko.actor").asChildOf(parentSpan).doNotTrackMetrics().tag("pekko.system", cellInfo.systemName()).tag("pekko.actor.path", cellInfo.path()).tag("pekko.actor.message-class", messageClass);
            Object object = !ActorCellInfo$.MODULE$.isTyped(cellInfo.actorOrRouterClass()) ? spanBuilder.tag("pekko.actor.class", cellInfo.actorOrRouterClass().getName()) : BoxedUnit.UNIT;
            return spanBuilder.delay(Kamon$.MODULE$.clock().toInstant(envelopeTimestamp));
        }

        private String operationName(String messageClass, ActorRef sender) {
            String operationType = PekkoPrivateAccess.isPromiseActorRef(sender) ? "ask" : "tell";
            return package$.MODULE$.StringBuilder().newBuilder().append(operationType).append("(").append(messageClass).append(")").result();
        }

        public TracedMonitor(ActorCellInfo cellInfo, boolean startsTrace, ActorMonitor monitor) {
            this.cellInfo = cellInfo;
            this.startsTrace = startsTrace;
            this.monitor = monitor;
        }

        private class SpanAndMonitorState {
            private final Span span;
            private final Object wrappedMonitorState;
            public final /* synthetic */ TracedMonitor $outer;

            public Span span() {
                return this.span;
            }

            public Object wrappedMonitorState() {
                return this.wrappedMonitorState;
            }

            public /* synthetic */ TracedMonitor kamon$instrumentation$pekko$instrumentations$ActorMonitor$TracedMonitor$SpanAndMonitorState$$$outer() {
                return this.$outer;
            }

            public SpanAndMonitorState(TracedMonitor $outer, Span span, Object wrappedMonitorState) {
                this.span = span;
                this.wrappedMonitorState = wrappedMonitorState;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }

    public static class TrackedActor
    extends GroupMetricsTrackingActor {
        private final Option<PekkoMetrics.ActorInstruments> actorMetrics;
        private final Counter _processedMessagesCounter;

        private Counter _processedMessagesCounter() {
            return this._processedMessagesCounter;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return super.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            this.actorMetrics.foreach((Function1 & Serializable)am -> am.mailboxSize().increment());
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = this.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.actorMetrics.foreach((Function1 & Serializable)am -> {
                    am.processingTime().record(processingTime);
                    am.timeInMailbox().record(timeInMailbox);
                    return am.mailboxSize().decrement();
                });
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.actorMetrics.foreach((Function1 & Serializable)am -> am.errors().increment());
            super.onFailure(failure);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.actorMetrics.foreach((Function1 & Serializable)x$2 -> {
                x$2.remove();
                return BoxedUnit.UNIT;
            });
        }

        public TrackedActor(Option<PekkoMetrics.ActorInstruments> actorMetrics, Seq<PekkoMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.actorMetrics = actorMetrics;
            super(groupMetrics, cellInfo);
            this._processedMessagesCounter = PekkoMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }

    public static class TrackedRoutee
    extends GroupMetricsTrackingActor {
        private final PekkoMetrics.RouterInstruments routerMetrics;
        private final Counter processedMessagesCounter;

        private Counter processedMessagesCounter() {
            return this.processedMessagesCounter;
        }

        @Override
        public Context captureEnvelopeContext() {
            this.routerMetrics.pendingMessages().increment();
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this.processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = Kamon$.MODULE$.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.routerMetrics.processingTime().record(processingTime);
                this.routerMetrics.timeInMailbox().record(timeInMailbox);
                this.routerMetrics.pendingMessages().decrement();
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.routerMetrics.errors().increment();
            super.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            super.onDroppedMessages(count);
            this.routerMetrics.pendingMessages().decrement(count);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.routerMetrics.members().decrement();
        }

        public TrackedRoutee(PekkoMetrics.RouterInstruments routerMetrics, Seq<PekkoMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.routerMetrics = routerMetrics;
            super(groupMetrics, cellInfo);
            routerMetrics.members().increment();
            this.processedMessagesCounter = PekkoMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }
}

