/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.KSQLJoinWindow;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Join
extends ASTNodeAccessImpl {
    private boolean outer = false;
    private boolean right = false;
    private boolean left = false;
    private boolean natural = false;
    private boolean full = false;
    private boolean inner = false;
    private boolean simple = false;
    private boolean cross = false;
    private boolean semi = false;
    private boolean straight = false;
    private boolean apply = false;
    private FromItem rightItem;
    private Expression onExpression;
    private List<Column> usingColumns;
    private KSQLJoinWindow joinWindow;

    public boolean isSimple() {
        return this.simple;
    }

    public Join withSimple(boolean b) {
        this.setSimple(b);
        return this;
    }

    public void setSimple(boolean b) {
        this.simple = b;
    }

    public boolean isInner() {
        return this.inner;
    }

    public Join withInner(boolean b) {
        this.setInner(b);
        return this;
    }

    public void setInner(boolean b) {
        this.inner = b;
    }

    public boolean isStraight() {
        return this.straight;
    }

    public Join withStraight(boolean b) {
        this.setStraight(b);
        return this;
    }

    public void setStraight(boolean b) {
        this.straight = b;
    }

    public boolean isOuter() {
        return this.outer;
    }

    public Join withOuter(boolean b) {
        this.setOuter(b);
        return this;
    }

    public void setOuter(boolean b) {
        this.outer = b;
    }

    public boolean isApply() {
        return this.apply;
    }

    public Join withApply(boolean apply) {
        this.setApply(apply);
        return this;
    }

    public void setApply(boolean apply) {
        this.apply = apply;
    }

    public boolean isSemi() {
        return this.semi;
    }

    public Join withSemi(boolean b) {
        this.setSemi(b);
        return this;
    }

    public void setSemi(boolean b) {
        this.semi = b;
    }

    public boolean isLeft() {
        return this.left;
    }

    public Join withLeft(boolean b) {
        this.setLeft(b);
        return this;
    }

    public void setLeft(boolean b) {
        this.left = b;
    }

    public boolean isRight() {
        return this.right;
    }

    public Join withRight(boolean b) {
        this.setRight(b);
        return this;
    }

    public void setRight(boolean b) {
        this.right = b;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public Join withNatural(boolean b) {
        this.setNatural(b);
        return this;
    }

    public void setNatural(boolean b) {
        this.natural = b;
    }

    public boolean isFull() {
        return this.full;
    }

    public Join withFull(boolean b) {
        this.setFull(b);
        return this;
    }

    public void setFull(boolean b) {
        this.full = b;
    }

    public boolean isCross() {
        return this.cross;
    }

    public Join withCross(boolean cross) {
        this.setCross(cross);
        return this;
    }

    public void setCross(boolean cross) {
        this.cross = cross;
    }

    public FromItem getRightItem() {
        return this.rightItem;
    }

    public Join withRightItem(FromItem item) {
        this.setRightItem(item);
        return this;
    }

    public void setRightItem(FromItem item) {
        this.rightItem = item;
    }

    public Expression getOnExpression() {
        return this.onExpression;
    }

    public Join withOnExpression(Expression expression) {
        this.setOnExpression(expression);
        return this;
    }

    public void setOnExpression(Expression expression) {
        this.onExpression = expression;
    }

    public List<Column> getUsingColumns() {
        return this.usingColumns;
    }

    public Join withUsingColumns(List<Column> list) {
        this.setUsingColumns(list);
        return this;
    }

    public void setUsingColumns(List<Column> list) {
        this.usingColumns = list;
    }

    public boolean isWindowJoin() {
        return this.joinWindow != null;
    }

    public KSQLJoinWindow getJoinWindow() {
        return this.joinWindow;
    }

    public Join withJoinWindow(KSQLJoinWindow joinWindow) {
        this.setJoinWindow(joinWindow);
        return this;
    }

    public void setJoinWindow(KSQLJoinWindow joinWindow) {
        this.joinWindow = joinWindow;
    }

    public String toString() {
        if (this.isSimple() && this.isOuter()) {
            return "OUTER " + this.rightItem;
        }
        if (this.isSimple()) {
            return "" + this.rightItem;
        }
        String type = "";
        if (this.isRight()) {
            type = type + "RIGHT ";
        } else if (this.isNatural()) {
            type = type + "NATURAL ";
        } else if (this.isFull()) {
            type = type + "FULL ";
        } else if (this.isLeft()) {
            type = type + "LEFT ";
        } else if (this.isCross()) {
            type = type + "CROSS ";
        }
        if (this.isOuter()) {
            type = type + "OUTER ";
        } else if (this.isInner()) {
            type = type + "INNER ";
        } else if (this.isSemi()) {
            type = type + "SEMI ";
        }
        type = this.isStraight() ? "STRAIGHT_JOIN " : (this.isApply() ? type + "APPLY " : type + "JOIN ");
        return type + this.rightItem + (this.joinWindow != null ? " WITHIN " + this.joinWindow : "") + (this.onExpression != null ? " ON " + this.onExpression + "" : "") + PlainSelect.getFormatedList(this.usingColumns, "USING", true, true);
    }

    public Join addUsingColumns(Column ... usingColumns) {
        List collection = Optional.ofNullable(this.getUsingColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, usingColumns);
        return this.withUsingColumns(collection);
    }

    public Join addUsingColumns(Collection<? extends Column> usingColumns) {
        List collection = Optional.ofNullable(this.getUsingColumns()).orElseGet(ArrayList::new);
        collection.addAll(usingColumns);
        return this.withUsingColumns(collection);
    }

    public <E extends FromItem> E getRightItem(Class<E> type) {
        return (E)((FromItem)type.cast(this.getRightItem()));
    }

    public <E extends Expression> E getOnExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getOnExpression()));
    }
}

