/*
 * Decompiled with CFR 0.152.
 */
package kamon.lib.com.github.benmanes.caffeine.cache;

import kamon.lib.com.github.benmanes.caffeine.cache.BoundedWeigher;
import kamon.lib.com.github.benmanes.caffeine.cache.SingletonWeigher;
import kamon.lib.org.checkerframework.checker.index.qual.NonNegative;
import kamon.lib.org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface Weigher<K, V> {
    public @NonNegative int weigh(@NonNull K var1, @NonNull V var2);

    public static <K, V> @NonNull Weigher<K, V> singletonWeigher() {
        SingletonWeigher self = SingletonWeigher.INSTANCE;
        return self;
    }

    public static <K, V> @NonNull Weigher<K, V> boundedWeigher(@NonNull Weigher<K, V> delegate) {
        return new BoundedWeigher<K, V>(delegate);
    }
}

